/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.jurassic.morrison;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.common.entities.jurassic.morrison.EilenodonEntity;

@OnlyIn(value=Dist.CLIENT)
public class EilenodonModel
extends EntityModel<EilenodonEntity> {
    public ModelRenderer Body;
    public ModelRenderer BackSpine;
    public ModelRenderer ArmL;
    public ModelRenderer ArmR;
    public ModelRenderer LegL;
    public ModelRenderer LegR;
    public ModelRenderer Tail;
    public ModelRenderer Neck;
    public ModelRenderer Head;
    public ModelRenderer HeadSpine;
    public ModelRenderer Dewlap;

    public EilenodonModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.Body = new ModelRenderer((Model)this, 0, 0);
        this.Body.func_78793_a(0.0f, 22.0f, 2.0f);
        this.Body.func_228302_a_(-2.0f, -2.0f, -5.0f, 4.0f, 3.0f, 7.0f, 0.0f, 0.0f, 0.0f);
        this.ArmR = new ModelRenderer((Model)this, 28, 5);
        this.ArmR.func_78793_a(-2.0f, -1.0f, -4.0f);
        this.ArmR.func_228302_a_(-1.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.HeadSpine = new ModelRenderer((Model)this, 9, 17);
        this.HeadSpine.func_78793_a(0.0f, -2.5f, -1.0f);
        this.HeadSpine.func_228302_a_(0.0f, -0.5f, -1.0f, 0.0f, 1.0f, 3.0f, 0.0f, 0.0f, 0.0f);
        this.LegR = new ModelRenderer((Model)this, 35, 5);
        this.LegR.func_78793_a(-2.0f, -1.0f, 1.0f);
        this.LegR.func_228302_a_(-1.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.Neck = new ModelRenderer((Model)this, 0, 12);
        this.Neck.func_78793_a(0.0f, -1.0f, -5.0f);
        this.Neck.func_228302_a_(-1.0f, -2.0f, -2.0f, 2.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.Tail = new ModelRenderer((Model)this, 18, 11);
        this.Tail.func_78793_a(0.0f, 0.0f, 2.0f);
        this.Tail.func_228302_a_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 9.0f, 0.0f, 0.0f, 0.0f);
        this.BackSpine = new ModelRenderer((Model)this, 0, 17);
        this.BackSpine.func_78793_a(0.0f, -2.5f, -4.0f);
        this.BackSpine.func_228302_a_(0.0f, -0.5f, -1.0f, 0.0f, 2.0f, 8.0f, 0.0f, 0.0f, 0.0f);
        this.LegL = new ModelRenderer((Model)this, 35, 0);
        this.LegL.func_78793_a(2.0f, -1.0f, 1.0f);
        this.LegL.func_228302_a_(0.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.Head = new ModelRenderer((Model)this, 0, 18);
        this.Head.func_78793_a(0.0f, -1.0f, -2.0f);
        this.Head.func_228302_a_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.ArmL = new ModelRenderer((Model)this, 28, 0);
        this.ArmL.func_78793_a(2.0f, -1.0f, -4.0f);
        this.ArmL.func_228302_a_(0.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.Dewlap = new ModelRenderer((Model)this, 9, 11);
        this.Dewlap.func_78793_a(0.0f, 2.0f, 0.0f);
        this.Dewlap.func_228302_a_(0.0f, -1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.Body.func_78792_a(this.ArmR);
        this.Neck.func_78792_a(this.HeadSpine);
        this.Body.func_78792_a(this.LegR);
        this.Body.func_78792_a(this.Neck);
        this.Body.func_78792_a(this.Tail);
        this.Body.func_78792_a(this.BackSpine);
        this.Body.func_78792_a(this.LegL);
        this.Neck.func_78792_a(this.Head);
        this.Body.func_78792_a(this.ArmL);
        this.Head.func_78792_a(this.Dewlap);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.Body).forEach(modelRenderer -> modelRenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public void setRotationAngles(EilenodonEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetModel();
        if (entityIn.func_233685_eM_() && !entityIn.isAsleep()) {
            this.Body.field_78797_d = 23.0f;
            this.LegL.field_78797_d = 1.0f;
            this.LegL.field_78808_h = -1.5707964f;
            this.ArmL.field_78797_d = 1.0f;
            this.ArmL.field_78808_h = -1.5707964f;
            this.LegR.field_78797_d = 1.0f;
            this.LegR.field_78808_h = 1.5707964f;
            this.ArmR.field_78797_d = 1.0f;
            this.ArmR.field_78808_h = 1.5707964f;
            this.Tail.field_78796_g = -0.12f * MathHelper.func_76126_a((float)(0.2f * ageInTicks / 5.0f));
            this.Tail.field_78795_f = -Math.abs(-0.05f * MathHelper.func_76126_a((float)(0.1f * ageInTicks / 5.0f)));
            this.Neck.field_78795_f = -0.12f * MathHelper.func_76126_a((float)(0.2f * ageInTicks / 5.0f));
        } else if (entityIn.isAsleep()) {
            this.Body.field_78797_d = 23.0f;
            this.LegL.field_78797_d = 1.0f;
            this.LegL.field_78808_h = -1.5707964f;
            this.ArmL.field_78797_d = 1.0f;
            this.ArmL.field_78808_h = -1.5707964f;
            this.LegR.field_78797_d = 1.0f;
            this.LegR.field_78808_h = 1.5707964f;
            this.ArmR.field_78797_d = 1.0f;
            this.ArmR.field_78808_h = 1.5707964f;
            this.Neck.field_78798_e = -4.8f;
            this.Neck.field_78795_f = 0.19547687f;
            this.Neck.field_78796_g = 0.27366763f;
            this.Neck.field_78808_h = -1.2901473f;
        } else {
            this.Neck.field_78795_f = headPitch * ((float)Math.PI / 180);
            this.Neck.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
            this.LegR.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LegL.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.ArmR.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.ArmL.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.Tail.field_78796_g = -0.12f * MathHelper.func_76126_a((float)(0.2f * ageInTicks / 5.0f));
            this.Tail.field_78795_f = -Math.abs(-0.05f * MathHelper.func_76126_a((float)(0.1f * ageInTicks / 5.0f)));
            this.Neck.field_78795_f = -0.12f * MathHelper.func_76126_a((float)(0.2f * ageInTicks / 5.0f));
            if (entityIn.isEating()) {
                this.Neck.field_78795_f = Math.abs(MathHelper.func_76126_a((float)(0.05f * ageInTicks)) * 0.45f) + 0.5f;
            }
            if (entityIn.func_70090_H()) {
                this.ArmL.field_78795_f = 0.25f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
                this.ArmR.field_78795_f = 0.25f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
                this.LegR.field_78795_f = -0.25f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
                this.LegL.field_78795_f = -0.25f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
                this.Tail.field_78796_g = MathHelper.func_76134_b((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Body.field_78797_d = 22.0f;
        this.LegL.field_78797_d = -1.0f;
        this.LegL.field_78808_h = 0.0f;
        this.LegL.field_78795_f = 0.0f;
        this.LegL.field_78796_g = 0.0f;
        this.ArmL.field_78797_d = -1.0f;
        this.ArmL.field_78808_h = 0.0f;
        this.ArmL.field_78795_f = 0.0f;
        this.ArmL.field_78796_g = 0.0f;
        this.LegR.field_78797_d = -1.0f;
        this.LegR.field_78808_h = 0.0f;
        this.LegR.field_78795_f = 0.0f;
        this.LegR.field_78796_g = 0.0f;
        this.ArmR.field_78797_d = -1.0f;
        this.ArmR.field_78808_h = 0.0f;
        this.ArmR.field_78795_f = 0.0f;
        this.ArmR.field_78796_g = 0.0f;
        this.Neck.field_78795_f = 0.0f;
        this.Tail.field_78795_f = 0.0f;
        this.Tail.field_78796_g = 0.0f;
        this.Neck.field_78795_f = 0.0f;
        this.Neck.field_78796_g = 0.0f;
        this.Neck.field_78808_h = 0.0f;
        this.Neck.field_78798_e = -5.0f;
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

