/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.jurassic.kayenta;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.common.entities.jurassic.kayenta.KayentatheriumEntity;

@OnlyIn(value=Dist.CLIENT)
public class KayentatheriumModel
extends EntityModel<KayentatheriumEntity> {
    public ModelRenderer Body;
    public ModelRenderer Head;
    public ModelRenderer RightArm;
    public ModelRenderer LeftArm;
    public ModelRenderer RightLeg;
    public ModelRenderer LeftLeg;
    public ModelRenderer Tail;

    public KayentatheriumModel() {
        this.field_78090_t = 35;
        this.field_78089_u = 50;
        this.Head = new ModelRenderer((Model)this, 0, 0);
        this.Head.func_78793_a(0.0f, 1.0f, 1.0f);
        this.Head.func_78784_a(10, 0).func_228302_a_(-1.5f, -2.0f, -5.0f, 3.0f, 3.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.RightArm = new ModelRenderer((Model)this, 0, 0);
        this.RightArm.func_78793_a(1.5f, 3.0f, 2.0f);
        this.RightArm.func_78784_a(27, 0).func_228302_a_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, 0.01f, 0.01f, 0.01f);
        this.Body = new ModelRenderer((Model)this, 0, 0);
        this.Body.func_78793_a(0.0f, 18.0f, -7.0f);
        this.Body.func_78784_a(1, 8).func_228302_a_(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 12.0f, 0.0f, 0.0f, 0.0f);
        this.LeftLeg = new ModelRenderer((Model)this, 0, 0);
        this.LeftLeg.field_78809_i = true;
        this.LeftLeg.func_78793_a(-1.5f, 3.0f, 10.5f);
        this.LeftLeg.func_78784_a(25, 5).func_228302_a_(-1.0f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f, 0.01f, 0.01f, 0.01f);
        this.RightLeg = new ModelRenderer((Model)this, 0, 0);
        this.RightLeg.func_78793_a(1.5f, 3.0f, 10.5f);
        this.RightLeg.func_78784_a(25, 5).func_228302_a_(-1.0f, 0.0f, -1.5f, 2.0f, 3.0f, 3.0f, 0.01f, 0.01f, 0.01f);
        this.Tail = new ModelRenderer((Model)this, 0, 0);
        this.Tail.func_78793_a(0.0f, 2.0f, 12.0f);
        this.Tail.func_78784_a(1, 24).func_228302_a_(-2.0f, -1.0f, 0.0f, 4.0f, 2.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.LeftArm = new ModelRenderer((Model)this, 0, 0);
        this.LeftArm.field_78809_i = true;
        this.LeftArm.func_78793_a(-1.5f, 3.0f, 2.0f);
        this.LeftArm.func_78784_a(27, 0).func_228302_a_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, 0.01f, 0.01f, 0.01f);
        this.Body.func_78792_a(this.Head);
        this.Body.func_78792_a(this.RightArm);
        this.Body.func_78792_a(this.LeftLeg);
        this.Body.func_78792_a(this.RightLeg);
        this.Body.func_78792_a(this.Tail);
        this.Body.func_78792_a(this.LeftArm);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.Body).forEach(modelRenderer -> modelRenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public void setRotationAngles(KayentatheriumEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetModel();
        if (entityIn.isAsleep()) {
            this.Body.field_78797_d = 20.0f;
            this.Body.field_78798_e = -6.0f;
            this.Head.field_78795_f = 0.46931902f;
            this.RightLeg.field_78795_f = 1.6029103f;
            this.RightLeg.field_78796_g = 0.39095375f;
            this.Tail.field_78795_f = -0.23457225f;
            this.RightArm.field_78795_f = -1.0164797f;
            this.RightArm.field_78796_g = -0.89919364f;
            this.LeftArm.field_78795_f = -1.0164797f;
            this.LeftArm.field_78796_g = 0.89919364f;
            this.LeftLeg.field_78795_f = 1.6030849f;
            this.LeftLeg.field_78796_g = -0.39095375f;
        } else {
            this.Head.field_78795_f = headPitch * ((float)Math.PI / 180);
            this.Head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
            this.RightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LeftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.RightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.LeftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            if (entityIn.isEating()) {
                this.Head.field_78795_f = Math.abs(MathHelper.func_76126_a((float)(0.05f * ageInTicks)) * 0.45f) + 0.15f;
            }
            if (entityIn.func_70090_H()) {
                this.RightArm.field_78795_f = 0.25f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
                this.LeftArm.field_78795_f = -0.25f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
                this.RightLeg.field_78795_f = -0.25f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
                this.LeftLeg.field_78795_f = 0.25f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
                this.Tail.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.25f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Body.field_78797_d = 18.0f;
        this.Body.field_78798_e = -7.0f;
        this.Head.field_78795_f = 0.0f;
        this.Head.field_78796_g = 0.0f;
        this.Head.field_78808_h = 0.0f;
        this.RightLeg.field_78795_f = 0.0f;
        this.RightLeg.field_78796_g = 0.0f;
        this.Tail.field_78795_f = 0.0f;
        this.RightArm.field_78795_f = 0.0f;
        this.RightArm.field_78796_g = 0.0f;
        this.LeftArm.field_78795_f = 0.0f;
        this.LeftArm.field_78796_g = 0.0f;
        this.LeftLeg.field_78795_f = 0.0f;
        this.LeftLeg.field_78796_g = 0.0f;
        this.Tail.field_78795_f = -0.25f;
        this.Tail.field_78798_e = 11.75f;
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

