/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.hellcreek;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.DidelphodonEntity;

@OnlyIn(value=Dist.CLIENT)
public class DidelphodonModel
extends EntityModel<DidelphodonEntity>
implements IHasArm {
    public ModelRenderer Body;
    public ModelRenderer Frontlegright;
    public ModelRenderer Frontlegleft;
    public ModelRenderer Hindlegleft;
    public ModelRenderer Hindlegright;
    public ModelRenderer Head;
    public ModelRenderer Tail;
    public ModelRenderer Snout;
    public ModelRenderer EarRight;
    public ModelRenderer EarLeft;
    public ModelRenderer Nose;

    public DidelphodonModel() {
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.Head = new ModelRenderer((Model)this, 9, 0);
        this.Head.func_78793_a(0.0f, 0.0f, -6.0f);
        this.Head.func_228302_a_(-1.5f, -1.0f, -4.0f, 3.0f, 3.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.Hindlegright = new ModelRenderer((Model)this, 16, 8);
        this.Hindlegright.func_78793_a(-0.9f, 21.0f, 2.9f);
        this.Hindlegright.func_228302_a_(-1.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.Tail = new ModelRenderer((Model)this, 0, 7);
        this.Tail.func_78793_a(0.0f, 0.0f, 2.0f);
        this.Tail.func_228302_a_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 9.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.Tail, -0.13665928f, 0.0f, 0.0f);
        this.Frontlegright = new ModelRenderer((Model)this, 16, 8);
        this.Frontlegright.func_78793_a(-0.9f, 21.0f, -2.9f);
        this.Frontlegright.func_228302_a_(-1.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.Frontlegleft = new ModelRenderer((Model)this, 16, 8);
        this.Frontlegleft.func_78793_a(0.9f, 21.0f, -2.9f);
        this.Frontlegleft.func_228302_a_(0.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.Snout = new ModelRenderer((Model)this, 2, 0);
        this.Snout.func_78793_a(0.0f, 0.0f, -4.0f);
        this.Snout.func_228302_a_(-1.5f, -1.0f, -2.0f, 3.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.Nose = new ModelRenderer((Model)this, 0, 0);
        this.Nose.func_78793_a(0.0f, -1.0f, -2.0f);
        this.Nose.func_228302_a_(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.Hindlegleft = new ModelRenderer((Model)this, 16, 8);
        this.Hindlegleft.func_78793_a(0.9f, 21.0f, 2.9f);
        this.Hindlegleft.func_228302_a_(0.0f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, 0.0f, 0.0f, 0.0f);
        this.EarRight = new ModelRenderer((Model)this, 21, 2);
        this.EarRight.func_78793_a(-1.5f, -1.0f, -1.0f);
        this.EarRight.func_228302_a_(0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.EarLeft = new ModelRenderer((Model)this, 21, 2);
        this.EarLeft.func_78793_a(1.5f, -1.0f, -1.0f);
        this.EarLeft.func_228302_a_(0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        this.Body = new ModelRenderer((Model)this, 0, 20);
        this.Body.func_78793_a(0.0f, 19.0f, 2.0f);
        this.Body.func_228302_a_(-2.0f, -1.0f, -6.0f, 4.0f, 4.0f, 8.0f, 0.0f, 0.0f, 0.0f);
        this.Body.func_78792_a(this.Head);
        this.Body.func_78792_a(this.Tail);
        this.Head.func_78792_a(this.Snout);
        this.Snout.func_78792_a(this.Nose);
        this.Head.func_78792_a(this.EarRight);
        this.Head.func_78792_a(this.EarLeft);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.Hindlegright, (Object)this.Frontlegright, (Object)this.Frontlegleft, (Object)this.Hindlegleft, (Object)this.Body).forEach(modelRenderer -> modelRenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public void setRotationAngles(DidelphodonEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetModel();
        if (entityIn.isAsleep()) {
            this.Frontlegright.field_78808_h = -0.8210029f;
            this.Body.field_78808_h = -1.5707964f;
            this.Frontlegleft.field_78795_f = 0.17453292f;
            this.Frontlegleft.field_78808_h = -1.5707964f;
            this.Head.field_78795_f = 0.9075712f;
            this.Head.field_78796_g = -0.55850536f;
            this.Head.field_78808_h = 0.6981317f;
            this.Hindlegleft.field_78795_f = -0.2443461f;
            this.Hindlegleft.field_78808_h = -1.5707964f;
            this.Hindlegright.field_78808_h = -0.70371675f;
            this.Tail.field_78795_f = -0.62831855f;
            this.Tail.field_78796_g = 0.2268928f;
            this.Tail.field_78808_h = 0.5235988f;
            this.Frontlegleft.field_78797_d = 24.0f;
            this.Hindlegright.field_78800_c = 2.0f;
            this.Hindlegright.field_78797_d = 20.0f;
            this.Hindlegleft.field_78797_d = 24.0f;
            this.Frontlegright.field_78800_c = 1.9f;
            this.Frontlegright.field_78797_d = 20.5f;
            this.Frontlegright.field_78798_e = -3.0f;
            this.Body.field_78800_c = -1.0f;
            this.Body.field_78797_d = 22.0f;
            this.Head.field_78800_c = 0.4f;
        } else {
            this.Head.field_78795_f = Math.abs(-0.025f * MathHelper.func_76126_a((float)(0.1f * ageInTicks / 3.0f)));
            this.Head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
            this.Hindlegright.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.Hindlegleft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Frontlegright.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.Frontlegleft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.Tail.field_78796_g = -0.25f * MathHelper.func_76126_a((float)(0.2f * ageInTicks / 5.0f));
            this.Tail.field_78795_f = -Math.abs(-0.05f * MathHelper.func_76126_a((float)(0.1f * ageInTicks / 5.0f))) - 0.2f;
            if (entityIn.func_70090_H()) {
                this.Frontlegleft.field_78795_f = 0.25f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
                this.Hindlegright.field_78795_f = 0.25f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
                this.Frontlegright.field_78795_f = -0.25f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
                this.Hindlegleft.field_78795_f = -0.25f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
                this.Tail.field_78796_g = MathHelper.func_76134_b((float)(limbSwing * 2.6662f)) * 1.4f * limbSwingAmount + 0.0625f * MathHelper.func_76126_a((float)(0.15f * ageInTicks / 1.5f));
            }
        }
    }

    public void resetModel() {
        this.Frontlegright.field_78795_f = 0.0f;
        this.Frontlegright.field_78808_h = 0.0f;
        this.Body.field_78808_h = 0.0f;
        this.Frontlegleft.field_78795_f = 0.0f;
        this.Frontlegleft.field_78808_h = 0.0f;
        this.Head.field_78795_f = 0.0f;
        this.Head.field_78796_g = 0.0f;
        this.Head.field_78808_h = 0.0f;
        this.Hindlegleft.field_78795_f = 0.0f;
        this.Hindlegleft.field_78808_h = 0.0f;
        this.Hindlegright.field_78795_f = 0.0f;
        this.Hindlegright.field_78808_h = 0.0f;
        this.Tail.field_78795_f = -0.13665928f;
        this.Tail.field_78796_g = 0.0f;
        this.Tail.field_78808_h = 0.0f;
        this.Frontlegleft.field_78797_d = 21.0f;
        this.Hindlegright.field_78800_c = -0.9f;
        this.Hindlegright.field_78797_d = 21.0f;
        this.Hindlegleft.field_78797_d = 21.0f;
        this.Body.field_78800_c = 0.0f;
        this.Body.field_78797_d = 19.0f;
        this.Head.field_78800_c = 0.0f;
        this.Frontlegright.field_78800_c = -0.9f;
        this.Frontlegright.field_78797_d = 21.0f;
        this.Frontlegright.field_78798_e = -2.9f;
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public void func_225599_a_(HandSide sideIn, MatrixStack matrixStackIn) {
        float f = sideIn == HandSide.RIGHT ? 1.0f : -1.0f;
        ModelRenderer modelrenderer = this.getArmForSide(sideIn);
        modelrenderer.field_78800_c += f;
        modelrenderer.func_228307_a_(matrixStackIn);
        modelrenderer.field_78800_c -= f;
        matrixStackIn.func_227861_a_(0.0, 0.7, 0.0);
    }

    protected ModelRenderer getArmForSide(HandSide side) {
        return side == HandSide.LEFT ? this.Head : this.Head;
    }
}

