/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.model.cretaceous.hellcreek;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.common.entities.cretaceous.hellcreek.AnkylosaurusEntity;

@OnlyIn(value=Dist.CLIENT)
public class AnkylosaurusModel
extends EntityModel<AnkylosaurusEntity> {
    public ModelRenderer Body;
    public ModelRenderer LeftFrontLeg;
    public ModelRenderer RightFrontLeg;
    public ModelRenderer LeftHindLeg1;
    public ModelRenderer RightHindLeg1;
    public ModelRenderer Neck;
    public ModelRenderer Tail1;
    public ModelRenderer Head1;
    public ModelRenderer Head2;
    public ModelRenderer Spike1;
    public ModelRenderer Spike1_1;
    public ModelRenderer Spike3;
    public ModelRenderer Spike4;
    public ModelRenderer Tail2;
    public ModelRenderer TailClub;
    public ModelRenderer LeftHindLeg2;
    public ModelRenderer LeftHindLeg3;
    public ModelRenderer RightHindLeg2;
    public ModelRenderer RightHindLeg3;

    public AnkylosaurusModel() {
        this.field_78090_t = 256;
        this.field_78089_u = 128;
        this.Spike1 = new ModelRenderer((Model)this, 0, 33);
        this.Spike1.func_78793_a(7.0f, -3.0f, 0.0f);
        this.Spike1.func_228302_a_(-4.0f, -3.0f, 0.0f, 5.0f, 5.0f, 7.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.Spike1, 0.091106184f, 0.273144f, 0.0f);
        this.Tail1 = new ModelRenderer((Model)this, 0, 79);
        this.Tail1.func_78793_a(0.0f, -1.0f, 18.0f);
        this.Tail1.func_228302_a_(-6.0f, -3.0f, -4.0f, 12.0f, 13.0f, 21.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.Tail1, -0.22759093f, 0.0f, 0.0f);
        this.LeftHindLeg3 = new ModelRenderer((Model)this, 157, 0);
        this.LeftHindLeg3.func_78793_a(0.0f, 10.0f, 3.0f);
        this.LeftHindLeg3.func_228302_a_(-4.0f, 0.0f, -6.0f, 8.0f, 3.0f, 8.0f, 0.0f, 0.0f, 0.0f);
        this.LeftHindLeg2 = new ModelRenderer((Model)this, 200, 0);
        this.LeftHindLeg2.func_78793_a(0.0f, 10.0f, 3.0f);
        this.LeftHindLeg2.func_228302_a_(-3.5f, -3.0f, -2.0f, 7.0f, 14.0f, 8.0f, 0.0f, 0.0f, 0.0f);
        this.TailClub = new ModelRenderer((Model)this, 94, 85);
        this.TailClub.func_78793_a(0.0f, 0.0f, 21.0f);
        this.TailClub.func_228302_a_(-5.5f, -4.0f, 0.0f, 11.0f, 8.0f, 17.0f, 0.0f, 0.0f, 0.0f);
        this.Body = new ModelRenderer((Model)this, 0, 0);
        this.Body.func_78793_a(0.0f, 1.0f, 9.0f);
        this.Body.func_228302_a_(-15.5f, -9.0f, -34.0f, 31.0f, 22.0f, 52.0f, 0.0f, 0.0f, 0.0f);
        this.Spike1_1 = new ModelRenderer((Model)this, 0, 33);
        this.Spike1_1.func_78793_a(-7.0f, -3.0f, 0.0f);
        this.Spike1_1.func_228302_a_(-1.0f, -3.0f, 0.0f, 5.0f, 5.0f, 7.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.Spike1_1, 0.091106184f, -0.273144f, 0.0f);
        this.RightHindLeg3 = new ModelRenderer((Model)this, 157, 0);
        this.RightHindLeg3.func_78793_a(0.0f, 10.0f, 3.0f);
        this.RightHindLeg3.func_228302_a_(-4.0f, 0.0f, -6.0f, 8.0f, 3.0f, 8.0f, 0.0f, 0.0f, 0.0f);
        this.Neck = new ModelRenderer((Model)this, 121, 16);
        this.Neck.func_78793_a(0.0f, -1.0f, -34.0f);
        this.Neck.func_228302_a_(-5.0f, -6.0f, -12.0f, 10.0f, 12.0f, 14.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.Neck, -0.18203785f, 0.0f, 0.0f);
        this.Head1 = new ModelRenderer((Model)this, 152, 97);
        this.Head1.func_78793_a(0.0f, -1.0f, -12.0f);
        this.Head1.func_228302_a_(-7.0f, -5.0f, -12.0f, 14.0f, 12.0f, 16.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.Head1, 0.31869712f, 0.0f, 0.0f);
        this.RightHindLeg1 = new ModelRenderer((Model)this, 190, 33);
        this.RightHindLeg1.func_78793_a(-13.0f, 0.0f, 8.0f);
        this.RightHindLeg1.func_228302_a_(-5.0f, -4.0f, -8.0f, 10.0f, 19.0f, 16.0f, 0.0f, 0.0f, 0.0f);
        this.RightFrontLeg = new ModelRenderer((Model)this, 0, 0);
        this.RightFrontLeg.field_78809_i = true;
        this.RightFrontLeg.func_78793_a(-12.0f, 6.0f, -26.0f);
        this.RightFrontLeg.func_228302_a_(-4.0f, -3.0f, -4.0f, 7.0f, 20.0f, 8.0f, 0.0f, 0.0f, 0.0f);
        this.LeftHindLeg1 = new ModelRenderer((Model)this, 190, 33);
        this.LeftHindLeg1.func_78793_a(13.0f, 0.0f, 8.0f);
        this.LeftHindLeg1.func_228302_a_(-5.0f, -4.0f, -8.0f, 10.0f, 19.0f, 16.0f, 0.0f, 0.0f, 0.0f);
        this.Tail2 = new ModelRenderer((Model)this, 45, 87);
        this.Tail2.func_78793_a(0.0f, 3.0f, 17.0f);
        this.Tail2.func_228302_a_(-2.5f, -3.0f, -5.0f, 5.0f, 6.0f, 30.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.Tail2, 0.13665928f, 0.0f, 0.0f);
        this.Spike4 = new ModelRenderer((Model)this, 29, 32);
        this.Spike4.func_78793_a(-7.0f, 2.0f, -2.0f);
        this.Spike4.func_228302_a_(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.Spike4, 0.0f, -0.91053826f, 0.0f);
        this.LeftFrontLeg = new ModelRenderer((Model)this, 0, 0);
        this.LeftFrontLeg.func_78793_a(12.0f, 6.0f, -26.0f);
        this.LeftFrontLeg.func_228302_a_(-3.0f, -3.0f, -4.0f, 7.0f, 20.0f, 8.0f, 0.0f, 0.0f, 0.0f);
        this.RightHindLeg2 = new ModelRenderer((Model)this, 200, 0);
        this.RightHindLeg2.func_78793_a(0.0f, 10.0f, 3.0f);
        this.RightHindLeg2.func_228302_a_(-3.5f, -3.0f, -2.0f, 7.0f, 14.0f, 8.0f, 0.0f, 0.0f, 0.0f);
        this.Head2 = new ModelRenderer((Model)this, 200, 93);
        this.Head2.func_78793_a(0.0f, 0.0f, -12.0f);
        this.Head2.func_228302_a_(-5.5f, -3.0f, -3.0f, 11.0f, 9.0f, 4.0f, 0.0f, 0.0f, 0.0f);
        this.Spike3 = new ModelRenderer((Model)this, 29, 32);
        this.Spike3.func_78793_a(7.0f, 2.0f, -2.0f);
        this.Spike3.func_228302_a_(-4.0f, 0.0f, 0.0f, 4.0f, 4.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.Spike3, 0.0f, 0.91053826f, 0.0f);
        this.Head1.func_78792_a(this.Spike1);
        this.Body.func_78792_a(this.Tail1);
        this.LeftHindLeg2.func_78792_a(this.LeftHindLeg3);
        this.LeftHindLeg1.func_78792_a(this.LeftHindLeg2);
        this.Tail2.func_78792_a(this.TailClub);
        this.Head1.func_78792_a(this.Spike1_1);
        this.RightHindLeg2.func_78792_a(this.RightHindLeg3);
        this.Body.func_78792_a(this.Neck);
        this.Neck.func_78792_a(this.Head1);
        this.Body.func_78792_a(this.RightHindLeg1);
        this.Body.func_78792_a(this.RightFrontLeg);
        this.Body.func_78792_a(this.LeftHindLeg1);
        this.Tail1.func_78792_a(this.Tail2);
        this.Head1.func_78792_a(this.Spike4);
        this.Body.func_78792_a(this.LeftFrontLeg);
        this.RightHindLeg1.func_78792_a(this.RightHindLeg2);
        this.Head1.func_78792_a(this.Head2);
        this.Head1.func_78792_a(this.Spike3);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ImmutableList.of((Object)this.Body).forEach(modelRenderer -> modelRenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public void setRotationAngles(AnkylosaurusEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float speed = 0.9f;
        float degree = 1.0f;
        float partialTick = ageInTicks - (float)entityIn.field_70173_aa;
        float attackProgress = entityIn.getMeleeProgress(partialTick);
        float leftOrRight = entityIn.getMeleeDirection() ? 1.0f : -1.0f;
        this.Head1.field_78795_f = 0.31869712f;
        this.Head1.field_78796_g = 0.0f;
        this.Head1.field_78808_h = 0.0f;
        this.TailClub.field_78795_f = 0.0f;
        this.TailClub.field_78796_g = 0.0f;
        this.RightHindLeg3.field_78795_f = 0.0f;
        this.LeftHindLeg1.field_78796_g = 0.0f;
        this.RightHindLeg1.field_78795_f = 0.0f;
        this.RightHindLeg1.field_78796_g = 0.0f;
        this.Body.field_78795_f = 0.0f;
        this.RightFrontLeg.field_78795_f = 0.0f;
        this.RightFrontLeg.field_78796_g = 0.0f;
        this.RightFrontLeg.field_78808_h = 0.0f;
        this.Tail2.field_78795_f = 0.13665928f;
        this.Tail2.field_78796_g = 0.0f;
        this.RightHindLeg2.field_78795_f = 0.0f;
        this.RightHindLeg2.field_78796_g = 0.0f;
        this.RightHindLeg2.field_78808_h = 0.0f;
        this.LeftHindLeg3.field_78795_f = 0.0f;
        this.LeftFrontLeg.field_78795_f = 0.0f;
        this.LeftFrontLeg.field_78796_g = 0.0f;
        this.LeftFrontLeg.field_78808_h = 0.0f;
        this.LeftHindLeg2.field_78795_f = 0.0f;
        this.LeftHindLeg2.field_78796_g = 0.0f;
        this.Neck.field_78795_f = -0.18203785f;
        this.Neck.field_78796_g = 0.0f;
        this.Neck.field_78808_h = 0.0f;
        this.Tail1.field_78795_f = -0.22759093f;
        this.Tail1.field_78796_g = 0.0f;
        this.Body.field_78797_d = 1.0f;
        this.Head1.field_78797_d = -1.0f;
        this.RightFrontLeg.field_78800_c = -13.0f;
        this.LeftFrontLeg.field_78800_c = 13.0f;
        if (entityIn.isAsleep()) {
            this.Body.field_78797_d = 9.0f;
            this.Head1.field_78795_f = 0.028274333f;
            this.Head1.field_78796_g = 0.11728612f;
            this.Head1.field_78808_h = -0.11746066f;
            this.RightHindLeg3.field_78795_f = 1.5645131f;
            this.LeftHindLeg1.field_78796_g = -0.15707964f;
            this.RightHindLeg1.field_78795_f = (float)Math.PI / 180;
            this.RightHindLeg1.field_78796_g = 0.15707964f;
            this.Body.field_78795_f = -0.039095376f;
            this.RightFrontLeg.field_78795_f = -0.8208283f;
            this.RightFrontLeg.field_78796_g = -0.39095375f;
            this.RightFrontLeg.field_78808_h = -0.31293753f;
            this.Tail2.field_78795_f = 0.032637656f;
            this.Tail2.field_78796_g = -0.11728612f;
            this.RightHindLeg2.field_78795_f = -1.531701f;
            this.RightHindLeg2.field_78796_g = 0.3302163f;
            this.RightHindLeg2.field_78808_h = (float)Math.PI / 180;
            this.LeftHindLeg3.field_78795_f = 1.5247196f;
            this.LeftFrontLeg.field_78795_f = -0.89901906f;
            this.LeftFrontLeg.field_78796_g = 0.31293753f;
            this.LeftFrontLeg.field_78808_h = 0.07644542f;
            this.LeftHindLeg2.field_78795_f = -1.5247196f;
            this.LeftHindLeg2.field_78796_g = -0.27384216f;
            this.Neck.field_78795_f = 0.38624135f;
            this.Neck.field_78796_g = 0.11728612f;
            this.Neck.field_78808_h = -0.1563815f;
            this.Tail1.field_78795_f = -0.18901916f;
            this.Tail1.field_78796_g = -0.27366763f;
            this.Head1.field_78797_d = -1.5f;
            this.RightFrontLeg.field_78800_c = -16.75f;
            this.LeftFrontLeg.field_78800_c = 14.5f;
            this.RightHindLeg1.field_78795_f = 0.0f;
            this.LeftHindLeg1.field_78795_f = 0.0f;
        } else {
            this.Body.field_78795_f = 0.0f;
            this.LeftHindLeg1.field_78795_f = -0.0f;
            this.RightHindLeg1.field_78795_f = -0.0f;
            this.RightFrontLeg.field_78795_f = -0.0f;
            this.LeftFrontLeg.field_78795_f = -0.0f;
            this.RightFrontLeg.field_78808_h = 0.0f;
            this.LeftFrontLeg.field_78808_h = -0.0f;
            this.LeftFrontLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.RightFrontLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * speed * 0.3f)) * degree * -0.8f * limbSwingAmount;
            this.RightHindLeg1.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.RightHindLeg2.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * speed * 0.3f)) * degree * 0.8f * limbSwingAmount;
            this.RightHindLeg3.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * speed * 0.3f)) * degree * 0.4f * limbSwingAmount;
            this.LeftHindLeg1.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * speed * 0.3f)) * degree * -0.8f * limbSwingAmount;
            this.LeftHindLeg2.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * speed * 0.3f)) * degree * -0.8f * limbSwingAmount;
            this.LeftHindLeg3.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * speed * 0.3f)) * degree * -0.4f * limbSwingAmount;
            this.Tail1.field_78796_g = -0.12f * MathHelper.func_76126_a((float)(0.2f * ageInTicks / 5.0f)) + MathHelper.func_76134_b((float)(limbSwing * speed * 0.15f)) * degree * 0.35f * limbSwingAmount + attackProgress * leftOrRight * (float)Math.toRadians(-15.0);
            this.Tail2.field_78796_g = -0.12f * MathHelper.func_76126_a((float)(0.2f * ageInTicks / 5.0f)) + MathHelper.func_76134_b((float)(limbSwing * speed * 0.15f)) * degree * 0.35f * limbSwingAmount + attackProgress * leftOrRight * (float)Math.toRadians(-25.0);
            this.Tail1.field_78795_f = -Math.abs(-0.05f * MathHelper.func_76126_a((float)(0.1f * ageInTicks / 5.0f))) + (MathHelper.func_76134_b((float)(limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount - 0.15f);
            this.Tail2.field_78795_f = -Math.abs(-0.05f * MathHelper.func_76126_a((float)(0.1f * ageInTicks / 5.0f))) + (MathHelper.func_76134_b((float)(limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount + 0.15f);
            this.Neck.field_78795_f = Math.abs(-0.025f * MathHelper.func_76126_a((float)(0.1f * ageInTicks / 3.0f))) + (MathHelper.func_76134_b((float)(limbSwing * speed * 0.3f)) * degree * 0.1f * limbSwingAmount + 0.15f);
            this.Head1.field_78795_f = -Math.abs(-0.025f * MathHelper.func_76126_a((float)(0.1f * ageInTicks / 3.0f))) + (MathHelper.func_76134_b((float)(-1.0f + limbSwing * speed * 0.3f)) * degree * 0.15f * limbSwingAmount + 0.05f);
            this.Body.field_78796_g = attackProgress * leftOrRight * (float)Math.toRadians(-200.0);
            this.Tail1.field_78808_h = attackProgress * leftOrRight * (float)Math.toRadians(15.0);
            this.Body.field_78798_e = 12.0f + attackProgress * -22.0f;
            if (entityIn.isEating() || entityIn.isTuberDigging()) {
                this.Neck.field_78795_f = Math.abs(MathHelper.func_76126_a((float)(0.05f * ageInTicks)) * 0.5f) + 0.25f;
                this.Body.field_78795_f = 0.1f;
                this.LeftHindLeg1.field_78795_f = -0.1f;
                this.RightHindLeg1.field_78795_f = -0.1f;
                this.RightFrontLeg.field_78795_f = -0.1f;
                this.LeftFrontLeg.field_78795_f = -0.1f;
                this.RightFrontLeg.field_78808_h = 0.3f;
                this.LeftFrontLeg.field_78808_h = -0.3f;
            }
        }
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

