/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.item.ItemGroup;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.SBItemGroup;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.ClientProxy;
import net.p3pp3rf1y.sophisticatedbackpacks.command.SBPCommand;
import net.p3pp3rf1y.sophisticatedbackpacks.common.CommonProxy;
import net.p3pp3rf1y.sophisticatedbackpacks.data.DataGenerators;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModCompat;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModLoot;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RecipeHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sophisticatedbackpacks")
public class SophisticatedBackpacks {
    public static final String MOD_ID = "sophisticatedbackpacks";
    public static final Logger LOGGER = LogManager.getLogger((String)"sophisticatedbackpacks");
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    public static final ItemGroup ITEM_GROUP = new SBItemGroup();

    public SophisticatedBackpacks() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC);
        PROXY.registerHandlers();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(SophisticatedBackpacks::setup);
        modBus.addListener(DataGenerators::gatherData);
        modBus.addListener(Config.COMMON::onConfigReload);
        ModLoot.init();
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(SophisticatedBackpacks::serverStarted);
        eventBus.addListener(SophisticatedBackpacks::registerCommands);
    }

    private static void setup(FMLCommonSetupEvent event) {
        CapabilityBackpackWrapper.register();
        PacketHandler.init();
        ModCompat.initCompats();
        ModItems.registerDispenseBehavior();
        SBPCommand.registerArgumentTypes();
    }

    private static void serverStarted(FMLServerStartedEvent event) {
        ServerWorld world = event.getServer().func_71218_a(World.field_234918_g_);
        if (world != null) {
            RecipeHelper.setWorld((World)world);
        }
    }

    private static void registerCommands(RegisterCommandsEvent event) {
        SBPCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }
}

