/*
 * Decompiled with CFR 0.152.
 */
package mezz.itemzoom.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mezz.itemzoom.client.ZoomRenderHelper;
import mezz.itemzoom.client.compat.JeiCompat;
import mezz.itemzoom.client.config.Config;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderHandler {
    @Nullable
    public static Rectangle2d rendering = null;
    @Nullable
    private static Rectangle2d renderedThisFrame = null;
    private final Config config;
    private final Supplier<Boolean> isEnableKeyHeld;
    private final KeyBinding keyBinding;

    public RenderHandler(Config config, Supplier<Boolean> isEnableKeyHeld, KeyBinding keyBinding) {
        this.config = config;
        this.isEnableKeyHeld = isEnableKeyHeld;
        this.keyBinding = keyBinding;
    }

    public void onScreenDrawn() {
        rendering = renderedThisFrame;
        renderedThisFrame = null;
    }

    public void onItemStackTooltip(@Nullable ItemStack itemStack, int x, int y, MatrixStack matrixStack) {
        ContainerScreen containerScreen;
        Rectangle2d renderArea;
        if (!this.config.isToggledEnabled() && !this.isEnableKeyHeld.get().booleanValue()) {
            return;
        }
        if (itemStack == null || itemStack.func_190926_b()) {
            return;
        }
        if (this.config.isJeiOnly() && !ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)JeiCompat.getStackUnderMouse())) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        Screen currentScreen = minecraft.field_71462_r;
        if (currentScreen instanceof ContainerScreen && !(renderArea = RenderHandler.getRenderingArea(containerScreen = (ContainerScreen)currentScreen, x)).func_199315_b(x, y) && this.renderZoomedStack(itemStack, renderArea, minecraft, matrixStack)) {
            renderedThisFrame = renderArea;
        }
    }

    public static Rectangle2d getRenderingArea(ContainerScreen<?> containerScreen, int mouseX) {
        Minecraft minecraft = containerScreen.getMinecraft();
        MainWindow window = minecraft.func_228018_at_();
        int guiRight = containerScreen.getGuiLeft() + containerScreen.getXSize();
        int spaceOnLeft = RenderHandler.getSpaceOnLeft(containerScreen);
        int spaceOnRight = window.func_198107_o() - guiRight;
        boolean renderLeft = mouseX < containerScreen.getGuiLeft() ? false : (mouseX > guiRight ? true : (double)spaceOnLeft * 1.1 >= (double)spaceOnRight);
        int y = containerScreen.getGuiTop();
        int height = containerScreen.getYSize();
        if (renderLeft) {
            return new Rectangle2d(0, y, spaceOnLeft, height);
        }
        return new Rectangle2d(guiRight, y, spaceOnRight, height);
    }

    private static int getSpaceOnLeft(ContainerScreen<?> containerScreen) {
        RecipeBookGui guiRecipeBook;
        if (containerScreen instanceof IRecipeShownListener && (guiRecipeBook = ((IRecipeShownListener)containerScreen).func_194310_f()).func_191878_b()) {
            return guiRecipeBook.field_193018_j.stream().findAny().map(tab -> tab.field_230690_l_).orElse((guiRecipeBook.field_191904_o - 147) / 2 - guiRecipeBook.field_191903_n);
        }
        return containerScreen.getGuiLeft();
    }

    private boolean renderZoomedStack(ItemStack itemStack, Rectangle2d availableArea, Minecraft minecraft, MatrixStack matrixStack) {
        int availableAreaX = availableArea.func_199318_a();
        int availableAreaY = availableArea.func_199319_b();
        int availableAreaWidth = availableArea.func_199316_c();
        int availableAreaHeight = availableArea.func_199317_d();
        float scale = (float)this.config.getZoomAmount() / 100.0f * (float)availableAreaWidth / 17.0f;
        if (scale <= 2.0f) {
            return false;
        }
        float renderWidth = scale * 16.0f;
        float renderHeight = scale * 16.0f;
        float xPosition = (float)availableAreaX + ((float)availableAreaWidth - renderWidth) / 2.0f;
        float yPosition = (float)availableAreaY + ((float)availableAreaHeight - renderHeight) / 2.0f;
        FontRenderer font = RenderHandler.getFontRenderer(minecraft, itemStack);
        GlStateManager.func_227626_N_();
        GlStateManager.func_227688_c_((float)xPosition, (float)yPosition, (float)0.0f);
        GlStateManager.func_227672_b_((float)scale, (float)scale, (float)1.0f);
        ZoomRenderHelper.enableGUIStandardItemLighting(scale);
        minecraft.func_175599_af().field_77023_b += 100.0f;
        minecraft.func_175599_af().func_184391_a((LivingEntity)minecraft.field_71439_g, itemStack, 0, 0);
        this.renderItemOverlayIntoGUI(font, itemStack, matrixStack);
        minecraft.func_175599_af().field_77023_b -= 100.0f;
        GlStateManager.func_227737_l_();
        RenderHelper.func_74518_a();
        GlStateManager.func_227627_O_();
        if (this.config.showHelpText()) {
            String toggleText;
            String modName = "Item Zoom";
            int stringWidth = font.func_78256_a(modName);
            int y = availableAreaY + (availableAreaHeight + Math.round(19.0f * scale)) / 2;
            if (stringWidth < availableAreaWidth) {
                int x = availableAreaX + (availableAreaWidth - stringWidth) / 2;
                font.func_238421_b_(matrixStack, modName, (float)x, (float)y, 0x404040);
                font.getClass();
                y += 9;
            }
            if (this.config.isToggledEnabled() && (stringWidth = font.func_78256_a(toggleText = this.keyBinding.func_238171_j_().getString())) < availableAreaWidth) {
                int x = availableAreaX + (availableAreaWidth - stringWidth) / 2;
                font.func_238421_b_(matrixStack, toggleText, (float)x, (float)y, 0x404040);
            }
        }
        return true;
    }

    private static FontRenderer getFontRenderer(Minecraft minecraft, ItemStack itemStack) {
        FontRenderer fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack);
        if (fontRenderer == null) {
            fontRenderer = minecraft.field_71466_p;
        }
        return fontRenderer;
    }

    public void renderItemOverlayIntoGUI(FontRenderer fr, ItemStack stack, MatrixStack matrixStack) {
        if (!stack.func_190926_b()) {
            ClientPlayerEntity entityplayersp;
            float f3;
            if (this.config.showStackSize() && stack.func_190916_E() != 1) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.0, 500.0);
                String s = String.valueOf(stack.func_190916_E());
                GlStateManager.func_227722_g_();
                GlStateManager.func_227731_j_();
                GlStateManager.func_227737_l_();
                fr.func_238405_a_(matrixStack, s, (float)(17 - fr.func_78256_a(s)), 9.0f, 0xFFFFFF);
                GlStateManager.func_227716_f_();
                GlStateManager.func_227734_k_();
                GlStateManager.func_227740_m_();
                matrixStack.func_227865_b_();
            }
            if (this.config.showDamageBar() && stack.func_77973_b().showDurabilityBar(stack)) {
                GlStateManager.func_227722_g_();
                GlStateManager.func_227731_j_();
                GlStateManager.func_227621_I_();
                GlStateManager.func_227700_d_();
                GlStateManager.func_227737_l_();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferBuilder = tessellator.func_178180_c();
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int rgbfordisplay = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                RenderHandler.draw(bufferBuilder, 2, 13, 13, 2, 0, 0, 0, 255);
                RenderHandler.draw(bufferBuilder, 2, 13, i, 1, rgbfordisplay >> 16 & 0xFF, rgbfordisplay >> 8 & 0xFF, rgbfordisplay & 0xFF, 255);
                GlStateManager.func_227740_m_();
                GlStateManager.func_227709_e_();
                GlStateManager.func_227619_H_();
                GlStateManager.func_227716_f_();
                GlStateManager.func_227734_k_();
            }
            float f = f3 = (entityplayersp = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : entityplayersp.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f3 > 0.0f) {
                GlStateManager.func_227722_g_();
                GlStateManager.func_227731_j_();
                GlStateManager.func_227621_I_();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferBuilder = tessellator.func_178180_c();
                RenderHandler.draw(bufferBuilder, 0, MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                GlStateManager.func_227619_H_();
                GlStateManager.func_227716_f_();
                GlStateManager.func_227734_k_();
            }
        }
    }

    private static void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_225582_a_((double)x, (double)y, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)x, (double)(y + height), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x + width), (double)y, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

