/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util.crafting;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.paulf.fairylights.util.crafting.IllegalRecipeException;
import me.paulf.fairylights.util.crafting.ingredient.AuxiliaryIngredient;
import me.paulf.fairylights.util.crafting.ingredient.EmptyRegularIngredient;
import me.paulf.fairylights.util.crafting.ingredient.GenericIngredient;
import me.paulf.fairylights.util.crafting.ingredient.RegularIngredient;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public final class GenericRecipe
implements ICraftingRecipe {
    private final ResourceLocation id;
    public static final EmptyRegularIngredient EMPTY = new EmptyRegularIngredient();
    private final Supplier<? extends IRecipeSerializer<GenericRecipe>> serializer;
    private final ItemStack output;
    private final RegularIngredient[] ingredients;
    private final AuxiliaryIngredient<?>[] auxiliaryIngredients;
    private final int width;
    private final int height;
    private final int outputIngredient;
    private final ThreadLocal<ItemStack> result = ThreadLocal.withInitial(() -> ItemStack.field_190927_a);
    private final ImmutableList<IntUnaryOperator> xFunctions = ImmutableList.of((Object)IntUnaryOperator.identity(), i -> this.getWidth() - 1 - i);
    private int room;

    GenericRecipe(ResourceLocation id, Supplier<? extends IRecipeSerializer<GenericRecipe>> serializer, ItemStack output, RegularIngredient[] ingredients, AuxiliaryIngredient<?>[] auxiliaryIngredients, int width, int height, int outputIngredient) {
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (Object)"width must be greater than zero");
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0, (Object)"height must be greater than zero");
        this.id = Objects.requireNonNull(id, "name");
        this.serializer = Objects.requireNonNull(serializer, "serializer");
        this.output = Objects.requireNonNull(output, "output");
        this.ingredients = Objects.requireNonNull(ingredients, "ingredients");
        this.auxiliaryIngredients = GenericRecipe.checkIngredients(ingredients, Objects.requireNonNull(auxiliaryIngredients, "auxiliaryIngredients"));
        this.width = width;
        this.height = height;
        this.outputIngredient = outputIngredient;
        this.room = -1;
    }

    private int getRoom() {
        if (this.room < 0) {
            int room = 0;
            for (RegularIngredient regularIngredient : this.ingredients) {
                if (!regularIngredient.getInputs().isEmpty()) continue;
                ++room;
            }
            for (GenericIngredient<RegularIngredient, MatchResultRegular> genericIngredient : this.auxiliaryIngredients) {
                if (!genericIngredient.isRequired()) continue;
                --room;
            }
            this.room = room;
        }
        return this.room;
    }

    private NonNullList<Ingredient> getDisplayIngredients() {
        int i;
        NonNullList ingredients = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
        for (i = 0; i < this.ingredients.length; ++i) {
            int x = i % this.width;
            int y = i / this.width;
            ItemStack[] stacks = (ItemStack[])this.ingredients[i].getInputs().toArray((Object[])new ItemStack[0]);
            ingredients.set(x + y * 3, (Object)Ingredient.func_193369_a((ItemStack[])stacks));
        }
        i = 0;
        block1: for (int slot = 0; slot < ingredients.size(); ++slot) {
            Ingredient ing = (Ingredient)ingredients.get(slot);
            if (!ing.func_203189_d()) continue;
            while (i < this.auxiliaryIngredients.length) {
                AuxiliaryIngredient<?> aux;
                if (!(aux = this.auxiliaryIngredients[i++]).isRequired()) continue;
                ItemStack[] stacks = (ItemStack[])aux.getInputs().toArray((Object[])new ItemStack[0]);
                ingredients.set(slot, (Object)Ingredient.func_193369_a((ItemStack[])stacks));
                continue block1;
            }
        }
        return ingredients;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public boolean func_192399_d() {
        return this.output.func_190926_b();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return this.serializer.get();
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public RegularIngredient[] getGenericIngredients() {
        return (RegularIngredient[])this.ingredients.clone();
    }

    public AuxiliaryIngredient<?>[] getAuxiliaryIngredients() {
        return (AuxiliaryIngredient[])this.auxiliaryIngredients.clone();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.getDisplayIngredients();
    }

    public boolean func_194133_a(int width, int height) {
        return this.width <= width && this.height <= height && (this.getRoom() >= 0 || width * height - this.width * this.height + this.getRoom() >= 0);
    }

    public boolean matches(CraftingInventory inventory, @Nullable World world) {
        if (!this.func_194133_a(inventory.func_174922_i(), inventory.func_174923_h())) {
            return false;
        }
        int scanWidth = inventory.func_174922_i() + 1 - this.width;
        int scanHeight = inventory.func_174923_h() + 1 - this.height;
        int end = scanWidth * scanHeight;
        for (int i = 0; i < end; ++i) {
            int x = i % scanWidth;
            int y = i / scanWidth;
            for (IntUnaryOperator func : this.xFunctions) {
                ItemStack result = this.getResult(inventory, x, y, func);
                if (result.func_190926_b()) continue;
                this.result.set(result);
                return true;
            }
        }
        this.result.set(ItemStack.field_190927_a);
        return false;
    }

    private ItemStack getResult(CraftingInventory inventory, int originX, int originY, IntUnaryOperator funcX) {
        ItemStack output;
        MatchResultRegular[] match = new MatchResultRegular[this.ingredients.length];
        LinkedListMultimap auxMatchResults = LinkedListMultimap.create();
        HashMap auxMatchTotals = new HashMap();
        HashSet presentCalled = new HashSet();
        ArrayList<MatchResultAuxiliary> auxResults = new ArrayList<MatchResultAuxiliary>();
        Item item = this.output.func_77973_b();
        CompoundNBT tag = new CompoundNBT();
        int w = inventory.func_174922_i();
        int size = w * inventory.func_174923_h();
        for (int i = 0; i < size; ++i) {
            int x = i % w;
            int y = i / w;
            int ingX = x - originX;
            int ingY = y - originY;
            ItemStack input = inventory.func_70301_a(i);
            if (this.contains(ingX, ingY)) {
                int index = funcX.applyAsInt(ingX) + ingY * this.width;
                RegularIngredient ingredient = this.ingredients[index];
                MatchResultRegular result = (MatchResultRegular)ingredient.matches(input);
                if (!result.doesMatch()) {
                    return ItemStack.field_190927_a;
                }
                match[index] = result;
                result.forMatch(presentCalled, tag);
                if (index != this.outputIngredient) continue;
                CompoundNBT inputTag = input.func_77978_p();
                if (inputTag != null) {
                    if (tag.isEmpty()) {
                        tag.func_197643_a(inputTag);
                    } else {
                        CompoundNBT temp = inputTag.func_74737_b();
                        temp.func_197643_a(tag);
                        tag.func_197643_a(temp);
                    }
                }
                item = input.func_77973_b();
                continue;
            }
            if (EMPTY.matches(input).doesMatch()) continue;
            boolean nonAuxiliary = true;
            for (AuxiliaryIngredient<?> auxiliaryIngredient : this.auxiliaryIngredients) {
                MatchResultAuxiliary result = (MatchResultAuxiliary)auxiliaryIngredient.matches(input);
                if (result.doesMatch()) {
                    if (result.isAtLimit(auxMatchTotals.getOrDefault(result.ingredient, 0))) {
                        return ItemStack.field_190927_a;
                    }
                    result.forMatch(presentCalled, tag);
                    auxMatchTotals.merge(result.ingredient, 1, IntMath::checkedAdd);
                    nonAuxiliary = false;
                    result.propagate((Multimap<AuxiliaryIngredient<?>, MatchResultAuxiliary>)auxMatchResults);
                }
                auxResults.add(result);
            }
            if (!nonAuxiliary) continue;
            return ItemStack.field_190927_a;
        }
        HashSet absentCalled = new HashSet();
        for (MatchResultRegular result : match) {
            result.notifyAbsence(presentCalled, absentCalled, tag);
        }
        for (MatchResultAuxiliary result : auxResults) {
            result.notifyAbsence(presentCalled, absentCalled, tag);
        }
        for (AuxiliaryIngredient<?> ingredient : this.auxiliaryIngredients) {
            if (!ingredient.process((Multimap<AuxiliaryIngredient<?>, MatchResultAuxiliary>)auxMatchResults, tag)) continue;
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = output = this.output.func_190926_b() ? new ItemStack((IItemProvider)item) : this.output.func_77946_l();
        if (!tag.isEmpty()) {
            output.func_77982_d(tag);
        }
        return output;
    }

    private boolean contains(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public ItemStack getCraftingResult(CraftingInventory inventory) {
        ItemStack result = this.result.get();
        return result.func_190926_b() ? result : result.func_77946_l();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    private static AuxiliaryIngredient<?>[] checkIngredients(RegularIngredient[] ingredients, AuxiliaryIngredient<?>[] auxiliaryIngredients) {
        GenericRecipe.checkForNulls(ingredients);
        GenericRecipe.checkForNulls(auxiliaryIngredients);
        boolean ingredientDictator = GenericRecipe.checkDictatorship(false, ingredients);
        GenericRecipe.checkDictatorship(ingredientDictator, auxiliaryIngredients);
        return auxiliaryIngredients;
    }

    private static void checkForNulls(GenericIngredient<?, ?>[] ingredients) {
        for (int i = 0; i < ingredients.length; ++i) {
            if (ingredients[i] != null) continue;
            throw new NullPointerException("Must not have null ingredients, found at index " + i);
        }
    }

    private static boolean checkDictatorship(boolean foundDictator, GenericIngredient<?, ?>[] ingredients) {
        for (GenericIngredient<?, ?> ingredient : ingredients) {
            if (!ingredient.dictatesOutputType()) continue;
            if (foundDictator) {
                throw new IllegalRecipeException("Only one ingredient can dictate output type");
            }
            foundDictator = true;
        }
        return foundDictator;
    }

    public static class MatchResultParentedAuxiliary
    extends MatchResultAuxiliary {
        protected final MatchResultAuxiliary parent;

        public MatchResultParentedAuxiliary(AuxiliaryIngredient<?> ingredient, ItemStack input, boolean doesMatch, List<MatchResultAuxiliary> supplementaryResults, MatchResultAuxiliary parent) {
            super(ingredient, input, doesMatch, supplementaryResults);
            this.parent = Objects.requireNonNull(parent, "parent");
        }

        @Override
        public void forMatch(Set<GenericIngredient<?, ?>> called, CompoundNBT nbt) {
            super.forMatch(called, nbt);
            this.parent.forMatch(called, nbt);
        }

        @Override
        public void notifyAbsence(Set<GenericIngredient<?, ?>> presentCalled, Set<GenericIngredient<?, ?>> absentCalled, CompoundNBT nbt) {
            super.notifyAbsence(presentCalled, absentCalled, nbt);
            this.parent.notifyAbsence(presentCalled, absentCalled, nbt);
        }

        @Override
        public MatchResultAuxiliary withParent(MatchResultAuxiliary parent) {
            return this.parent.withParent(new MatchResultParentedAuxiliary(this.ingredient, this.input, this.doesMatch, (List<MatchResultAuxiliary>)this.supplementaryResults, parent));
        }

        @Override
        public boolean isAtLimit(int count) {
            return super.isAtLimit(count) || this.parent.isAtLimit(count);
        }

        @Override
        public void propagate(Multimap<AuxiliaryIngredient<?>, MatchResultAuxiliary> map) {
            super.propagate(map);
            this.parent.propagate(map);
        }
    }

    public static class MatchResultAuxiliary
    implements MatchResult<AuxiliaryIngredient<?>, MatchResultAuxiliary> {
        protected final AuxiliaryIngredient<?> ingredient;
        protected final ItemStack input;
        protected final boolean doesMatch;
        protected final ImmutableList<MatchResultAuxiliary> supplementaryResults;

        public MatchResultAuxiliary(AuxiliaryIngredient<?> ingredient, ItemStack input, boolean doesMatch, List<MatchResultAuxiliary> supplementaryResults) {
            this.ingredient = Objects.requireNonNull(ingredient, "ingredient");
            this.input = input;
            this.doesMatch = doesMatch;
            this.supplementaryResults = ImmutableList.copyOf(supplementaryResults);
        }

        @Override
        public final AuxiliaryIngredient<?> getIngredient() {
            return this.ingredient;
        }

        @Override
        public final ItemStack getInput() {
            return this.input;
        }

        @Override
        public final boolean doesMatch() {
            return this.doesMatch;
        }

        @Override
        public void forMatch(Set<GenericIngredient<?, ?>> called, CompoundNBT nbt) {
            if (!called.contains(this.ingredient)) {
                this.ingredient.present(nbt);
                called.add(this.ingredient);
            }
        }

        @Override
        public void notifyAbsence(Set<GenericIngredient<?, ?>> presentCalled, Set<GenericIngredient<?, ?>> absentCalled, CompoundNBT nbt) {
            if (!presentCalled.contains(this.ingredient) && !absentCalled.contains(this.ingredient)) {
                this.ingredient.absent(nbt);
                absentCalled.add(this.ingredient);
            }
            for (MatchResultAuxiliary result : this.supplementaryResults) {
                result.notifyAbsence(presentCalled, absentCalled, nbt);
            }
        }

        @Override
        public MatchResultAuxiliary withParent(MatchResultAuxiliary parent) {
            return new MatchResultParentedAuxiliary(this.ingredient, this.input, this.doesMatch, (List<MatchResultAuxiliary>)this.supplementaryResults, parent);
        }

        public boolean isAtLimit(int count) {
            return count >= this.ingredient.getLimit();
        }

        public void propagate(Multimap<AuxiliaryIngredient<?>, MatchResultAuxiliary> map) {
            map.put(this.ingredient, (Object)this);
        }
    }

    public static class MatchResultParentedRegular
    extends MatchResultRegular {
        protected final MatchResultRegular parent;

        public MatchResultParentedRegular(RegularIngredient ingredient, ItemStack input, boolean doesMatch, List<MatchResultRegular> supplementaryResults, MatchResultRegular parent) {
            super(ingredient, input, doesMatch, supplementaryResults);
            this.parent = Objects.requireNonNull(parent, "parent");
        }

        @Override
        public void forMatch(Set<GenericIngredient<?, ?>> called, CompoundNBT nbt) {
            super.forMatch(called, nbt);
            this.parent.forMatch(called, nbt);
        }

        @Override
        public void notifyAbsence(Set<GenericIngredient<?, ?>> presentCalled, Set<GenericIngredient<?, ?>> absentCalled, CompoundNBT nbt) {
            super.notifyAbsence(presentCalled, absentCalled, nbt);
            this.parent.notifyAbsence(presentCalled, absentCalled, nbt);
        }

        @Override
        public MatchResultRegular withParent(MatchResultRegular parent) {
            return this.parent.withParent(new MatchResultParentedRegular(this.ingredient, this.input, this.doesMatch, (List<MatchResultRegular>)this.supplementaryResults, parent));
        }
    }

    public static class MatchResultRegular
    implements MatchResult<RegularIngredient, MatchResultRegular> {
        protected final RegularIngredient ingredient;
        protected final ItemStack input;
        protected final boolean doesMatch;
        protected final ImmutableList<MatchResultRegular> supplementaryResults;

        public MatchResultRegular(RegularIngredient ingredient, ItemStack input, boolean doesMatch, List<MatchResultRegular> supplementaryResults) {
            this.ingredient = Objects.requireNonNull(ingredient, "ingredient");
            this.input = input;
            this.doesMatch = doesMatch;
            this.supplementaryResults = ImmutableList.copyOf(supplementaryResults);
        }

        @Override
        public final RegularIngredient getIngredient() {
            return this.ingredient;
        }

        @Override
        public final ItemStack getInput() {
            return this.input;
        }

        @Override
        public final boolean doesMatch() {
            return this.doesMatch;
        }

        @Override
        public void forMatch(Set<GenericIngredient<?, ?>> called, CompoundNBT nbt) {
            this.ingredient.matched(this.input, nbt);
            if (called.add(this.ingredient)) {
                this.ingredient.present(nbt);
            }
        }

        @Override
        public void notifyAbsence(Set<GenericIngredient<?, ?>> presentCalled, Set<GenericIngredient<?, ?>> absentCalled, CompoundNBT nbt) {
            if (!presentCalled.contains(this.ingredient) && !absentCalled.contains(this.ingredient)) {
                this.ingredient.absent(nbt);
                absentCalled.add(this.ingredient);
            }
            for (MatchResultRegular result : this.supplementaryResults) {
                result.notifyAbsence(presentCalled, absentCalled, nbt);
            }
        }

        @Override
        public MatchResultRegular withParent(MatchResultRegular parent) {
            return new MatchResultParentedRegular(this.ingredient, this.input, this.doesMatch, (List<MatchResultRegular>)this.supplementaryResults, parent);
        }
    }

    public static interface MatchResult<I extends GenericIngredient<I, M>, M extends MatchResult<I, M>> {
        public I getIngredient();

        public ItemStack getInput();

        public boolean doesMatch();

        public void forMatch(Set<GenericIngredient<?, ?>> var1, CompoundNBT var2);

        public void notifyAbsence(Set<GenericIngredient<?, ?>> var1, Set<GenericIngredient<?, ?>> var2, CompoundNBT var3);

        public M withParent(M var1);
    }
}

