/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class Utils {
    private Utils() {
    }

    public static <E extends Enum<E>> E getEnumValue(Class<E> clazz, int ordinal) {
        Enum[] values = (Enum[])Objects.requireNonNull(clazz, "clazz").getEnumConstants();
        return (E)values[ordinal < 0 || ordinal >= values.length ? 0 : ordinal];
    }

    public static ITextComponent formatRecipeTooltip(String key) {
        return Utils.formatRecipeTooltipValue(I18n.func_135052_a((String)key, (Object[])new Object[0]));
    }

    private static ITextComponent formatRecipeTooltipValue(String value) {
        return new TranslationTextComponent("recipe.ingredient.tooltip", new Object[]{value});
    }

    public static boolean impliesNbt(@Nullable INBT antecedent, @Nullable INBT consequent) {
        if (antecedent == consequent) {
            return true;
        }
        if (antecedent == null != (consequent == null)) {
            return false;
        }
        if (!antecedent.getClass().equals(consequent.getClass())) {
            return false;
        }
        if (antecedent instanceof CompoundNBT) {
            for (String key : ((CompoundNBT)antecedent).func_150296_c()) {
                if (Utils.impliesNbt(((CompoundNBT)antecedent).func_74781_a(key), ((CompoundNBT)consequent).func_74781_a(key))) continue;
                return false;
            }
            return true;
        }
        return antecedent.equals(consequent);
    }
}

