/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Locale;
import me.paulf.fairylights.client.renderer.block.entity.ConnectionRenderer;
import me.paulf.fairylights.client.renderer.block.entity.FastenerRenderer;
import me.paulf.fairylights.server.connection.LetterBuntingConnection;
import me.paulf.fairylights.server.feature.Letter;
import me.paulf.fairylights.util.Catenary;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class LetterBuntingRenderer
extends ConnectionRenderer<LetterBuntingConnection> {
    public static final Int2ObjectMap<ResourceLocation> MODELS = (Int2ObjectMap)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ&!?".chars().collect(Int2ObjectOpenHashMap::new, (map, cp) -> {
        ResourceLocation cfr_ignored_0 = (ResourceLocation)map.put(cp, (Object)new ResourceLocation("fairylights", "entity/letter/" + Character.getName(cp).toLowerCase(Locale.ROOT).replaceAll("[^a-z]", "_")));
    }, Int2ObjectOpenHashMap::putAll);

    public LetterBuntingRenderer() {
        super(0, 17, 1.0f);
    }

    @Override
    protected void render(LetterBuntingConnection conn, Catenary catenary, float delta, MatrixStack matrix, IRenderTypeBuffer source, int packedLight, int packedOverlay) {
        super.render(conn, catenary, delta, matrix, source, packedLight, packedOverlay);
        Letter[] letters = conn.getLetters();
        if (letters == null) {
            return;
        }
        int count = letters.length;
        if (count == 0) {
            return;
        }
        IVertexBuilder buf = source.getBuffer(Atlases.func_228783_h_());
        for (Letter letter : letters) {
            ResourceLocation path = (ResourceLocation)MODELS.get((int)letter.getLetter());
            if (path == null) continue;
            int color = StyledString.getColor(letter.getStyle().getColor());
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            Vector3d pos = letter.getPoint(delta);
            matrix.func_227860_a_();
            matrix.func_227861_a_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-letter.getYaw(delta)));
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(letter.getPitch(delta)));
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(letter.getRoll(delta)));
            matrix.func_227861_a_(-0.5, -1.03125, -0.5);
            FastenerRenderer.renderBakedModel(path, matrix, buf, r, g, b, packedLight, packedOverlay);
            matrix.func_227865_b_();
        }
    }
}

