/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.paulf.fairylights.client.ClientProxy;
import me.paulf.fairylights.client.renderer.block.entity.ConnectionRenderer;
import me.paulf.fairylights.server.connection.GarlandTinselConnection;
import me.paulf.fairylights.util.Catenary;
import me.paulf.fairylights.util.RandomArray;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class GarlandTinselRenderer
extends ConnectionRenderer<GarlandTinselConnection> {
    private static final RandomArray RAND = new RandomArray(9171L, 128);
    private final StripModel strip = new StripModel();

    public GarlandTinselRenderer() {
        super(62, 0, 1.0f);
    }

    @Override
    protected int getWireColor(GarlandTinselConnection conn) {
        return conn.getColor();
    }

    @Override
    protected void renderSegment(GarlandTinselConnection connection, Catenary.SegmentView it, float delta, MatrixStack matrix, IRenderTypeBuffer source, int packedLight, int packedOverlay) {
        super.renderSegment(connection, it, delta, matrix, source, packedLight, packedOverlay);
        int color = connection.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)it.getX(0.0f), (double)it.getY(0.0f), (double)it.getZ(0.0f));
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-it.getYaw()));
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(it.getPitch()));
        float length = it.getLength();
        int rings = MathHelper.func_76123_f((float)(length * 64.0f));
        int hash = connection.getUUID().hashCode();
        int index = it.getIndex();
        IVertexBuilder buf = ClientProxy.SOLID_TEXTURE.func_229311_a_(source, RenderType::func_228638_b_);
        for (int i = 0; i < rings; ++i) {
            double t = (float)i / (float)rings * length;
            matrix.func_227860_a_();
            matrix.func_227861_a_(t, 0.0, 0.0);
            float rotX = RAND.get(31 * (index + 31 * i) + hash) * 22.0f;
            float rotY = RAND.get(31 * (index + 3 + 31 * i) + hash) * 180.0f;
            float rotZ = RAND.get(31 * (index + 7 + 31 * i) + hash) * 180.0f;
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rotZ));
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotY));
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rotX));
            matrix.func_227862_a_(1.0f, RAND.get(i * 63) * 0.1f + 1.0f, 1.0f);
            this.strip.func_225598_a_(matrix, buf, packedLight, packedOverlay, r, g, b, 1.0f);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }

    private static class StripModel
    extends Model {
        final ModelRenderer root;

        StripModel() {
            super(RenderType::func_228638_b_);
            this.field_78090_t = 128;
            this.field_78089_u = 128;
            this.root = new ModelRenderer(this, 62, 0){

                public void func_228307_a_(MatrixStack stack) {
                    super.func_228307_a_(stack);
                    stack.func_227866_c_().func_227870_a_().func_226595_a_(Matrix4f.func_226593_a_((float)1.0f, (float)1.0f, (float)0.5f));
                }
            };
            this.root.func_228300_a_(-0.5f, -3.0f, 0.0f, 1.0f, 6.0f, 0.0f);
        }

        public void func_225598_a_(MatrixStack matrix, IVertexBuilder builder, int light, int overlay, float r, float g, float b, float a) {
            this.root.func_228309_a_(matrix, builder, light, overlay, r, g, b, a);
        }
    }
}

