/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.mana.ICreativeManaProvider;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaTooltipDisplay;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemManaTablet
extends Item
implements IManaItem,
ICreativeManaProvider,
IManaTooltipDisplay {
    public static final int MAX_MANA = 500000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_CREATIVE = "creative";
    private static final String TAG_ONE_USE = "oneUse";

    public ItemManaTablet(Item.Properties props) {
        super(props);
    }

    public void func_150895_a(@Nonnull ItemGroup tab, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(tab)) {
            stacks.add((Object)new ItemStack((IItemProvider)this));
            ItemStack fullPower = new ItemStack((IItemProvider)this);
            ItemManaTablet.setMana(fullPower, 500000);
            stacks.add((Object)fullPower);
            ItemStack creative = new ItemStack((IItemProvider)this);
            ItemManaTablet.setMana(creative, 500000);
            ItemManaTablet.setStackCreative(creative);
            stacks.add((Object)creative);
        }
    }

    @Nonnull
    public Rarity func_77613_e(@Nonnull ItemStack stack) {
        return this.isCreative(stack) ? Rarity.EPIC : super.func_77613_e(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> stacks, ITooltipFlag flags) {
        if (ItemManaTablet.isStackCreative(stack)) {
            stacks.add((ITextComponent)new TranslationTextComponent("botaniamisc.creative").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public static void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, mana);
    }

    public static void setStackCreative(ItemStack stack) {
        ItemNBTHelper.setBoolean(stack, TAG_CREATIVE, true);
    }

    public static boolean isStackCreative(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CREATIVE, false);
    }

    @Override
    public int getMana(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0) * stack.func_190916_E();
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return (ItemManaTablet.isStackCreative(stack) ? 501000 : 500000) * stack.func_190916_E();
    }

    @Override
    public void addMana(ItemStack stack, int mana) {
        if (!ItemManaTablet.isStackCreative(stack)) {
            ItemManaTablet.setMana(stack, Math.min(this.getMana(stack) + mana, this.getMaxMana(stack)) / stack.func_190916_E());
        }
    }

    @Override
    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return !ItemNBTHelper.getBoolean(stack, TAG_ONE_USE, false);
    }

    @Override
    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return !this.isCreative(stack);
    }

    @Override
    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return true;
    }

    @Override
    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return true;
    }

    @Override
    public boolean isNoExport(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isCreative(ItemStack stack) {
        return ItemManaTablet.isStackCreative(stack);
    }

    @Override
    public float getManaFractionForDisplay(ItemStack stack) {
        return (float)this.getMana(stack) / (float)this.getMaxMana(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !ItemManaTablet.isStackCreative(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getManaFractionForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(this.getManaFractionForDisplay(stack) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

