/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.StateIngredientBlock;
import vazkii.botania.common.crafting.StateIngredientBlockState;
import vazkii.botania.common.crafting.StateIngredientBlocks;
import vazkii.botania.common.crafting.StateIngredientTag;

public class StateIngredientHelper {
    public static StateIngredient of(Block block) {
        return new StateIngredientBlock(block);
    }

    public static StateIngredient of(BlockState state) {
        return new StateIngredientBlockState(state);
    }

    public static StateIngredient of(ITag.INamedTag<Block> tag) {
        return StateIngredientHelper.of(tag.func_230234_a_());
    }

    public static StateIngredient of(ResourceLocation id) {
        return new StateIngredientTag(id);
    }

    public static StateIngredient of(Collection<Block> blocks) {
        return new StateIngredientBlocks(blocks);
    }

    public static StateIngredient deserialize(JsonObject object) {
        switch (JSONUtils.func_151200_h((JsonObject)object, (String)"type")) {
            case "tag": {
                return new StateIngredientTag(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"tag")));
            }
            case "block": {
                return new StateIngredientBlock((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"block"))));
            }
            case "state": {
                return new StateIngredientBlockState(StateIngredientHelper.readBlockState(object));
            }
            case "blocks": {
                ArrayList<Block> blocks = new ArrayList<Block>();
                for (JsonElement element : JSONUtils.func_151214_t((JsonObject)object, (String)"blocks")) {
                    blocks.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(element.getAsString())));
                }
                return new StateIngredientBlocks(blocks);
            }
        }
        throw new JsonParseException("Unknown type!");
    }

    @Nullable
    public static StateIngredient tryDeserialize(JsonObject object) {
        ImmutableSet<Block> blocks;
        ArrayList<Block> list;
        StateIngredient ingr = StateIngredientHelper.deserialize(object);
        if (ingr instanceof StateIngredientTag) {
            return ingr;
        }
        if (ingr instanceof StateIngredientBlock || ingr instanceof StateIngredientBlockState) {
            if (ingr.test(Blocks.field_150350_a.func_176223_P())) {
                return null;
            }
        } else if (ingr instanceof StateIngredientBlocks && (list = new ArrayList<Block>((Collection<Block>)(blocks = ((StateIngredientBlocks)ingr).blocks))).removeIf(b -> b == Blocks.field_150350_a)) {
            if (list.size() == 0) {
                return null;
            }
            return StateIngredientHelper.of(list);
        }
        return ingr;
    }

    public static StateIngredient read(PacketBuffer buffer) {
        switch (buffer.func_150792_a()) {
            case 0: {
                int count = buffer.func_150792_a();
                HashSet<Block> set = new HashSet<Block>();
                for (int i = 0; i < count; ++i) {
                    Block block = (Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS);
                    set.add(block);
                }
                return new StateIngredientBlocks(set);
            }
            case 1: {
                return new StateIngredientBlock((Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS));
            }
            case 2: {
                return new StateIngredientBlockState(Block.func_196257_b((int)buffer.func_150792_a()));
            }
        }
        throw new IllegalArgumentException("Unknown input discriminator!");
    }

    public static JsonObject serializeBlockState(BlockState state) {
        CompoundNBT nbt = NBTUtil.func_190009_a((BlockState)state);
        ItemNBTHelper.renameTag(nbt, "Name", "name");
        ItemNBTHelper.renameTag(nbt, "Properties", "properties");
        Dynamic dyn = new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    public static BlockState readBlockState(JsonObject object) {
        CompoundNBT nbt = (CompoundNBT)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)object).convert((DynamicOps)NBTDynamicOps.field_210820_a).getValue();
        ItemNBTHelper.renameTag(nbt, "name", "Name");
        ItemNBTHelper.renameTag(nbt, "properties", "Properties");
        String name = nbt.func_74779_i("Name");
        ResourceLocation id = ResourceLocation.func_208304_a((String)name);
        if (id == null || !ForgeRegistries.BLOCKS.containsKey(id)) {
            throw new IllegalArgumentException("Invalid or unknown block ID: " + name);
        }
        return NBTUtil.func_190008_d((CompoundNBT)nbt);
    }

    @Deprecated
    @Nonnull
    public static List<ItemStack> toStackList(StateIngredient input) {
        return input.getDisplayedStacks();
    }
}

