/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.helper;

import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import vazkii.botania.common.core.helper.Vector3;

public final class MathHelper {
    public static double angleBetween(Vector3d a, Vector3d b) {
        double projection = a.func_72432_b().func_72430_b(b.func_72432_b());
        return Math.acos(net.minecraft.util.math.MathHelper.func_151237_a((double)projection, (double)-1.0, (double)1.0));
    }

    public static float pointDistanceSpace(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2));
    }

    public static float pointDistancePlane(double x1, double y1, double x2, double y2) {
        return (float)Math.hypot(x1 - x2, y1 - y2);
    }

    public static void setEntityMotionFromVector(Entity entity, Vector3 originalPosVector, float modifier) {
        Vector3 entityVector = Vector3.fromEntityCenter(entity);
        Vector3 finalVector = originalPosVector.subtract(entityVector);
        if (finalVector.mag() > 1.0) {
            finalVector = finalVector.normalize();
        }
        entity.func_213317_d(finalVector.multiply(modifier).toVector3d());
    }

    public static int multiplyColor(int c1, int c2) {
        int r1 = (c1 & 0xFF0000) >> 16;
        int r2 = (c2 & 0xFF0000) >> 16;
        int g1 = (c1 & 0xFF00) >> 8;
        int g2 = (c2 & 0xFF00) >> 8;
        int b1 = c1 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 * ((float)r2 / 255.0f));
        int g = (int)((float)g1 * ((float)g2 / 255.0f));
        int b = (int)((float)b1 * ((float)b2 / 255.0f));
        return c1 & 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static double distSqr(BlockPos a, BlockPos b) {
        double dx = a.func_177958_n() - b.func_177958_n();
        double dy = a.func_177956_o() - b.func_177956_o();
        double dz = a.func_177952_p() - b.func_177952_p();
        return dx * dx + dy * dy + dz * dz;
    }
}

