/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.wand.IWandBindable;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BlockLightRelay;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileAnimatedTorch;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class TileLightRelay
extends TileMod
implements ITickableTileEntity,
IWandBindable {
    public static final int MAX_DIST = 20;
    private static final String TAG_BIND_X = "bindX";
    private static final String TAG_BIND_Y = "bindY";
    private static final String TAG_BIND_Z = "bindZ";
    private static final String TAG_NO_PARTICLE = "noParticle";
    private BlockPos bindPos = new BlockPos(0, -1, 0);
    private int ticksElapsed = 0;
    private boolean noParticle = false;

    public TileLightRelay() {
        super(ModTiles.LIGHT_RELAY);
    }

    public void mountEntity(Entity e) {
        BlockPos nextDest = this.getNextDestination();
        if (e.func_184218_aH() || this.field_145850_b.field_72995_K || nextDest == null || !this.isValidBinding()) {
            return;
        }
        EntityPlayerMover mover = new EntityPlayerMover(this.field_145850_b, this.field_174879_c, nextDest);
        this.field_145850_b.func_217376_c((Entity)mover);
        e.func_184220_m((Entity)mover);
        if (!(e instanceof ItemEntity)) {
            mover.func_184185_a(ModSounds.lightRelay, 0.2f, (float)Math.random() * 0.3f + 0.7f);
        }
        if (e instanceof ServerPlayerEntity) {
            PlayerHelper.grantCriterion((ServerPlayerEntity)e, ResourceLocationHelper.prefix("main/luminizer_ride"), "code_triggered");
        }
    }

    public void func_73660_a() {
        block3: {
            block4: {
                ++this.ticksElapsed;
                BlockPos nextDest = this.getNextDestination();
                if (nextDest == null || nextDest.func_177956_o() <= -1 || !this.isValidBinding()) break block3;
                if (!this.field_145850_b.field_72995_K || this.isNoParticle()) break block4;
                Vector3 vec = this.getMovementVector();
                if (vec == null) break block3;
                double dist = 0.1;
                int size = (int)(vec.mag() / dist);
                int count = 10;
                int start = this.ticksElapsed % size;
                Vector3 vecMag = vec.normalize().multiply(dist);
                Vector3 vecTip = vecMag.multiply(start).add((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                double radPer = 0.19634954084936207;
                float mul = 0.5f;
                float mulPer = 0.4f;
                float maxMul = 2.0f;
                WispParticleData data = WispParticleData.wisp(0.1f, 0.4f, 0.4f, 1.0f, 1.0f);
                for (int i = start; i < start + count; ++i) {
                    mul = Math.min(maxMul, mul + mulPer);
                    double rad = radPer * ((double)i + (double)this.ticksElapsed * 0.4);
                    Vector3 vecRot = vecMag.crossProduct(Vector3.ONE).multiply(mul).rotate(rad, vecMag).add(vecTip);
                    this.field_145850_b.func_195594_a((IParticleData)data, vecRot.x, vecRot.y, vecRot.z, (double)((float)(-vecMag.x)), (double)((float)(-vecMag.y)), (double)((float)(-vecMag.z)));
                    vecTip = vecTip.add(vecMag);
                }
                break block3;
            }
            BlockPos endpoint = this.getEndpoint();
            if (endpoint != null) {
                AxisAlignedBB aabb = this.func_195044_w().func_196954_c((IBlockReader)this.field_145850_b, this.field_174879_c).func_197752_a().func_186670_a(this.field_174879_c);
                float range = 0.6f;
                List enderPearls = this.field_145850_b.func_217357_a(EnderPearlEntity.class, aabb.func_186662_g((double)range));
                for (EnderPearlEntity pearl : enderPearls) {
                    pearl.func_70634_a((double)endpoint.func_177958_n() + (pearl.func_226277_ct_() - (double)this.field_174879_c.func_177958_n()), (double)endpoint.func_177956_o() + (pearl.func_226278_cu_() - (double)this.field_174879_c.func_177956_o()), (double)endpoint.func_177952_p() + (pearl.func_226281_cx_() - (double)this.field_174879_c.func_177952_p()));
                }
            }
        }
    }

    private boolean isValidBinding() {
        BlockPos nextDest = this.getNextDestination();
        if (nextDest == null) {
            return false;
        }
        Block block = this.field_145850_b.func_180495_p(nextDest).func_177230_c();
        return block instanceof BlockLightRelay;
    }

    private BlockPos getEndpoint() {
        ArrayList<TileLightRelay> pointsPassed = new ArrayList<TileLightRelay>();
        TileLightRelay relay = this;
        BlockPos lastCoords = null;
        boolean run = true;
        while (run) {
            if (pointsPassed.contains(relay)) {
                return null;
            }
            pointsPassed.add(relay);
            BlockPos coords = relay.getNextDestination();
            if (coords == null) {
                return lastCoords;
            }
            TileEntity tile = this.field_145850_b.func_175625_s(coords);
            if (tile == null || !(tile instanceof TileLightRelay)) {
                return lastCoords;
            }
            relay = (TileLightRelay)tile;
            lastCoords = coords;
        }
        return null;
    }

    public void setNoParticle() {
        this.noParticle = true;
    }

    public boolean isNoParticle() {
        return this.noParticle;
    }

    public Vector3 getMovementVector() {
        BlockPos dest = this.getNextDestination();
        if (dest == null) {
            return null;
        }
        return new Vector3(dest.func_177958_n() - this.field_174879_c.func_177958_n(), dest.func_177956_o() - this.field_174879_c.func_177956_o(), dest.func_177952_p() - this.field_174879_c.func_177952_p());
    }

    @Override
    public BlockPos getBinding() {
        return this.bindPos;
    }

    public BlockPos getNextDestination() {
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() == ModBlocks.lightRelayToggle && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u)).booleanValue()) {
            return null;
        }
        if (state.func_177230_c() == ModBlocks.lightRelayFork) {
            BlockPos torchPos = null;
            for (int i = -2; i < 3; ++i) {
                BlockPos testPos = this.field_174879_c.func_177982_a(0, i, 0);
                BlockState testState = this.field_145850_b.func_180495_p(testPos);
                if (testState.func_177230_c() != ModBlocks.animatedTorch) continue;
                torchPos = testPos;
                break;
            }
            if (torchPos != null) {
                TileAnimatedTorch torch = (TileAnimatedTorch)this.field_145850_b.func_175625_s(torchPos);
                Direction side = TileAnimatedTorch.SIDES[torch.side].func_176734_d();
                for (int i = 1; i < 20; ++i) {
                    BlockPos testPos = this.field_174879_c.func_177967_a(side, i);
                    BlockState testState = this.field_145850_b.func_180495_p(testPos);
                    if (!(testState.func_177230_c() instanceof BlockLightRelay)) continue;
                    return testPos;
                }
            }
        }
        return this.getBinding();
    }

    @Override
    public boolean canSelect(PlayerEntity player, ItemStack wand, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    public boolean bindTo(PlayerEntity player, ItemStack wand, BlockPos pos, Direction side) {
        if (!(player.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockLightRelay) || pos.func_177951_i((Vector3i)this.func_174877_v()) > 400.0) {
            return false;
        }
        this.bindPos = pos;
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        return true;
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        this.bindPos = new BlockPos(cmp.func_74762_e(TAG_BIND_X), cmp.func_74762_e(TAG_BIND_Y), cmp.func_74762_e(TAG_BIND_Z));
        this.noParticle = cmp.func_74767_n(TAG_NO_PARTICLE);
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_74768_a(TAG_BIND_X, this.bindPos.func_177958_n());
        cmp.func_74768_a(TAG_BIND_Y, this.bindPos.func_177956_o());
        cmp.func_74768_a(TAG_BIND_Z, this.bindPos.func_177952_p());
        cmp.func_74757_a(TAG_NO_PARTICLE, this.noParticle);
    }

    public static class EntityPlayerMover
    extends Entity {
        private static final String TAG_EXIT_X = "exitX";
        private static final String TAG_EXIT_Y = "exitY";
        private static final String TAG_EXIT_Z = "exitZ";
        private static final DataParameter<BlockPos> EXIT_POS = EntityDataManager.func_187226_a(EntityPlayerMover.class, (IDataSerializer)DataSerializers.field_187200_j);

        public EntityPlayerMover(EntityType<EntityPlayerMover> type, World world) {
            super(type, world);
            this.field_70145_X = true;
        }

        public EntityPlayerMover(World world, BlockPos pos, BlockPos exitPos) {
            this(ModEntities.PLAYER_MOVER, world);
            this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            this.setExit(exitPos);
        }

        protected void func_70088_a() {
            this.field_70180_af.func_187214_a(EXIT_POS, (Object)BlockPos.field_177992_a);
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.func_184188_bt().isEmpty() && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                return;
            }
            boolean isItem = this.func_184187_bx() instanceof ItemEntity;
            if (!isItem && this.field_70173_aa % 30 == 0) {
                this.func_184185_a(ModSounds.lightRelay, 0.05f, (float)Math.random() * 0.3f + 0.7f);
            }
            BlockPos pos = this.func_233580_cy_();
            BlockPos exitPos = this.getExitPos();
            if (!this.field_70170_p.field_72995_K && pos.equals((Object)exitPos)) {
                boolean done = true;
                TileEntity tile = this.field_70170_p.func_175625_s(pos);
                if (tile instanceof TileLightRelay) {
                    TileLightRelay relay;
                    BlockPos bind;
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    if (state.func_177230_c() == ModBlocks.lightRelayDetector) {
                        this.field_70170_p.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)));
                        this.field_70170_p.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 2);
                    }
                    if ((bind = (relay = (TileLightRelay)tile).getNextDestination()) != null && relay.isValidBinding()) {
                        this.setExit(bind);
                        done = false;
                    }
                }
                if (done) {
                    for (Entity e : this.func_184188_bt()) {
                        e.func_184210_p();
                    }
                    this.func_70106_y();
                    return;
                }
            }
            Vector3d thisVec = this.func_213303_ch();
            Vector3d motVec = thisVec.func_216371_e().func_72441_c((double)exitPos.func_177958_n() + 0.5, (double)exitPos.func_177956_o() + 0.5, (double)exitPos.func_177952_p() + 0.5).func_72432_b().func_186678_a(0.5);
            int count = 4;
            for (int i = 0; i < count; ++i) {
                int color = MathHelper.func_181758_c((float)((float)this.field_70173_aa / 36.0f + 1.0f / (float)count * (float)i), (float)1.0f, (float)1.0f);
                double rad = Math.PI * 2 / (double)count * (double)i + (double)this.field_70173_aa / Math.PI;
                double cos = Math.cos(rad);
                double sin = Math.sin(rad);
                double s = 0.4;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                SparkleParticleData data = SparkleParticleData.sparkle(1.2f, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 10);
                this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_() + cos * s, this.func_226278_cu_() - 0.5, this.func_226281_cx_() + sin * s, 0.0, 0.0, 0.0);
            }
            this.func_70107_b(this.func_226277_ct_() + motVec.field_72450_a, this.func_226278_cu_() + motVec.field_72448_b, this.func_226281_cx_() + motVec.field_72449_c);
        }

        public boolean shouldRiderSit() {
            return false;
        }

        public boolean func_70097_a(@Nonnull DamageSource source, float damage) {
            return false;
        }

        protected void func_70037_a(@Nonnull CompoundNBT cmp) {
            this.setExit(new BlockPos(cmp.func_74762_e(TAG_EXIT_X), cmp.func_74762_e(TAG_EXIT_Y), cmp.func_74762_e(TAG_EXIT_Z)));
        }

        protected void func_213281_b(@Nonnull CompoundNBT cmp) {
            BlockPos exit = this.getExitPos();
            cmp.func_74768_a(TAG_EXIT_X, exit.func_177958_n());
            cmp.func_74768_a(TAG_EXIT_Y, exit.func_177956_o());
            cmp.func_74768_a(TAG_EXIT_Z, exit.func_177952_p());
        }

        @Nonnull
        public Vector3d func_230268_c_(@Nonnull LivingEntity living) {
            Direction direction = living.func_174811_aO();
            int[][] aint = TransportationHelper.func_234632_a_((Direction)direction);
            BlockPos blockpos = this.func_233580_cy_();
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (Pose pose : living.func_230297_ef_()) {
                AxisAlignedBB axisalignedbb = living.func_233648_f_(pose);
                for (int[] aint1 : aint) {
                    Vector3d vector3d;
                    blockpos$mutable.func_181079_c(blockpos.func_177958_n() + aint1[0], blockpos.func_177956_o(), blockpos.func_177952_p() + aint1[1]);
                    double d0 = this.field_70170_p.func_242403_h((BlockPos)blockpos$mutable);
                    if (!TransportationHelper.func_234630_a_((double)d0) || !TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)living, (AxisAlignedBB)axisalignedbb.func_191194_a(vector3d = Vector3d.func_237490_a_((Vector3i)blockpos$mutable, (double)d0)))) continue;
                    living.func_213301_b(pose);
                    return vector3d;
                }
            }
            return super.func_230268_c_(living);
        }

        @Nonnull
        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        public BlockPos getExitPos() {
            return (BlockPos)this.field_70180_af.func_187225_a(EXIT_POS);
        }

        public void setExit(BlockPos pos) {
            this.field_70180_af.func_187227_b(EXIT_POS, (Object)pos);
        }
    }
}

