/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.AddReloadListenerEvent;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileOpenCrate;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.mixin.AccessorRecipeManager;

public class TileCraftCrate
extends TileOpenCrate {
    private static final String TAG_CRAFTING_RESULT = "craft_result";
    private static int recipeEpoch = 0;
    private int signal = 0;
    private ItemStack craftResult = ItemStack.field_190927_a;
    private final Queue<ResourceLocation> lastRecipes = new ArrayDeque<ResourceLocation>();
    private boolean dirty;
    private boolean matchFailed;
    private int lastRecipeEpoch = recipeEpoch;

    public static void registerListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)((IResourceManagerReloadListener)mgr -> ++recipeEpoch));
    }

    public TileCraftCrate() {
        super(ModTiles.CRAFT_CRATE);
    }

    @Override
    protected Inventory createItemHandler() {
        return new Inventory(9){

            public int func_70297_j_() {
                return 1;
            }

            public boolean func_94041_b(int slot, ItemStack stack) {
                return !TileCraftCrate.this.isLocked(slot);
            }
        };
    }

    public CratePattern getPattern() {
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() != ModBlocks.craftCrate) {
            return CratePattern.NONE;
        }
        return (CratePattern)((Object)state.func_177229_b(BotaniaStateProps.CRATE_PATTERN));
    }

    private boolean isLocked(int slot) {
        return this.getPattern().openSlots.get(slot) == false;
    }

    @Override
    public void readPacketNBT(CompoundNBT tag) {
        super.readPacketNBT(tag);
        this.craftResult = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(TAG_CRAFTING_RESULT));
    }

    @Override
    public void writePacketNBT(CompoundNBT tag) {
        super.writePacketNBT(tag);
        tag.func_218657_a(TAG_CRAFTING_RESULT, (INBT)this.craftResult.func_77955_b(new CompoundNBT()));
    }

    @Override
    public void func_73660_a() {
        int newSignal;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (recipeEpoch != this.lastRecipeEpoch) {
            this.lastRecipeEpoch = recipeEpoch;
            this.matchFailed = false;
        }
        if (!this.matchFailed && this.canEject() && this.isFull() && this.craft(true)) {
            this.ejectAll();
        }
        for (newSignal = 0; newSignal < 9 && (this.isLocked(newSignal) || !this.getItemHandler().func_70301_a(newSignal).func_190926_b()); ++newSignal) {
        }
        if (newSignal != this.signal) {
            this.signal = newSignal;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
        if (this.dirty) {
            this.dirty = false;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    private boolean craft(boolean fullCheck) {
        this.field_145850_b.func_217381_Z().func_76320_a("craft");
        if (fullCheck && !this.isFull()) {
            return false;
        }
        CraftingInventory craft = new CraftingInventory(new Container(ContainerType.field_221518_l, -1){

            public boolean func_75145_c(@Nonnull PlayerEntity player) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < craft.func_70302_i_(); ++i) {
            ItemStack stack = this.getItemHandler().func_70301_a(i);
            if (stack.func_190926_b() || this.isLocked(i) || stack.func_77973_b() == ModItems.placeholder) continue;
            craft.func_70299_a(i, stack);
        }
        Optional<ICraftingRecipe> matchingRecipe = this.getMatchingRecipe(craft);
        matchingRecipe.ifPresent(recipe -> {
            this.craftResult = recipe.func_77572_b((IInventory)craft);
            IInventory handler = this.getItemHandler();
            NonNullList remainders = recipe.func_179532_b((IInventory)craft);
            for (int i = 0; i < craft.func_70302_i_(); ++i) {
                ItemStack s = (ItemStack)remainders.get(i);
                ItemStack inSlot = handler.func_70301_a(i);
                if (inSlot.func_190926_b() && s.func_190926_b() || !inSlot.func_190926_b() && inSlot.func_77973_b() == ModItems.placeholder) continue;
                handler.func_70299_a(i, s);
            }
        });
        if (!matchingRecipe.isPresent()) {
            this.matchFailed = true;
        }
        this.field_145850_b.func_217381_Z().func_76319_b();
        return matchingRecipe.isPresent();
    }

    private Optional<ICraftingRecipe> getMatchingRecipe(CraftingInventory craft) {
        for (ResourceLocation currentRecipe : this.lastRecipes) {
            IRecipe recipe = ((AccessorRecipeManager)this.field_145850_b.func_199532_z()).botania_getRecipes(IRecipeType.field_222149_a).get(currentRecipe);
            if (!(recipe instanceof ICraftingRecipe) || !recipe.func_77569_a((IInventory)craft, this.field_145850_b)) continue;
            return Optional.of((ICraftingRecipe)recipe);
        }
        Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craft, this.field_145850_b);
        if (recipe.isPresent()) {
            if (this.lastRecipes.size() >= 8) {
                this.lastRecipes.remove();
            }
            this.lastRecipes.add(((ICraftingRecipe)recipe.get()).func_199560_c());
            return recipe;
        }
        return Optional.empty();
    }

    boolean isFull() {
        for (int i = 0; i < this.getItemHandler().func_70302_i_(); ++i) {
            if (this.isLocked(i) || !this.getItemHandler().func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private void ejectAll() {
        for (int i = 0; i < this.inventorySize(); ++i) {
            ItemStack stack = this.getItemHandler().func_70301_a(i);
            if (stack.func_190926_b()) continue;
            this.eject(stack, false);
            this.getItemHandler().func_70299_a(i, ItemStack.field_190927_a);
        }
        if (!this.craftResult.func_190926_b()) {
            this.eject(this.craftResult, false);
            this.craftResult = ItemStack.field_190927_a;
        }
    }

    public boolean onWanded(World world) {
        if (!world.field_72995_K && this.canEject()) {
            this.craft(false);
            this.ejectAll();
        }
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.dirty = true;
            this.matchFailed = false;
        }
    }

    public int getSignal() {
        return this.signal;
    }
}

