/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TilePlatform;

public class BlockPlatform
extends BlockMod
implements IWandable,
IManaCollisionGhost,
ITileEntityProvider {
    private final Variant variant;

    public BlockPlatform(@Nonnull Variant v, AbstractBlock.Properties builder) {
        super(builder);
        this.variant = v;
    }

    public Variant getVariant() {
        return this.variant;
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TilePlatform && ((TilePlatform)te).getCamoState() != null) {
            return ((TilePlatform)te).getCamoState().func_196954_c(world, pos);
        }
        return super.func_220053_a(state, world, pos, context);
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, ISelectionContext context) {
        if (this.variant.collide.test(pos, context)) {
            return super.func_220053_a(state, world, pos, context);
        }
        return VoxelShapes.func_197880_a();
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return this.variant.indestructible;
    }

    @Nonnull
    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return new TilePlatform();
    }

    @Override
    public boolean onUsedByWand(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction side) {
        TilePlatform tile = (TilePlatform)world.func_175625_s(pos);
        return tile.onWanded(player);
    }

    @Override
    public boolean isGhost(BlockState state, World world, BlockPos pos) {
        return true;
    }

    public static boolean isValidBlock(@Nullable BlockState state, World world, BlockPos pos) {
        return state != null && (state.func_200015_d((IBlockReader)world, pos) || state.func_185901_i() == BlockRenderType.MODEL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.variant.indestructible) {
            tooltip.add((ITextComponent)new TranslationTextComponent("botaniamisc.creative").func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tile = world.func_175625_s(pos);
        ItemStack currentStack = player.func_184586_b(hand);
        if (this.variant.indestructible && !player.func_184812_l_()) {
            return ActionResultType.PASS;
        }
        if (!currentStack.func_190926_b() && Block.func_149634_a((Item)currentStack.func_77973_b()) != Blocks.field_150350_a && tile instanceof TilePlatform) {
            TilePlatform camo = (TilePlatform)tile;
            BlockItemUseContext ctx = new BlockItemUseContext(player, hand, currentStack, hit);
            BlockState changeState = Block.func_149634_a((Item)currentStack.func_77973_b()).func_196258_a(ctx);
            if (BlockPlatform.isValidBlock(changeState, world, pos) && !(changeState.func_177230_c() instanceof BlockPlatform) && changeState.func_185904_a() != Material.field_151579_a) {
                if (!world.field_72995_K) {
                    camo.setCamoState(changeState);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public static enum Variant {
        ABSTRUSE(false, (pos, context) -> {
            Entity e = context.getEntity();
            return e == null || e.func_226278_cu_() > (double)pos.func_177956_o() + 0.9 && !context.func_225581_b_();
        }),
        SPECTRAL(false, (pos, context) -> false),
        INFRANGIBLE(true, (pos, context) -> true);

        public final boolean indestructible;
        public final BiPredicate<BlockPos, ISelectionContext> collide;

        private Variant(boolean i, BiPredicate<BlockPos, ISelectionContext> p) {
            this.indestructible = i;
            this.collide = p;
        }
    }
}

