/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileLightRelay;
import vazkii.botania.common.item.ModItems;

public class BlockLightRelay
extends BlockModWaterloggable
implements ITileEntityProvider,
IWandable {
    private static final VoxelShape SHAPE = BlockLightRelay.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public final LuminizerVariant variant;

    protected BlockLightRelay(LuminizerVariant variant, AbstractBlock.Properties builder) {
        super(builder);
        this.variant = variant;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208194_u});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack held = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileLightRelay) {
            TileLightRelay relay = (TileLightRelay)te;
            if (held.func_77973_b() == ModItems.phantomInk && !relay.isNoParticle()) {
                if (!world.field_72995_K) {
                    relay.setNoParticle();
                    if (!player.func_184812_l_()) {
                        held.func_190918_g(1);
                    }
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(relay);
                }
                return ActionResultType.SUCCESS;
            }
            if (held.func_77973_b() != Items.field_151079_bi) {
                relay.mountEntity((Entity)player);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K && this.variant == LuminizerVariant.TOGGLE) {
            if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u)).booleanValue() && !worldIn.func_175640_z(pos)) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
            } else if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u)).booleanValue() && worldIn.func_175640_z(pos)) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149744_f(BlockState state) {
        return this.variant == LuminizerVariant.DETECTOR;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction s) {
        return this.variant == LuminizerVariant.DETECTOR && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) != false ? 15 : 0;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return new TileLightRelay();
    }

    @Override
    public boolean onUsedByWand(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction side) {
        return false;
    }
}

