/*
 * Decompiled with CFR 0.152.
 */
package curiousarmorstands;

import curiousarmorstands.CurioInventoryCapability;
import curiousarmorstands.CuriosLayer;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mod(value="curious_armor_stands")
public class CuriousArmorStands {
    public static final String MODID = "curious_armor_stands";
    public static final String SLOT = "armor_stand_curio";

    @Mod.EventBusSubscriber(modid="curious_armor_stands")
    public static class Events {
        @SubscribeEvent
        public static void entityJoinWorld(EntityJoinWorldEvent event) {
            if (!event.getWorld().field_72995_K && event.getEntity() instanceof ArmorStandEntity) {
                CuriosApi.getSlotHelper().setSlotsForType(CuriousArmorStands.SLOT, (LivingEntity)event.getEntity(), 8);
            }
        }

        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof ArmorStandEntity) {
                event.addCapability(CuriosCapability.ID_INVENTORY, CurioInventoryCapability.createProvider((LivingEntity)((ArmorStandEntity)event.getObject())));
            }
        }

        @SubscribeEvent
        public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
            if (!(event.getTarget() instanceof ArmorStandEntity)) {
                return;
            }
            ArmorStandEntity armorStand = (ArmorStandEntity)event.getTarget();
            ItemStack stackInHand = event.getItemStack();
            if (!stackInHand.func_190926_b()) {
                Events.equipItem(armorStand, stackInHand, event);
            } else if (Events.canUnequipCurio(event.getLocalPos(), armorStand)) {
                Events.unequipItem(armorStand, event);
            }
        }

        public static void equipItem(ArmorStandEntity armorStand, ItemStack stackInHand, PlayerInteractEvent.EntityInteractSpecific event) {
            if (CuriosApi.getCuriosHelper().getCurioTags(stackInHand.func_77973_b()).isEmpty()) {
                return;
            }
            if (armorStand.field_70170_p.field_72995_K) {
                event.setCancellationResult(ActionResultType.SUCCESS);
                event.setCanceled(true);
                return;
            }
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)armorStand).ifPresent(handler -> handler.getStacksHandler(CuriousArmorStands.SLOT).ifPresent(stacksHandler -> {
                IDynamicStackHandler cosmeticStacks = stacksHandler.getCosmeticStacks();
                Optional curio = CuriosApi.getCuriosHelper().getCurio(stackInHand).resolve();
                for (int slot = 0; slot < cosmeticStacks.getSlots(); ++slot) {
                    if (!cosmeticStacks.getStackInSlot(slot).func_190926_b() || curio.isPresent() && !((ICurio)curio.get()).canEquip(CuriousArmorStands.SLOT, (LivingEntity)armorStand)) continue;
                    cosmeticStacks.setStackInSlot(slot, stackInHand.func_77946_l());
                    if (curio.isPresent()) {
                        ((ICurio)curio.get()).playRightClickEquipSound((LivingEntity)armorStand);
                    } else {
                        armorStand.field_70170_p.func_184133_a(null, armorStand.func_233580_cy_(), SoundEvents.field_187719_p, armorStand.func_184176_by(), 1.0f, 1.0f);
                    }
                    Events.enableArmorStandArms(armorStand, stackInHand.func_77973_b());
                    if (!event.getPlayer().func_184812_l_()) {
                        int count = stackInHand.func_190916_E();
                        stackInHand.func_190918_g(count);
                    }
                    event.setCancellationResult(ActionResultType.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
            }));
        }

        public static void unequipItem(ArmorStandEntity armorStand, PlayerInteractEvent.EntityInteractSpecific event) {
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)armorStand).ifPresent(handler -> handler.getStacksHandler(CuriousArmorStands.SLOT).ifPresent(stacksHandler -> {
                IDynamicStackHandler cosmeticStacks = stacksHandler.getCosmeticStacks();
                for (int slot = cosmeticStacks.getSlots() - 1; slot >= 0; --slot) {
                    ItemStack stackInSlot = cosmeticStacks.getStackInSlot(slot);
                    if (stackInSlot.func_190926_b()) continue;
                    if (!armorStand.field_70170_p.func_201670_d()) {
                        event.getPlayer().func_184611_a(event.getHand(), stackInSlot);
                        cosmeticStacks.setStackInSlot(slot, ItemStack.field_190927_a);
                    }
                    event.setCancellationResult(ActionResultType.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
            }));
        }

        private static void enableArmorStandArms(ArmorStandEntity entity, Item curioItem) {
            if (CuriosApi.getCuriosHelper().getCurioTags(curioItem).contains("hands") || CuriosApi.getCuriosHelper().getCurioTags(curioItem).contains("ring") || CuriosApi.getCuriosHelper().getCurioTags(curioItem).contains("bracelet")) {
                CompoundNBT nbt = entity.func_189511_e(new CompoundNBT());
                nbt.func_74757_a("ShowArms", true);
                entity.func_70020_e(nbt);
            }
        }

        private static boolean canUnequipCurio(Vector3d localPos, ArmorStandEntity entity) {
            double y;
            boolean isSmall = entity.func_175410_n();
            double d = y = isSmall ? localPos.field_72448_b * 2.0 : localPos.field_72448_b;
            return !(entity.func_190630_a(EquipmentSlotType.FEET) && y >= 0.1 && y < 0.1 + (isSmall ? 0.8 : 0.45) || entity.func_190630_a(EquipmentSlotType.CHEST) && y >= 0.9 + (isSmall ? 0.3 : 0.0) && y < 0.9 + (isSmall ? 1.0 : 0.7) || entity.func_190630_a(EquipmentSlotType.LEGS) && y >= 0.4 && y < 0.4 + (isSmall ? 1.0 : 0.8) || entity.func_190630_a(EquipmentSlotType.HEAD) && y >= 1.6 || entity.func_190630_a(EquipmentSlotType.MAINHAND) || entity.func_190630_a(EquipmentSlotType.OFFHAND));
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void enqueueIMC(InterModEnqueueEvent event) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(CuriousArmorStands.SLOT).cosmetic().size(0).build());
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderer renderer = (EntityRenderer)Minecraft.func_71410_x().func_175598_ae().field_78729_o.get(EntityType.field_200789_c);
            if (renderer instanceof ArmorStandRenderer) {
                ((ArmorStandRenderer)renderer).func_177094_a(new CuriosLayer((ArmorStandRenderer)renderer));
            }
        }
    }
}

