/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sereneseasons.config.FertilityConfig;
import sereneseasons.init.ModFertility;
import sereneseasons.init.ModTags;

@Mod.EventBusSubscriber
public class SeasonalCropGrowthHandler {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onItemTooltipAdded(ItemTooltipEvent event) {
        ModFertility.setupTooltips(event);
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        ModFertility.init();
    }

    @SubscribeEvent
    public void onCropGrowth(BlockEvent.CropGrowEvent event) {
        Block plant = event.getState().func_177230_c();
        World world = (World)event.getWorld();
        boolean isFertile = ModFertility.isCropFertile(plant.getRegistryName().toString(), world, event.getPos());
        if (((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && !isFertile && !this.isGlassAboveBlock(world, event.getPos())) {
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 0 && world.func_201674_k().nextInt(6) != 0) {
                event.setResult(Event.Result.DENY);
            }
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 1) {
                event.setResult(Event.Result.DENY);
            }
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 2) {
                if (!plant.func_203417_a(ModTags.Blocks.unbreakable_infertile_crops)) {
                    event.setResult(Event.Result.DENY);
                    event.getWorld().func_175655_b(event.getPos(), false);
                } else {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public void onApplyBonemeal(BonemealEvent event) {
        Block plant = event.getBlock().func_177230_c();
        boolean isFertile = ModFertility.isCropFertile(plant.getRegistryName().toString(), event.getWorld(), event.getPos());
        if (((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && !isFertile && !this.isGlassAboveBlock(event.getWorld(), event.getPos())) {
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 0 && event.getWorld().func_201674_k().nextInt(6) != 0) {
                event.setResult(Event.Result.DEFAULT);
            }
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 1) {
                event.setCanceled(true);
            }
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 2) {
                if (!plant.func_203417_a(ModTags.Blocks.unbreakable_infertile_crops)) {
                    event.setCanceled(true);
                    event.getWorld().func_175655_b(event.getPos(), false);
                } else {
                    event.setCanceled(true);
                }
            }
        }
    }

    private boolean isGlassAboveBlock(World world, BlockPos cropPos) {
        for (int i = 0; i < 16; ++i) {
            if (!world.func_180495_p(cropPos.func_177982_a(0, i + 1, 0)).func_177230_c().func_203417_a(ModTags.Blocks.greenhouse_glass)) continue;
            return true;
        }
        return false;
    }
}

