/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookResize;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;

public class GuiBookWriter
extends GuiBook {
    BookTextRenderer text;
    BookTextRenderer editableText;
    TextFieldWidget textfield;
    private static String savedText = "";
    private static boolean drawHeader;

    public GuiBookWriter(Book book) {
        super(book, StringTextComponent.field_240750_d_);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.text = new BookTextRenderer(this, (ITextComponent)new TranslationTextComponent("patchouli.gui.lexicon.editor.info"), 15, 38);
        this.textfield = new TextFieldWidget(this.field_230712_o_, 10, 140, 116, 20, StringTextComponent.field_240750_d_);
        this.textfield.func_146203_f(Integer.MAX_VALUE);
        this.textfield.func_146180_a(savedText);
        this.func_230480_a_(new GuiButtonBookResize(this, this.bookLeft + 115, this.bookTop + 156 - 36, false, this::handleButtonResize));
        this.refreshText();
    }

    @Override
    void drawForegroundElements(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.drawForegroundElements(ms, mouseX, mouseY, partialTicks);
        this.drawCenteredStringNoShadow(ms, I18n.func_135052_a((String)"patchouli.gui.lexicon.editor", (Object[])new Object[0]), 73, 18, this.book.headerColor);
        GuiBookWriter.drawSeparator(ms, this.book, 15, 30);
        if (drawHeader) {
            this.drawCenteredStringNoShadow(ms, I18n.func_135052_a((String)"patchouli.gui.lexicon.editor.mock_header", (Object[])new Object[0]), 199, 18, this.book.headerColor);
            GuiBookWriter.drawSeparator(ms, this.book, 141, 30);
        }
        this.textfield.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.text.render(ms, mouseX, mouseY);
        this.editableText.render(ms, mouseX, mouseY);
    }

    @Override
    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        return this.textfield.func_231044_a_(this.getRelativeX(mouseX), this.getRelativeY(mouseY), mouseButton) || this.text.click(mouseX, mouseY, mouseButton) || this.editableText.click(mouseX, mouseY, mouseButton) || super.mouseClickedScaled(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (this.textfield.func_231046_a_(key, scanCode, modifiers)) {
            this.refreshText();
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    public boolean func_231042_a_(char c, int i) {
        if (this.textfield.func_231042_a_(c, i)) {
            this.refreshText();
            return true;
        }
        return super.func_231042_a_(c, i);
    }

    public void handleButtonResize(Button button) {
        drawHeader = !drawHeader;
        this.refreshText();
    }

    public void refreshText() {
        int yPos = 18 + (drawHeader ? 22 : -4);
        savedText = this.textfield.func_146179_b();
        try {
            this.editableText = new BookTextRenderer(this, (ITextComponent)new StringTextComponent(savedText), 141, yPos);
        }
        catch (Throwable e) {
            this.editableText = new BookTextRenderer(this, (ITextComponent)new StringTextComponent("[ERROR]"), 141, yPos);
            Patchouli.LOGGER.catching(e);
        }
    }
}

