/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.nbt.INBT;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.misc.Banner;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class RandomItems {
    private static WeightedRandom<Item> STAGE_1;
    private static WeightedRandom<Item> STAGE_2;
    private static WeightedRandom<Item> STAGE_3;
    private static WeightedRandom<Item> STAGE_4;
    private static WeightedRandom<Item> STAGE_5;
    private static final RandomValueRange[] UNBREAKING_LEVELS;

    public static void loadJson(IResourceManager resourceManager) {
        try {
            JsonParser parser = new JsonParser();
            ResourceLocation stage1 = DungeonCrawl.locate("treasure/stage_1.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage1.toString());
            JsonArray array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(stage1).func_199027_b()))).getAsJsonArray();
            STAGE_1 = WeightedRandom.ITEM.fromJson(array);
            ResourceLocation stage2 = DungeonCrawl.locate("treasure/stage_2.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage2.toString());
            array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(stage2).func_199027_b()))).getAsJsonArray();
            STAGE_2 = WeightedRandom.ITEM.fromJson(array);
            ResourceLocation stage3 = DungeonCrawl.locate("treasure/stage_3.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage3.toString());
            array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(stage3).func_199027_b()))).getAsJsonArray();
            STAGE_3 = WeightedRandom.ITEM.fromJson(array);
            ResourceLocation stage4 = DungeonCrawl.locate("treasure/stage_4.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage4.toString());
            array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(stage4).func_199027_b()))).getAsJsonArray();
            STAGE_4 = WeightedRandom.ITEM.fromJson(array);
            ResourceLocation stage5 = DungeonCrawl.locate("treasure/stage_5.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage5.toString());
            array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(stage5).func_199027_b()))).getAsJsonArray();
            STAGE_5 = WeightedRandom.ITEM.fromJson(array);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static WeightedRandom<Item> itemProvider(int stage) {
        switch (MathHelper.func_76125_a((int)stage, (int)0, (int)4)) {
            case 0: {
                return STAGE_1;
            }
            case 1: {
                return STAGE_2;
            }
            case 2: {
                return STAGE_3;
            }
            case 3: {
                return STAGE_4;
            }
        }
        return STAGE_5;
    }

    public static ItemStack generate(Random rand, int lootLevel) {
        ItemStack stack = new ItemStack((IItemProvider)RandomItems.itemProvider(lootLevel).roll(rand));
        if (rand.nextFloat() < 0.5f + 0.1f * (float)lootLevel) {
            return EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)stack, (int)(10 + 3 * lootLevel), (lootLevel > 2 ? 1 : 0) != 0);
        }
        return stack;
    }

    public static ItemStack createShield(Random rand, int lootLevel) {
        ItemStack shield = new ItemStack((IItemProvider)Items.field_185159_cQ);
        lootLevel = MathHelper.func_76125_a((int)lootLevel, (int)0, (int)4);
        float f = rand.nextFloat();
        if (f < 0.12f + (float)lootLevel * 0.02f) {
            shield.func_77966_a(Enchantments.field_185307_s, UNBREAKING_LEVELS[lootLevel].func_186511_a(rand));
            if (f < 0.04f + (float)lootLevel * 0.01f) {
                shield.func_77966_a(Enchantments.field_185296_A, 1);
            }
            if (rand.nextFloat() < 0.75f) {
                shield.func_77966_a(Enchantments.field_190940_C, 1);
            }
        }
        shield.func_196082_o().func_218657_a("BlockEntityTag", (INBT)Banner.createPatterns(rand));
        return shield;
    }

    static {
        UNBREAKING_LEVELS = new RandomValueRange[]{new RandomValueRange(1.0f, 1.0f), new RandomValueRange(1.0f, 2.0f), new RandomValueRange(2.0f, 2.0f), new RandomValueRange(2.0f, 3.0f), new RandomValueRange(3.0f, 3.0f)};
    }
}

