/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class RandomEquipment {
    public static final int HIGHEST_STAGE = 4;
    public static final int[] ARMOR_COLORS = new int[]{11546150, 16701501, 3949738, 6192150, 16351261, 0xF9FFFE, 15961002, 0x1D1D21, 8439583, 4673362, 1481884, 8991416, 3847130};
    public static Hashtable<Integer, WeightedRandom<Item>> HELMET;
    public static Hashtable<Integer, WeightedRandom<Item>> CHESTPLATE;
    public static Hashtable<Integer, WeightedRandom<Item>> LEGGINGS;
    public static Hashtable<Integer, WeightedRandom<Item>> BOOTS;
    public static Hashtable<Integer, WeightedRandom<Item>> MELEE_WEAPON;
    public static Hashtable<Integer, WeightedRandom<Item>> RANGED_WEAPON;

    public static void loadJson(IResourceManager resourceManager) {
        HELMET = new Hashtable(5);
        CHESTPLATE = new Hashtable(5);
        LEGGINGS = new Hashtable(5);
        BOOTS = new Hashtable(5);
        MELEE_WEAPON = new Hashtable(5);
        RANGED_WEAPON = new Hashtable(5);
        JsonParser parser = new JsonParser();
        try {
            RandomEquipment.loadArmorFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/armor/stage_1.json"), parser, 0);
            RandomEquipment.loadArmorFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/armor/stage_2.json"), parser, 1);
            RandomEquipment.loadArmorFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/armor/stage_3.json"), parser, 2);
            RandomEquipment.loadArmorFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/armor/stage_4.json"), parser, 3);
            RandomEquipment.loadArmorFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/armor/stage_5.json"), parser, 4);
            RandomEquipment.loadWeaponsFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/weapon/stage_1.json"), parser, 0);
            RandomEquipment.loadWeaponsFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/weapon/stage_2.json"), parser, 1);
            RandomEquipment.loadWeaponsFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/weapon/stage_3.json"), parser, 2);
            RandomEquipment.loadWeaponsFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/weapon/stage_4.json"), parser, 3);
            RandomEquipment.loadWeaponsFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/weapon/stage_5.json"), parser, 4);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadArmorFromJson(IResourceManager resourceManager, ResourceLocation file, JsonParser parser, int stage) throws IOException {
        block11: {
            if (resourceManager.func_219533_b(file)) {
                try {
                    DungeonCrawl.LOGGER.debug("Loading {}", (Object)file.toString());
                    JsonObject object = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(file).func_199027_b()))).getAsJsonObject();
                    if (object.has("helmet")) {
                        HELMET.put(stage, WeightedRandom.ITEM.fromJson(object.getAsJsonArray("helmet")));
                    } else {
                        DungeonCrawl.LOGGER.warn("Missing entry 'helmet' in {}", (Object)file.toString());
                    }
                    if (object.has("chestplate")) {
                        CHESTPLATE.put(stage, WeightedRandom.ITEM.fromJson(object.getAsJsonArray("chestplate")));
                    } else {
                        DungeonCrawl.LOGGER.warn("Missing entry 'chestplate' in {}", (Object)file.toString());
                    }
                    if (object.has("leggings")) {
                        LEGGINGS.put(stage, WeightedRandom.ITEM.fromJson(object.getAsJsonArray("leggings")));
                    } else {
                        DungeonCrawl.LOGGER.warn("Missing entry 'leggings' in {}", (Object)file.toString());
                    }
                    if (object.has("boots")) {
                        BOOTS.put(stage, WeightedRandom.ITEM.fromJson(object.getAsJsonArray("boots")));
                        break block11;
                    }
                    DungeonCrawl.LOGGER.warn("Missing entry 'boots' in {}", (Object)file.toString());
                }
                catch (Exception e) {
                    DungeonCrawl.LOGGER.error("Failed to load {}", (Object)file.toString());
                    e.printStackTrace();
                }
            } else {
                throw new FileNotFoundException("Missing file: " + file.toString());
            }
        }
    }

    private static void loadWeaponsFromJson(IResourceManager resourceManager, ResourceLocation file, JsonParser parser, int stage) throws IOException {
        if (resourceManager.func_219533_b(file)) {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)file.toString());
            JsonObject object = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(file).func_199027_b()))).getAsJsonObject();
            if (object.has("melee")) {
                MELEE_WEAPON.put(stage, WeightedRandom.ITEM.fromJson(object.getAsJsonArray("melee")));
            } else {
                DungeonCrawl.LOGGER.error("Missing entry 'melee' in {}", (Object)file.toString());
            }
            if (object.has("ranged")) {
                RANGED_WEAPON.put(stage, WeightedRandom.ITEM.fromJson(object.getAsJsonArray("ranged")));
            } else {
                DungeonCrawl.LOGGER.error("Missing entry 'ranged' in {}", (Object)file.toString());
            }
        } else {
            throw new FileNotFoundException("Missing file: " + file.toString());
        }
    }

    public static ItemStack[] createArmor(Random rand, int stage) {
        Item item;
        if (stage > 4) {
            stage = 4;
        }
        ItemStack[] items = new ItemStack[4];
        float chance = 0.4f + 0.15f * (float)stage;
        if (HELMET.containsKey(stage)) {
            if (rand.nextFloat() < chance) {
                item = HELMET.get(stage).roll(rand);
                items[3] = RandomEquipment.createItemStack(rand, item, stage);
                if (item instanceof DyeableArmorItem) {
                    RandomEquipment.setArmorColor(items[3], RandomEquipment.getRandomColor(rand));
                }
            } else {
                items[3] = ItemStack.field_190927_a;
            }
        } else {
            items[3] = ItemStack.field_190927_a;
        }
        if (CHESTPLATE.containsKey(stage)) {
            if (rand.nextFloat() < chance) {
                item = CHESTPLATE.get(stage).roll(rand);
                items[2] = RandomEquipment.createItemStack(rand, item, stage);
                if (item instanceof DyeableArmorItem) {
                    RandomEquipment.setArmorColor(items[2], RandomEquipment.getRandomColor(rand));
                }
            } else {
                items[2] = ItemStack.field_190927_a;
            }
        } else {
            items[2] = ItemStack.field_190927_a;
        }
        if (LEGGINGS.containsKey(stage)) {
            if (rand.nextFloat() < chance) {
                item = LEGGINGS.get(stage).roll(rand);
                items[1] = RandomEquipment.createItemStack(rand, item, stage);
                if (item instanceof DyeableArmorItem) {
                    RandomEquipment.setArmorColor(items[1], RandomEquipment.getRandomColor(rand));
                }
            } else {
                items[1] = ItemStack.field_190927_a;
            }
        } else {
            items[1] = ItemStack.field_190927_a;
        }
        if (BOOTS.containsKey(stage)) {
            if (rand.nextFloat() < chance) {
                item = BOOTS.get(stage).roll(rand);
                items[0] = RandomEquipment.createItemStack(rand, item, stage);
                if (item instanceof DyeableArmorItem) {
                    RandomEquipment.setArmorColor(items[0], RandomEquipment.getRandomColor(rand));
                }
            } else {
                items[0] = ItemStack.field_190927_a;
            }
        } else {
            items[0] = ItemStack.field_190927_a;
        }
        return items;
    }

    public static ItemStack createItemStack(Random rand, Item item, int stage) {
        ItemStack itemStack = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)item), (int)(10 + 3 * stage), (boolean)false);
        RandomEquipment.applyDamage(itemStack, rand);
        return itemStack;
    }

    public static void applyDamage(ItemStack item, Random rand) {
        if (item.func_77984_f()) {
            item.func_196085_b(rand.nextInt(Math.max(1, item.func_77958_k() / 2)));
        }
    }

    public static void setArmorColor(ItemStack item, int color) {
        INBT displayNBT;
        CompoundNBT tag = item.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
        }
        CompoundNBT display = (displayNBT = tag.func_74781_a("display")) == null ? new CompoundNBT() : (CompoundNBT)displayNBT;
        display.func_74768_a("color", color);
        tag.func_218657_a("display", (INBT)display);
        item.func_77982_d(tag);
    }

    public static ItemStack getMeleeWeapon(Random rand, int stage) {
        if (stage > 4) {
            stage = 4;
        }
        if (MELEE_WEAPON.containsKey(stage)) {
            return RandomEquipment.createItemStack(rand, MELEE_WEAPON.get(stage).roll(rand), stage);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getRangedWeapon(Random rand, int stage) {
        if (stage > 4) {
            stage = 4;
        }
        if (RANGED_WEAPON.containsKey(stage)) {
            return RandomEquipment.createItemStack(rand, RANGED_WEAPON.get(stage).roll(rand), stage);
        }
        return ItemStack.field_190927_a;
    }

    public static int getRandomColor(Random rand) {
        return ARMOR_COLORS[rand.nextInt(ARMOR_COLORS.length)];
    }

    public static Item getItem(ResourceLocation resourceLocation) {
        if (ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
            return (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        }
        DungeonCrawl.LOGGER.warn("Failed to get {} from the item registry.", (Object)resourceLocation.toString());
        return null;
    }
}

