/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.generator.layer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonLayer;
import xiroc.dungeoncrawl.dungeon.Tile;
import xiroc.dungeoncrawl.dungeon.generator.layer.LayerGenerator;
import xiroc.dungeoncrawl.dungeon.generator.layer.LayerGeneratorSettings;
import xiroc.dungeoncrawl.dungeon.piece.DungeonCorridor;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.piece.DungeonStairs;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonMegaNodePart;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonNodeRoom;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonRoom;
import xiroc.dungeoncrawl.util.Orientation;
import xiroc.dungeoncrawl.util.Position2D;

public class NewLayerGenerator
extends LayerGenerator {
    private int roomsLeft;
    private int nodesLeft;
    private int rooms;
    private int nodes;
    private int megaNodes;
    public static final NewLayerGenerator INSTANCE = new NewLayerGenerator();
    private boolean secretRoom;
    private final ArrayList<DungeonCorridor> corridors = new ArrayList();
    private ArrayList<LayerElement> newElements;
    private boolean placeStairs;
    private static final Consumer<NewLayerGenerator> NOOP = generator -> {};
    private static final Consumer<NewLayerGenerator> ON_ROOM_PLACED = generator -> {
        --generator.roomsLeft;
        ++generator.rooms;
    };
    private static final Consumer<NewLayerGenerator> ON_NODE_PLACED = generator -> {
        --generator.nodesLeft;
        ++generator.nodes;
    };
    private static final Consumer<NewLayerGenerator> ON_MEGA_NODE_PLACED = ON_NODE_PLACED.andThen(generator -> ++generator.megaNodes);
    private static final Consumer<NewLayerGenerator> ON_STAIRS_PLACED = generator -> {
        generator.placeStairs = false;
    };

    private NewLayerGenerator() {
    }

    @Override
    public void initializeLayer(LayerGeneratorSettings settings, DungeonBuilder dungeonBuilder, Random rand, int layer, boolean isLastLayer) {
        super.initializeLayer(settings, dungeonBuilder, rand, layer, isLastLayer);
        this.corridors.clear();
        this.placeStairs = !isLastLayer;
        this.secretRoom = false;
        this.roomsLeft = settings.rooms.func_186511_a(rand);
        this.nodesLeft = settings.nodes.func_186511_a(rand);
        this.rooms = 0;
        this.nodes = 0;
        this.megaNodes = 0;
    }

    @Override
    public void generateLayer(DungeonBuilder dungeonBuilder, DungeonLayer dungeonLayer, int layer, Random rand, Position2D start) {
        dungeonLayer.start = start;
        this.newElements = new ArrayList();
        GenericElement stairs = new GenericElement(new DungeonStairs().bottom(), start, null, null, 0);
        stairs.place(dungeonLayer);
        stairs.update(this, dungeonLayer, rand);
        ArrayList<LayerElement> lastElements = this.newElements;
        do {
            this.newElements = new ArrayList();
            for (LayerElement element : lastElements) {
                element.update(this, dungeonLayer, rand);
            }
        } while (!(lastElements = this.newElements).isEmpty());
        if (layer == 0) {
            NewLayerGenerator.createStarterRoom(dungeonLayer, rand, layer);
        }
        if (this.secretRoom) {
            DungeonCorridor corridor;
            for (int i = 0; !(i >= 8 || this.corridors.isEmpty() || (corridor = this.corridors.get(rand.nextInt(this.corridors.size()))).isStraight() && corridor.connectedSides == 2 && dungeonLayer.placeSecretRoom(corridor, corridor.gridPosition, rand)); ++i) {
                this.corridors.remove((Object)corridor);
            }
        }
        this.corridors.clear();
        this.newElements.clear();
        DungeonCrawl.LOGGER.debug("Generated Layer {} with {}({}) Nodes and {}({}) Rooms", (Object)layer, (Object)this.nodes, (Object)this.nodesLeft, (Object)this.rooms, (Object)this.roomsLeft);
    }

    private void generationStep(LayerElement cursor, DungeonLayer dungeonLayer, @Nullable Direction excludedDirection, Random rand, int depth) {
        int count;
        if (depth > this.settings.maxDepth) {
            return;
        }
        ArrayList directions = Lists.newArrayList((Object[])(excludedDirection != null ? Orientation.getHorizontalFacingsWithout(excludedDirection) : Orientation.HORIZONTAL_FACINGS));
        int n = count = depth < 2 ? 2 + rand.nextInt(2) : 1 + rand.nextInt(3);
        while (count > 0 && !directions.isEmpty()) {
            boolean canConnect;
            LayerElement element;
            Position2D nextPos;
            Direction direction = (Direction)directions.remove(rand.nextInt(directions.size()));
            int maxDistance = this.maxDistance(cursor.position, direction, dungeonLayer);
            if (maxDistance < this.settings.minDistance || !(nextPos = cursor.position.shift(direction, MathHelper.func_76136_a((Random)rand, (int)this.settings.minDistance, (int)maxDistance))).isValid(dungeonLayer.width, dungeonLayer.length) || (element = this.nextElement(dungeonLayer, nextPos, direction.func_176734_d(), rand, depth)) == null || !(canConnect = this.canConnectStraight(dungeonLayer, cursor, element))) continue;
            element.place(dungeonLayer);
            element.onPlaced.accept(this);
            this.connectStraight(dungeonLayer, cursor.getConnectionPoint(direction), element.getConnectionPoint(direction.func_176734_d()));
            this.newElements.add(element);
            --count;
        }
    }

    @Nullable
    private LayerElement nextElement(DungeonLayer dungeonLayer, Position2D pos, Direction toOrigin, Random rand, int depth) {
        if (dungeonLayer.isTileFree(pos)) {
            if (this.placeStairs && depth >= this.settings.minStairsDepth) {
                dungeonLayer.end = pos;
                return new GenericElement(new DungeonStairs().top(), pos, toOrigin, ON_STAIRS_PLACED, depth);
            }
            if (depth <= this.settings.maxNodeDepth && this.nodesLeft > 0 && (this.roomsLeft == 0 || depth > this.settings.maxRoomDepth || rand.nextFloat() < 0.65f) && dungeonLayer.canPlaceNode(pos)) {
                return new NodeElement(pos, toOrigin, depth);
            }
            if (depth <= this.settings.maxRoomDepth && this.roomsLeft > 0) {
                return new GenericElement(new DungeonRoom(), pos, toOrigin, ON_ROOM_PLACED, depth);
            }
        }
        return null;
    }

    private int maxDistance(Position2D pos, Direction direction, DungeonLayer dungeonLayer) {
        switch (direction) {
            case NORTH: {
                return Math.min(pos.z, this.settings.maxDistance);
            }
            case SOUTH: {
                return Math.min(dungeonLayer.length - pos.z - 1, this.settings.maxDistance);
            }
            case WEST: {
                return Math.min(pos.x, this.settings.maxDistance);
            }
            case EAST: {
                return Math.min(dungeonLayer.width - pos.x - 1, this.settings.maxDistance);
            }
        }
        return 0;
    }

    @Override
    public void enableSecretRoom() {
        this.secretRoom = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connectStraight(DungeonLayer dungeonLayer, Position2D start, Position2D end) {
        if (start.x == end.x && start.z == end.z) throw new IllegalArgumentException("The start and end positions of a straight connection must not be the same.");
        if (start.x == end.x) {
            if (start.z > end.z) {
                dungeonLayer.openSideIfPresent(start, Direction.NORTH);
                dungeonLayer.openSideIfPresent(end, Direction.SOUTH);
                for (int z = start.z - 1; z > end.z; --z) {
                    if (dungeonLayer.grid[start.x][z] != null) {
                        DungeonPiece piece = dungeonLayer.grid[start.x][z].piece;
                        if (!piece.canConnect(Direction.NORTH, start.x, z) || !piece.canConnect(Direction.SOUTH, start.x, z)) continue;
                        piece.openSide(Direction.NORTH);
                        piece.openSide(Direction.SOUTH);
                        continue;
                    }
                    DungeonCorridor corridor = new DungeonCorridor();
                    corridor.setGridPosition(start.x, z);
                    corridor.openSide(Direction.NORTH);
                    corridor.openSide(Direction.SOUTH);
                    corridor.setRotation(Orientation.getRotationFromFacing(Direction.NORTH));
                    dungeonLayer.grid[corridor.gridPosition.x][corridor.gridPosition.z] = new Tile(corridor);
                    this.corridors.add(corridor);
                }
                return;
            } else {
                dungeonLayer.openSideIfPresent(start, Direction.SOUTH);
                dungeonLayer.openSideIfPresent(end, Direction.NORTH);
                for (int z = start.z + 1; z < end.z; ++z) {
                    if (dungeonLayer.grid[start.x][z] != null) {
                        DungeonPiece piece = dungeonLayer.grid[start.x][z].piece;
                        if (!piece.canConnect(Direction.SOUTH, start.x, z) || !piece.canConnect(Direction.NORTH, start.x, z)) continue;
                        piece.openSide(Direction.SOUTH);
                        piece.openSide(Direction.NORTH);
                        continue;
                    }
                    DungeonCorridor corridor = new DungeonCorridor();
                    corridor.setGridPosition(start.x, z);
                    corridor.openSide(Direction.SOUTH);
                    corridor.openSide(Direction.NORTH);
                    corridor.setRotation(Orientation.getRotationFromFacing(Direction.SOUTH));
                    dungeonLayer.grid[corridor.gridPosition.x][corridor.gridPosition.z] = new Tile(corridor);
                    this.corridors.add(corridor);
                }
            }
            return;
        } else {
            if (start.z != end.z) throw new IllegalArgumentException("The start and end positions of a straight connection must have either the same x-coordinate or the same z-coordinate.");
            if (start.x > end.x) {
                dungeonLayer.openSideIfPresent(start, Direction.WEST);
                dungeonLayer.openSideIfPresent(end, Direction.EAST);
                for (int x = start.x - 1; x > end.x; --x) {
                    if (dungeonLayer.grid[x][start.z] != null) {
                        DungeonPiece piece = dungeonLayer.grid[x][start.z].piece;
                        if (!piece.canConnect(Direction.WEST, x, start.z) || !piece.canConnect(Direction.EAST, x, start.z)) continue;
                        piece.openSide(Direction.WEST);
                        piece.openSide(Direction.EAST);
                        continue;
                    }
                    DungeonCorridor corridor = new DungeonCorridor();
                    corridor.setGridPosition(x, start.z);
                    corridor.openSide(Direction.WEST);
                    corridor.openSide(Direction.EAST);
                    corridor.setRotation(Orientation.getRotationFromFacing(Direction.WEST));
                    dungeonLayer.grid[corridor.gridPosition.x][corridor.gridPosition.z] = new Tile(corridor);
                    this.corridors.add(corridor);
                }
                return;
            } else {
                dungeonLayer.openSideIfPresent(start, Direction.EAST);
                dungeonLayer.openSideIfPresent(end, Direction.WEST);
                for (int x = start.x + 1; x < end.x; ++x) {
                    if (dungeonLayer.grid[x][start.z] != null) {
                        DungeonPiece piece = dungeonLayer.grid[x][start.z].piece;
                        if (!piece.canConnect(Direction.EAST, x, start.z) || !piece.canConnect(Direction.WEST, x, start.z)) continue;
                        piece.openSide(Direction.EAST);
                        piece.openSide(Direction.WEST);
                        continue;
                    }
                    DungeonCorridor corridor = new DungeonCorridor();
                    corridor.setGridPosition(x, start.z);
                    corridor.openSide(Direction.EAST);
                    corridor.openSide(Direction.WEST);
                    corridor.setRotation(Orientation.getRotationFromFacing(Direction.EAST));
                    dungeonLayer.grid[corridor.gridPosition.x][corridor.gridPosition.z] = new Tile(corridor);
                    this.corridors.add(corridor);
                }
            }
        }
    }

    public boolean canConnectStraight(DungeonLayer dungeonLayer, LayerElement start, LayerElement end) {
        if (start.position.x != end.position.x || start.position.z != end.position.z) {
            if (start.position.x == end.position.x) {
                if (start.position.z > end.position.z) {
                    if (!start.piece.canConnect(Direction.NORTH, end.position.x, end.position.z) || !end.piece.canConnect(Direction.SOUTH, start.position.x, start.position.z)) {
                        return false;
                    }
                    for (int z = start.position.z - 1; z > end.position.z; --z) {
                        DungeonPiece piece;
                        if (dungeonLayer.grid[start.position.x][z] == null || (piece = dungeonLayer.grid[start.position.x][z].piece).canConnect(Direction.NORTH, start.position.x, z) && piece.canConnect(Direction.SOUTH, start.position.x, z)) continue;
                        return false;
                    }
                    return true;
                }
                if (!start.piece.canConnect(Direction.SOUTH, end.position.x, end.position.z) || !end.piece.canConnect(Direction.NORTH, start.position.x, start.position.z)) {
                    return false;
                }
                for (int z = start.position.z; z < end.position.z; ++z) {
                    DungeonPiece piece;
                    if (dungeonLayer.grid[start.position.x][z] == null || (piece = dungeonLayer.grid[start.position.x][z].piece).canConnect(Direction.SOUTH, start.position.x, z) && piece.canConnect(Direction.NORTH, start.position.x, z)) continue;
                    return false;
                }
                return true;
            }
            if (start.position.z == end.position.z) {
                if (start.position.x > end.position.x) {
                    if (!start.piece.canConnect(Direction.WEST, end.position.x, end.position.z) || !end.piece.canConnect(Direction.EAST, start.position.x, start.position.z)) {
                        return false;
                    }
                    for (int x = start.position.x - 1; x > end.position.x; --x) {
                        DungeonPiece piece;
                        if (dungeonLayer.grid[x][start.position.z] == null || (piece = dungeonLayer.grid[x][start.position.z].piece).canConnect(Direction.WEST, x, start.position.z) && piece.canConnect(Direction.EAST, x, start.position.z)) continue;
                        return false;
                    }
                    return true;
                }
                if (!start.piece.canConnect(Direction.EAST, end.position.x, end.position.z) || !end.piece.canConnect(Direction.WEST, start.position.x, start.position.z)) {
                    return false;
                }
                for (int x = start.position.x; x < end.position.x; ++x) {
                    DungeonPiece piece;
                    if (dungeonLayer.grid[x][start.position.z] == null || (piece = dungeonLayer.grid[x][start.position.z].piece).canConnect(Direction.EAST, x, start.position.z) && piece.canConnect(Direction.WEST, x, start.position.z)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static class GenericElement
    extends LayerElement {
        GenericElement(DungeonPiece piece, Position2D position, Direction toOrigin, Consumer<NewLayerGenerator> onPlaced, int depth) {
            super(piece, position, toOrigin, onPlaced, depth);
        }

        @Override
        public Position2D getConnectionPoint(Direction connectionSide) {
            return this.position;
        }
    }

    private static class MegaNodeElement
    extends LayerElement {
        public final int id;

        MegaNodeElement(int id, Position2D position, Direction toOrigin, int depth) {
            super(new DungeonMegaNodePart(), position, toOrigin, ON_MEGA_NODE_PLACED, depth);
            this.id = id;
        }

        @Override
        public void update(NewLayerGenerator layerGenerator, DungeonLayer dungeonLayer, Random rand) {
            super.update(layerGenerator, dungeonLayer, rand);
        }

        @Override
        public void place(DungeonLayer layer) {
            super.place(layer);
        }

        @Override
        public Position2D getConnectionPoint(Direction connectionSide) {
            return this.position.shift(connectionSide, 1);
        }

        private boolean canExtendTo(Position2D position, DungeonLayer layer) {
            return layer.isTileFree(position) && this.canObtainTile(position.x + 1, position.z, layer) && this.canObtainTile(position.x, position.z + 1, layer) && this.canObtainTile(position.x - 1, position.z, layer) && this.canObtainTile(position.x, position.z - 1, layer) && this.canObtainTile(position.x + 1, position.z + 1, layer) && this.canObtainTile(position.x + 1, position.z - 1, layer) && this.canObtainTile(position.x - 1, position.z + 1, layer) && this.canObtainTile(position.x - 1, position.z - 1, layer);
        }

        private boolean canObtainTile(int x, int z, DungeonLayer layer) {
            if (layer.isTileFree(x, z)) {
                return true;
            }
            Tile tile = layer.grid[x][z];
            return tile != null && tile.piece.getDungeonPieceType() == 12 && tile.getId() == this.id;
        }
    }

    private static class NodeElement
    extends LayerElement {
        NodeElement(Position2D center, Direction toOrigin, int depth) {
            super(new DungeonNodeRoom(), center, toOrigin, ON_NODE_PLACED, depth);
        }

        @Override
        public void place(DungeonLayer layer) {
            LayerGenerator.placeNodeRoom((DungeonNodeRoom)this.piece, this.position, layer);
        }

        @Override
        public Position2D getConnectionPoint(Direction connectionSide) {
            return this.position.shift(connectionSide, 1);
        }
    }

    private static abstract class LayerElement {
        final Position2D position;
        final Direction toOrigin;
        final int depth;
        final DungeonPiece piece;
        final Consumer<NewLayerGenerator> onPlaced;

        LayerElement(DungeonPiece piece, Position2D position, Direction toOrigin, Consumer<NewLayerGenerator> onPlaced, int depth) {
            this.piece = piece;
            this.piece.setGridPosition(position);
            this.position = position;
            this.toOrigin = toOrigin;
            this.onPlaced = onPlaced;
            this.depth = depth;
        }

        public void place(DungeonLayer layer) {
            layer.grid[this.position.x][this.position.z] = new Tile(this.piece);
        }

        public void update(NewLayerGenerator layerGenerator, DungeonLayer dungeonLayer, Random rand) {
            layerGenerator.generationStep(this, dungeonLayer, this.toOrigin, rand, this.depth + 1);
        }

        public abstract Position2D getConnectionPoint(Direction var1);
    }
}

