/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.block.provider;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.util.JSONUtils;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class WeightedRandomBlock
implements BlockStateProvider {
    protected static final String TYPE = "random_block";
    private final WeightedRandom<BlockState> randomBlockState;

    public WeightedRandomBlock(WeightedRandom<BlockState> randomBlockState) {
        this.randomBlockState = randomBlockState;
    }

    @Override
    public BlockState get(IWorld world, BlockPos pos, Random random, Rotation rotation) {
        return this.randomBlockState.roll(random);
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", TYPE);
        JsonArray blocks = new JsonArray();
        this.randomBlockState.getEntries().forEach(entry -> {
            JsonObject block = JSONUtils.serializeBlockState(new JsonObject(), (BlockState)entry.func_76341_a());
            block.addProperty("weight", (Number)entry.func_76340_b());
            blocks.add((JsonElement)block);
        });
        object.add("blocks", (JsonElement)blocks);
        return object;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private WeightedRandom.Builder<BlockState> builder = new WeightedRandom.Builder();

        public Builder add(Block block) {
            return this.add(block.func_176223_P(), 1);
        }

        public Builder add(Block block, int weight) {
            return this.add(block.func_176223_P(), weight);
        }

        public Builder add(BlockState state) {
            return this.add(state, 1);
        }

        public Builder add(BlockState state, int weight) {
            this.builder.add(state, weight);
            return this;
        }

        public WeightedRandomBlock build() {
            return new WeightedRandomBlock(this.builder.build());
        }
    }
}

