/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.logging.log4j.Logger;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.Dungeon;

public class Config {
    private static final ImmutableList<Biome.Category> DEFAULT_BIOME_CATEGORIES = ImmutableList.builder().add((Object)Biome.Category.DESERT).add((Object)Biome.Category.EXTREME_HILLS).add((Object)Biome.Category.FOREST).add((Object)Biome.Category.ICY).add((Object)Biome.Category.JUNGLE).add((Object)Biome.Category.MESA).add((Object)Biome.Category.PLAINS).add((Object)Biome.Category.SAVANNA).add((Object)Biome.Category.SWAMP).add((Object)Biome.Category.TAIGA).build();
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG;
    public static final ForgeConfigSpec.IntValue SPAWNER_ENTITIES;
    public static final ForgeConfigSpec.IntValue SPAWNER_RANGE;
    public static final ForgeConfigSpec.IntValue SPACING;
    public static final ForgeConfigSpec.IntValue SEPARATION;
    public static final ForgeConfigSpec.ConfigValue<String> DIMENSION_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<String> BIOME_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<String> BIOME_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<String> BIOME_CATEGORIES;
    public static final ForgeConfigSpec.BooleanValue CUSTOM_SPAWNERS;
    public static final ForgeConfigSpec.BooleanValue NO_NETHER_STUFF;
    public static final ForgeConfigSpec.BooleanValue ENABLE_TOOLS;
    public static final ForgeConfigSpec.BooleanValue SOLID;
    public static final ForgeConfigSpec.BooleanValue NATURAL_DESPAWN;
    public static final ForgeConfigSpec.BooleanValue EXTENDED_DEBUG;
    public static final ForgeConfigSpec.BooleanValue TICK_FALLING_BLOCKS;
    public static final ForgeConfigSpec.BooleanValue OVERWRITE_ENTITY_LOOT_TABLES;
    public static final ForgeConfigSpec.BooleanValue SECRET_ROOMS;
    public static final ForgeConfigSpec.BooleanValue PRINT_BIOME_CATEGORIES;
    private static final String SEPARATOR_LINE = "----------------------------------------------------------------------------------------------------+\n";

    public static void load(Path path) {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        config.load();
        CONFIG.setConfig((CommentedConfig)config);
        Dungeon.whitelistedDimensions = ImmutableSet.copyOf((Object[])((String)DIMENSION_WHITELIST.get()).split(",\\s*"));
        DungeonCrawl.LOGGER.info("Whitelisted Dimensions:");
        Dungeon.whitelistedDimensions.forEach(arg_0 -> ((Logger)DungeonCrawl.LOGGER).info(arg_0));
        Dungeon.whitelistedBiomes = ImmutableSet.copyOf((Object[])((String)BIOME_WHITELIST.get()).split(",\\s*"));
        Dungeon.blacklistedBiomes = ImmutableSet.copyOf((Object[])((String)BIOME_BLACKLIST.get()).split(",\\s*"));
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (String s : ((String)BIOME_CATEGORIES.get()).split(",\\s*")) {
            Biome.Category category = Biome.Category.func_235103_a_((String)s.toLowerCase(Locale.ROOT));
            if (category == null) {
                DungeonCrawl.LOGGER.warn("Unknown biome category '{}' in the config.", (Object)s);
                continue;
            }
            builder.add((Object)category);
        }
        Dungeon.biomeCategories = builder.build();
    }

    private static String allBiomeCategories() {
        Iterator iterator = Arrays.stream(Biome.Category.values()).sorted(Comparator.comparing(Biome.Category::func_222352_a)).iterator();
        return Config.commaSeparated(iterator, Biome.Category::func_222352_a);
    }

    private static String defaultBiomeCategories() {
        return Config.commaSeparated(DEFAULT_BIOME_CATEGORIES.iterator(), Biome.Category::func_222352_a);
    }

    private static <T> String commaSeparated(Iterator<T> elements, Function<T, String> toString) {
        StringBuilder builder = new StringBuilder();
        while (elements.hasNext()) {
            builder.append(toString.apply(elements.next()));
            if (!elements.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    static {
        BUILDER.push("Miscellaneous Settings");
        ENABLE_TOOLS = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Enables the dungeon crawl developer tools. Do not use this for normal gameplay.\n").define("enable_tools", false);
        EXTENDED_DEBUG = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Enables extended debug logging to help detecting errors. Enabled by default.\n").define("extended_debug", true);
        PRINT_BIOME_CATEGORIES = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Prints all biome categories and their respective biomes to the console when entering a world.\n Might be useful to modpack creators. Ignore this for normal gameplay.\n").define("Print Biome Categories", false);
        BUILDER.pop();
        BUILDER.push("World Generation");
        SOLID = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Makes the entire dungeon solid, preventing caves, ravines, etc... from interfering with the dungeon.\n").define("solid", false);
        TICK_FALLING_BLOCKS = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether falling blocks like sand or gravel should drop down after being placed during dungeon generation.\n").define("tick_falling_blocks", true);
        BUILDER.pop();
        BUILDER.push("Dungeon Placement");
        SPACING = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n The cell size of the grid used to generate the dungeons in chunks. Each cell of this grid can only contain one dungeon.\n You can also see this as the average distance between two adjacent dungeons in chunks.\n !! Has to be higher than the separation! !! \n Reduce this value to make the dungeons more common, increase it to make them more rare.\n Halving it will quadruple the amount of dungeons, doubling it would have the opposite effect.\n").defineInRange("spacing", 32, 9, 4096);
        SEPARATION = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n The minimum distance between two adjacent dungeons in chunks. Has to be lower than the spacing!\n The closer the separation is to the spacing, the more grid-aligned and predictable the dungeon placement will be.\n Generally, bigger values allow for less, and smaller values for more randomness.\n !! Has to be lower than the spacing! !!\n").defineInRange("separation", 12, 8, 4095);
        BUILDER.push("Biomes");
        BIOME_WHITELIST = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Biomes the dungeons should spawn in.\n Entries need to use the full biome name ( eg. minecraft:plains ) and have to be comma-separated.\n You can use this in combination with the Biome Categories option.\n This is empty by default since all biomes the dungeons should spawn in are whitelisted via the Biome Categories option below.\n").define("Biome Whitelist", (Object)"");
        BIOME_BLACKLIST = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Biomes that should never contain dungeons.\n Entries need to use the full biome name ( eg. minecraft:plains ) and have to be comma-separated.\n").define("Biome Blacklist", (Object)"");
        BIOME_CATEGORIES = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n List of biome categories the dungeons should spawn in.\n Entries have to be comma-separated.\n Biome Categories are groupings of biomes of specific types. Using these allows Dungeon Crawl to\n  automatically generate in suitable biomes and to ignore unsuitable ones like ocean biomes.\n You can use this in combination with the Biome Whitelist and you can exclude specific biomes with the Biome Blacklist.\n ALL CATEGORIES: " + Config.allBiomeCategories() + "\n You may also enable the 'Print Biome Categories' option to have a list of all categories and their respective biomes\n  (including biomes of mods you have installed) printed to the logs.\n").define("Biome Categories", (Object)Config.defaultBiomeCategories());
        BUILDER.pop();
        BUILDER.push("Dimensions");
        DIMENSION_WHITELIST = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Dimensions the dungeons should spawn in.\n Entries need to use the full dimension name ( eg. minecraft:overworld ) and have to be comma-separated.\n").define("Dimension Whitelist", (Object)"minecraft:overworld");
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Dungeon Settings");
        SECRET_ROOMS = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether the dungeons should have secret rooms or not.\n").define("secret_rooms", true);
        OVERWRITE_ENTITY_LOOT_TABLES = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether loot tables of certain spawner entities should be overwritten.\n For example, wither skeletons from dungeon spawners will never drop skulls if this is enabled.\n").define("overwrite_entity_loot_tables", true);
        NO_NETHER_STUFF = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether the hell stage should be built with blocks from the overworld instead from the nether.\n").define("no_nether_blocks", false);
        SPAWNER_RANGE = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n The activation range for the spawners in the dungeons.\n").defineInRange("spawner_activation_range", 12, 1, 64);
        SPAWNER_ENTITIES = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n The number of different entities per spawner. Increasing the number increases the diversity of the monster equipment.\n").defineInRange("spawner_entities", 6, 1, 128);
        CUSTOM_SPAWNERS = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether custom mob spawners with equipment, etc.. should be used.\n").define("custom_spawners", true);
        NATURAL_DESPAWN = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether mobs from spawners should despawn naturally or not.\n").define("natural_despawn", true);
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

