/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra.client;

import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.caelus.api.RenderElytraEvent;
import top.theillusivec4.colytra.Colytra;
import top.theillusivec4.colytra.common.ElytraNBT;
import top.theillusivec4.colytra.integration.AetherIntegration;
import top.theillusivec4.colytra.server.ColytraServerConfig;

public class ClientEventHandler {
    private static void getColytraTooltip(ItemStack chestStack, List<ITextComponent> tooltip) {
        if (!ElytraNBT.hasUpgrade(chestStack)) {
            return;
        }
        ItemStack elytraStack = ElytraNBT.getElytra(chestStack);
        if (elytraStack.func_190926_b()) {
            return;
        }
        tooltip.add((ITextComponent)new StringTextComponent(""));
        if (elytraStack.func_82837_s()) {
            ITextComponent display = elytraStack.func_200301_q();
            if (display instanceof IFormattableTextComponent) {
                ((IFormattableTextComponent)display).func_240699_a_(TextFormatting.AQUA).func_240699_a_(TextFormatting.ITALIC);
            }
            tooltip.add(display);
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.minecraft.elytra").func_240699_a_(TextFormatting.AQUA));
        }
        if (ColytraServerConfig.colytraMode == ColytraServerConfig.ColytraMode.NORMAL) {
            if (elytraStack.func_77942_o()) {
                int i = 0;
                CompoundNBT tag = elytraStack.func_77978_p();
                if (tag != null && tag.func_150297_b("HideFlags", 99)) {
                    i = tag.func_74762_e("HideFlags");
                }
                if (!(i & true)) {
                    ListNBT nbttaglist = elytraStack.func_77986_q();
                    for (int j = 0; j < nbttaglist.size(); ++j) {
                        CompoundNBT nbttagcompound = nbttaglist.func_150305_b(j);
                        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)nbttagcompound.func_74779_i("id")));
                        if (enchantment == null) continue;
                        tooltip.add((ITextComponent)new StringTextComponent(" ").func_230529_a_(enchantment.func_200305_d(nbttagcompound.func_74762_e("lvl"))));
                    }
                }
            }
            if (ElytraNBT.isUseable(chestStack, elytraStack)) {
                tooltip.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("item.durability", new Object[]{elytraStack.func_77958_k() - elytraStack.func_77952_i(), elytraStack.func_77958_k()})));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.colytra.broken").func_240699_a_(TextFormatting.RED)));
            }
        }
    }

    @SubscribeEvent
    public void itemTooltip(ItemTooltipEvent evt) {
        ItemStack itemstack = evt.getItemStack();
        List tooltip = evt.getToolTip();
        ClientEventHandler.getColytraTooltip(itemstack, tooltip);
    }

    @SubscribeEvent
    public void renderElytra(RenderElytraEvent evt) {
        ItemStack stack = evt.getPlayer().func_184582_a(EquipmentSlotType.CHEST);
        ItemStack elytraStack = ElytraNBT.getElytra(stack);
        if (!elytraStack.func_190926_b()) {
            evt.setRender(true);
            if (Colytra.isAetherLoaded) {
                AetherIntegration.checkCape(evt);
            }
            if (elytraStack.func_77948_v()) {
                evt.setEnchanted(true);
            }
        }
    }
}

