/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.util.tetra_definitions;

import javax.annotation.Nullable;
import mod.noobulus.tetrapak.util.ItemHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;

public interface ITetraEffect {
    public static ItemEffect get(String key) {
        return ItemEffect.get((String)("tetrapak:" + key));
    }

    public ItemEffect getEffect();

    default public boolean hasEffect(@Nullable ItemStack stack) {
        return this.getEffectLevel(stack) > 0;
    }

    default public void doBeltTick(PlayerEntity player, int effectLevel) {
    }

    default public void doBeltTick(PlayerEntity player, @Nullable ItemStack belt) {
        this.doBeltTick(player, this.getEffectLevel(belt));
    }

    default public int getBeltEffectLevel(PlayerEntity playerEntity) {
        return this.getEffectLevel(ToolbeltHelper.findToolbelt((PlayerEntity)playerEntity));
    }

    default public boolean hasBeltEffect(@Nullable Entity entity) {
        if (entity instanceof PlayerEntity) {
            return this.getBeltEffectLevel((PlayerEntity)entity) > 0;
        }
        return false;
    }

    default public double getEffectEfficiency(@Nullable DamageSource source) {
        return this.getEffectEfficiency(ItemHelper.getItemOfDamgeSource(source));
    }

    default public boolean hasEffect(DamageSource source) {
        return this.hasEffect(ItemHelper.getItemOfDamgeSource(source));
    }

    default public double getEffectEfficiency(@Nullable ItemStack test) {
        if (test == null || test.func_190926_b() || !(test.func_77973_b() instanceof ModularItem)) {
            return 0.0;
        }
        ModularItem item = (ModularItem)test.func_77973_b();
        return item.getEffectEfficiency(test, this.getEffect());
    }

    default public String getStatsPath() {
        return "tetrapak.stats." + new ResourceLocation(this.getEffect().getKey()).func_110623_a();
    }

    default public int getEffectLevel(@Nullable ItemStack test) {
        if (test == null || test.func_190926_b() || !(test.func_77973_b() instanceof ModularItem)) {
            return 0;
        }
        ModularItem item = (ModularItem)test.func_77973_b();
        return item.getEffectLevel(test, this.getEffect());
    }

    default public String getTooltipPath() {
        return this.getStatsPath() + ".tooltip";
    }
}

