/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mod.noobulus.tetrapak.util.Pair;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.registries.ForgeRegistries;
import se.mickelus.tetra.items.modular.IModularItem;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="tetrapak")
public class ToolHelper {
    private static final Map<Pair<String, Integer>, List<ItemStack>> tools = new HashMap<Pair<String, Integer>, List<ItemStack>>();
    private static final List<Pair<String, String>> materialPairs = Arrays.asList(Pair.of("oak", "stick"), Pair.of("stone", "stick"), Pair.of("iron", "spruce"), Pair.of("blackstone", "spruce"), Pair.of("obsidian", "iron"), Pair.of("netherite", "forged_beam"));
    private static final List<String> doubleSchematics = Arrays.asList("basic_hammer", "claw");

    private ToolHelper() {
    }

    @SubscribeEvent
    public static void onServerStart(FMLServerStartedEvent event) {
        tools.clear();
        ToolHelper.populate();
    }

    public static void populate() {
        for (ToolType t : ToolHelper.getValues().values()) {
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                ItemStack test = new ItemStack((IItemProvider)item);
                for (int i = 0; i <= test.getHarvestLevel(t, null, null); ++i) {
                    tools.computeIfAbsent(Pair.of(t.getName(), i), p -> new ArrayList()).add(test);
                }
            }
        }
        materialPairs.forEach(materials -> {
            doubleSchematics.stream().map(schematic -> ToolHelper.setUpDouble(schematic, (String)materials.getFirst(), (String)materials.getSecond())).forEach(ToolHelper::addModular);
            ToolHelper.addModular(ToolHelper.setUpShortBlade((String)materials.getFirst(), (String)materials.getSecond()));
        });
    }

    private static void addModular(ItemStack tool) {
        tool.getToolTypes().forEach(t -> {
            for (int i = 0; i <= tool.getHarvestLevel(t, null, null); ++i) {
                tools.computeIfAbsent(Pair.of(t.getName(), i), p -> new ArrayList()).add(tool);
            }
        });
    }

    public static List<ItemStack> getToolsOf(ToolType type, int level) {
        if (tools.isEmpty()) {
            ToolHelper.populate();
        }
        return tools.getOrDefault(Pair.of(type.getName(), level), Collections.emptyList());
    }

    public static Map<String, ToolType> getValues() {
        return (Map)ObfuscationReflectionHelper.getPrivateValue(ToolType.class, null, (String)"VALUES");
    }

    private static ItemStack setUpDouble(String moduleVariant, String headMaterial, String handleMaterial) {
        Item modularDouble = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tetra:modular_double"));
        if (modularDouble == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = new ItemStack((IItemProvider)modularDouble);
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"double/head_left", (String)("double/" + moduleVariant + "_left"), (String)("double/" + moduleVariant + "_left_material"), (String)(moduleVariant + "/" + headMaterial));
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"double/head_right", (String)("double/" + moduleVariant + "_right"), (String)("double/" + moduleVariant + "_right_material"), (String)(moduleVariant + "/" + headMaterial));
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"double/handle", (String)"double/basic_handle", (String)"double/basic_handle_material", (String)("basic_handle/" + handleMaterial));
        IModularItem.updateIdentifier((ItemStack)itemStack);
        return itemStack;
    }

    private static ItemStack setUpShortBlade(String bladeMaterial, String handleMaterial) {
        Item modularSword = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tetra:modular_sword"));
        if (modularSword == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = new ItemStack((IItemProvider)modularSword);
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"sword/guard", (String)"sword/makeshift_guard", (String)"sword/makeshift_guard_material", (String)"makeshift_guard/oak");
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"sword/pommel", (String)"sword/decorative_pommel", (String)"sword/decorative_pommel_material", (String)"decorative_pommel/oak");
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"sword/hilt", (String)"sword/basic_hilt", (String)"sword/basic_hilt_material", (String)("basic_hilt/" + handleMaterial));
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)"sword/blade", (String)"sword/short_blade", (String)"sword/short_blade_material", (String)("short_blade/" + bladeMaterial));
        IModularItem.updateIdentifier((ItemStack)itemStack);
        return itemStack;
    }
}

