/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.TetraPak;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.BinomialRange;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="tetrapak")
public class LootLoader {
    private static final Random rand = new Random();
    private static final int STATISTICAL_TEST = 100;
    @Nullable
    private static MinecraftServer server = null;
    private static LootTableManager manager;

    private LootLoader() {
    }

    @SubscribeEvent
    public static void onServerStart(FMLServerStartedEvent event) {
        server = event.getServer();
    }

    @Nullable
    private static MinecraftServer getServer() {
        if (server == null) {
            return (MinecraftServer)DistExecutor.unsafeRunForDist(() -> () -> Minecraft.func_71410_x().func_71401_C(), () -> () -> null);
        }
        return server;
    }

    public static LootTableManager getManager() {
        MinecraftServer server = LootLoader.getServer();
        if (server == null) {
            if (manager == null) {
                manager = new LootTableManager(new LootPredicateManager());
                TetraPak.LOGGER.error("Loot tables should never be calculated on the client!");
            }
            return manager;
        }
        return server.func_200249_aQ();
    }

    public static List<LootSlot> crawlTable(LootTable table, LootTableManager manager) {
        ArrayList<LootSlot> drops = new ArrayList<LootSlot>();
        LootLoader.getPools(table).forEach(pool -> {
            int min = LootLoader.getMin(pool.getRolls());
            int max = LootLoader.getMax(pool.getRolls()) + LootLoader.getMax(pool.getBonusRolls());
            float totalWeight = LootLoader.getLootEntries(pool).stream().filter(StandaloneLootEntry.class::isInstance).map(StandaloneLootEntry.class::cast).mapToInt(entry -> entry.field_216158_e).sum();
            LootLoader.getLootEntries(pool).stream().filter(ItemLootEntry.class::isInstance).map(ItemLootEntry.class::cast).map(entry -> new LootSlot(entry.field_186368_a, (float)entry.field_216158_e / totalWeight, min, max)).forEach(drops::add);
            LootLoader.getLootEntries(pool).stream().filter(TableLootEntry.class::isInstance).map(TableLootEntry.class::cast).map(entry -> LootLoader.crawlTable(manager.func_186521_a(entry.field_186371_a), manager)).forEach(drops::addAll);
        });
        drops.removeIf(Objects::isNull);
        return drops;
    }

    public static List<LootPool> getPools(LootTable table) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String)"field_186466_c");
    }

    public static List<LootEntry> getLootEntries(LootPool pool) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"field_186453_a");
    }

    public static int getMin(IRandomRange randomRange) {
        if (randomRange instanceof ConstantRange) {
            return randomRange.func_186511_a(rand);
        }
        if (randomRange instanceof RandomValueRange) {
            return MathHelper.func_76141_d((float)((RandomValueRange)randomRange).func_186509_a());
        }
        if (randomRange instanceof BinomialRange) {
            return 0;
        }
        return IntStream.iterate(0, i -> randomRange.func_186511_a(rand)).limit(100L).min().orElse(0);
    }

    public static int getMax(IRandomRange randomRange) {
        if (randomRange instanceof ConstantRange) {
            return randomRange.func_186511_a(rand);
        }
        if (randomRange instanceof RandomValueRange) {
            return MathHelper.func_76141_d((float)((RandomValueRange)randomRange).func_186512_b());
        }
        if (randomRange instanceof BinomialRange) {
            return ((BinomialRange)randomRange).field_215841_d;
        }
        return IntStream.iterate(0, i -> randomRange.func_186511_a(rand)).limit(100L).max().orElse(0);
    }

    public static class LootSlot
    implements Supplier<ITextComponent> {
        public final Item item;
        public final int min;
        public final int max;
        public final float chance;

        public LootSlot(Item item, float chance, int min, int max) {
            this.item = item;
            this.min = min;
            this.max = max;
            this.chance = chance;
        }

        public LootSlot(PacketBuffer buffer) {
            ItemStack item = buffer.func_150791_c();
            this.item = item.func_77973_b();
            this.min = item.func_190916_E();
            this.max = buffer.readInt();
            this.chance = buffer.readFloat();
        }

        public ItemStack asStack() {
            return new ItemStack((IItemProvider)this.item, this.min);
        }

        public String toString() {
            if (this.min == this.max) {
                return this.min + this.getDropChance();
            }
            return this.min + "-" + this.max + this.getDropChance();
        }

        private String getDropChance() {
            return this.chance < 1.0f ? " (" + this.formatChance() + "%)" : "";
        }

        private String formatChance() {
            float chance = this.chance * 100.0f;
            if (chance < 10.0f) {
                return String.format("%.1f", Float.valueOf(chance));
            }
            return String.format("%2d", (int)chance);
        }

        @Override
        public ITextComponent get() {
            return new StringTextComponent(this.toString());
        }

        public void toBuffer(PacketBuffer buffer) {
            buffer.func_150788_a(new ItemStack((IItemProvider)this.item, this.min));
            buffer.writeInt(this.max);
            buffer.writeFloat(this.chance);
        }
    }
}

