/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.quark;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import mod.noobulus.tetrapak.TetraPak;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.util.ResourceLocation;

public final class CorundumMap {
    public static final Map<MaterialColor, Integer> COLOR_MAP = new HashMap<MaterialColor, Integer>();
    public static final Map<Integer, ResourceLocation> CRYSTAL_MAP = new HashMap<Integer, ResourceLocation>();
    public static final Map<Integer, String> NAME_MAP = new HashMap<Integer, String>();
    private static final int RED = 1;
    private static final int ORANGE = 2;
    private static final int YELLOW = 3;
    private static final int GREEN = 4;
    private static final int BLUE = 5;
    private static final int INDIGO = 6;
    private static final int VIOLET = 7;
    private static final int WHITE = 8;
    private static final int BLACK = 9;

    private CorundumMap() {
    }

    private static ResourceLocation asQuarkCrystal(String color) {
        return new ResourceLocation("quark", color + "_crystal_cluster");
    }

    public static void checkMappings() {
        TetraPak.LOGGER.info("Checking corundum color mappings...");
        Arrays.stream(MaterialColor.field_76281_a).filter(((Predicate<MaterialColor>)COLOR_MAP::containsKey).negate()).filter(Objects::nonNull).forEach(materialColor -> TetraPak.LOGGER.error("Material color {} of id {} and colour {} was not mapped to a corundum variant", materialColor, (Object)materialColor.field_76290_q, (Object)materialColor.field_76291_p));
    }

    static {
        COLOR_MAP.put(MaterialColor.field_151660_b, 9);
        COLOR_MAP.put(MaterialColor.field_151661_c, 4);
        COLOR_MAP.put(MaterialColor.field_151658_d, 3);
        COLOR_MAP.put(MaterialColor.field_151659_e, 8);
        COLOR_MAP.put(MaterialColor.field_151656_f, 1);
        COLOR_MAP.put(MaterialColor.field_151657_g, 6);
        COLOR_MAP.put(MaterialColor.field_151668_h, 8);
        COLOR_MAP.put(MaterialColor.field_151669_i, 4);
        COLOR_MAP.put(MaterialColor.field_151666_j, 8);
        COLOR_MAP.put(MaterialColor.field_151667_k, 8);
        COLOR_MAP.put(MaterialColor.field_151664_l, 2);
        COLOR_MAP.put(MaterialColor.field_151665_m, 9);
        COLOR_MAP.put(MaterialColor.field_151662_n, 5);
        COLOR_MAP.put(MaterialColor.field_151663_o, 2);
        COLOR_MAP.put(MaterialColor.field_151677_p, 8);
        COLOR_MAP.put(MaterialColor.field_151676_q, 2);
        COLOR_MAP.put(MaterialColor.field_151675_r, 6);
        COLOR_MAP.put(MaterialColor.field_151674_s, 5);
        COLOR_MAP.put(MaterialColor.field_151673_t, 3);
        COLOR_MAP.put(MaterialColor.field_151672_u, 4);
        COLOR_MAP.put(MaterialColor.field_151671_v, 7);
        COLOR_MAP.put(MaterialColor.field_151670_w, 9);
        COLOR_MAP.put(MaterialColor.field_197656_x, 8);
        COLOR_MAP.put(MaterialColor.field_151679_y, 5);
        COLOR_MAP.put(MaterialColor.field_151678_z, 6);
        COLOR_MAP.put(MaterialColor.field_151649_A, 5);
        COLOR_MAP.put(MaterialColor.field_151650_B, 2);
        COLOR_MAP.put(MaterialColor.field_151651_C, 4);
        COLOR_MAP.put(MaterialColor.field_151645_D, 1);
        COLOR_MAP.put(MaterialColor.field_151646_E, 9);
        COLOR_MAP.put(MaterialColor.field_151647_F, 3);
        COLOR_MAP.put(MaterialColor.field_151648_G, 5);
        COLOR_MAP.put(MaterialColor.field_151652_H, 5);
        COLOR_MAP.put(MaterialColor.field_151653_I, 4);
        COLOR_MAP.put(MaterialColor.field_151654_J, 2);
        COLOR_MAP.put(MaterialColor.field_151655_K, 1);
        COLOR_MAP.put(MaterialColor.field_193561_M, 8);
        COLOR_MAP.put(MaterialColor.field_193562_N, 2);
        COLOR_MAP.put(MaterialColor.field_193563_O, 6);
        COLOR_MAP.put(MaterialColor.field_193564_P, 5);
        COLOR_MAP.put(MaterialColor.field_193565_Q, 3);
        COLOR_MAP.put(MaterialColor.field_193566_R, 4);
        COLOR_MAP.put(MaterialColor.field_193567_S, 7);
        COLOR_MAP.put(MaterialColor.field_193568_T, 9);
        COLOR_MAP.put(MaterialColor.field_197655_T, 8);
        COLOR_MAP.put(MaterialColor.field_193570_V, 5);
        COLOR_MAP.put(MaterialColor.field_193571_W, 6);
        COLOR_MAP.put(MaterialColor.field_193572_X, 5);
        COLOR_MAP.put(MaterialColor.field_193573_Y, 2);
        COLOR_MAP.put(MaterialColor.field_193574_Z, 4);
        COLOR_MAP.put(MaterialColor.field_193559_aa, 1);
        COLOR_MAP.put(MaterialColor.field_193560_ab, 9);
        COLOR_MAP.put(MaterialColor.field_241539_ab_, 1);
        COLOR_MAP.put(MaterialColor.field_241540_ac_, 1);
        COLOR_MAP.put(MaterialColor.field_241541_ad_, 1);
        COLOR_MAP.put(MaterialColor.field_241542_ae_, 5);
        COLOR_MAP.put(MaterialColor.field_241543_af_, 5);
        COLOR_MAP.put(MaterialColor.field_241544_ag_, 5);
        COLOR_MAP.put(MaterialColor.field_241545_ah_, 5);
        CRYSTAL_MAP.put(1, CorundumMap.asQuarkCrystal("red"));
        CRYSTAL_MAP.put(2, CorundumMap.asQuarkCrystal("orange"));
        CRYSTAL_MAP.put(3, CorundumMap.asQuarkCrystal("yellow"));
        CRYSTAL_MAP.put(4, CorundumMap.asQuarkCrystal("green"));
        CRYSTAL_MAP.put(5, CorundumMap.asQuarkCrystal("blue"));
        CRYSTAL_MAP.put(6, CorundumMap.asQuarkCrystal("indigo"));
        CRYSTAL_MAP.put(7, CorundumMap.asQuarkCrystal("violet"));
        CRYSTAL_MAP.put(8, CorundumMap.asQuarkCrystal("white"));
        CRYSTAL_MAP.put(9, CorundumMap.asQuarkCrystal("black"));
        NAME_MAP.put(1, "red");
        NAME_MAP.put(2, "orange");
        NAME_MAP.put(3, "yellow");
        NAME_MAP.put(4, "green");
        NAME_MAP.put(5, "blue");
        NAME_MAP.put(6, "indigo");
        NAME_MAP.put(7, "violet");
        NAME_MAP.put(8, "white");
        NAME_MAP.put(9, "black");
    }
}

