/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.predicate.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mod.noobulus.tetrapak.TetraPak;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="tetrapak")
public class TetraEffectPredicate
extends ItemPredicate {
    private static final ItemPredicate ANY = new TetraEffectPredicate(null);
    private static final String JSON_EFFECT_KEY = "effect";
    private static final ResourceLocation ID = TetraPak.asId("has_effect");
    @Nullable
    private final ItemEffect effect;

    public TetraEffectPredicate(@Nullable ItemEffect effect) {
        this.effect = effect;
    }

    private static ItemPredicate fromJson(@Nullable JsonObject jsonObject) {
        if (jsonObject != null && !jsonObject.isJsonNull()) {
            if (jsonObject.has(JSON_EFFECT_KEY)) {
                return new TetraEffectPredicate(ItemEffect.get((String)JSONUtils.func_151200_h((JsonObject)jsonObject, (String)JSON_EFFECT_KEY)));
            }
            return ANY;
        }
        return ItemPredicate.field_192495_a;
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        ItemPredicate.register((ResourceLocation)ID, TetraEffectPredicate::fromJson);
    }

    public boolean func_192493_a(ItemStack tool) {
        if (tool.func_190926_b() || !(tool.func_77973_b() instanceof ModularItem)) {
            return false;
        }
        if (this.effect == null) {
            return true;
        }
        return ((ModularItem)tool.func_77973_b()).getEffectLevel(tool, this.effect) > 0;
    }

    public JsonElement func_200319_a() {
        if (this.effect == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty(JSON_EFFECT_KEY, this.effect.getKey());
        return jsonobject;
    }
}

