/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.druidcraft;

import mod.noobulus.tetrapak.registries.Particles;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.tetra_definitions.IPercentageHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IDayTimeReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.items.modular.ModularItem;

public class MoonstrikeEffect
implements IPercentageHoloDescription,
IEventBusListener {
    private static float getMoonFactor(IDayTimeReader world, double efficiency) {
        return (float)(1.0 + efficiency * (double)world.func_242413_ae() / 100.0);
    }

    private static void spawnMoonParticles(World world, Vector3d pos) {
        if (world instanceof ServerWorld && world.func_242413_ae() != 0.0f) {
            ((ServerWorld)world).func_195598_a((IParticleData)MoonstrikeEffect.getParticleType((IDayTimeReader)world), pos.func_82615_a() + 0.5, pos.func_82617_b() + 0.5, pos.func_82616_c() + 0.5, 12, (world.field_73012_v.nextDouble() * 2.0 - 1.0) * 0.3, 0.3 + world.field_73012_v.nextDouble() * 0.3, (world.field_73012_v.nextDouble() * 2.0 - 1.0) * 0.3, 0.3);
        }
    }

    private static BasicParticleType getParticleType(IDayTimeReader world) {
        float moonSize = world.func_242413_ae();
        return (BasicParticleType)((double)moonSize > 0.5 ? ((double)moonSize > 0.75 ? Particles.MOONSTRIKE_STAGE_3 : Particles.MOONSTRIKE_STAGE_2) : ((double)moonSize > 0.25 ? Particles.MOONSTRIKE_STAGE_1 : Particles.MOONSTRIKE_STAGE_0)).get();
    }

    @SubscribeEvent
    public void moonstrikeToolsBreakBlocksFaster(PlayerEvent.BreakSpeed event) {
        ItemStack heldItemMainhand = event.getPlayer().func_184614_ca();
        if (!(heldItemMainhand.func_77973_b() instanceof ModularItem)) {
            return;
        }
        ModularItem item = (ModularItem)heldItemMainhand.func_77973_b();
        if (this.hasEffect(heldItemMainhand)) {
            World moonPhaseWorld = event.getPlayer().func_130014_f_();
            MoonstrikeEffect.spawnMoonParticles(moonPhaseWorld, Vector3d.func_237491_b_((Vector3i)event.getPos()));
            float efficiency = (float)item.getEffectEfficiency(heldItemMainhand, this.getEffect());
            event.setNewSpeed(event.getOriginalSpeed() * MoonstrikeEffect.getMoonFactor((IDayTimeReader)moonPhaseWorld, efficiency));
        }
    }

    @SubscribeEvent
    public void moonstrikeCausesBonusDamage(LivingHurtEvent event) {
        if (this.hasEffect(event.getSource())) {
            Entity source = event.getSource().func_76364_f();
            if (source == null) {
                return;
            }
            World moonPhaseWorld = source.func_130014_f_();
            double efficiency = this.getEffectEfficiency(event.getSource());
            if (moonPhaseWorld.func_242413_ae() != 0.0f) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().field_71452_i.func_199282_a(event.getEntity(), (IParticleData)MoonstrikeEffect.getParticleType((IDayTimeReader)moonPhaseWorld)));
            }
            event.setAmount(event.getAmount() * MoonstrikeEffect.getMoonFactor((IDayTimeReader)moonPhaseWorld, efficiency));
        }
    }

    @Override
    public ITooltipGetter getStatTooltipGetter(IStatGetter statGetter) {
        return (player, itemStack) -> I18n.func_135052_a((String)this.getTooltipPath(), (Object[])new Object[]{statGetter.getValue(player, itemStack), statGetter.getValue(player, itemStack)});
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("moonstrike");
    }
}

