/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.create.refined_radiance;

import java.util.HashSet;
import java.util.LinkedList;
import javax.annotation.Nullable;
import mod.noobulus.tetrapak.Config;
import mod.noobulus.tetrapak.create.refined_radiance.BlockCollection;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.tetra_definitions.IHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;

public class UnearthingEffect
implements IHoloDescription,
IEventBusListener {
    private static boolean unearthing = false;

    public static void unearth(IWorld iWorld, BlockPos pos, PlayerEntity entity) {
        if (unearthing || entity.func_225608_bj_() || !(iWorld instanceof World)) {
            return;
        }
        World world = (World)iWorld;
        unearthing = true;
        UnearthingEffect.findOreVein((IBlockReader)world, pos).destroyBlocks(world, (LivingEntity)entity, (dropPos, stack) -> Block.func_180635_a((World)world, (BlockPos)dropPos, (ItemStack)stack));
        unearthing = false;
    }

    public static BlockCollection findOreVein(@Nullable IBlockReader world, BlockPos pos) {
        if (world == null) {
            return BlockCollection.EMPTY;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        Block start = world.func_180495_p(pos).func_177230_c();
        if (!Tags.Blocks.ORES.func_230235_a_((Object)start)) {
            return BlockCollection.EMPTY;
        }
        frontier.add(pos);
        while (!frontier.isEmpty()) {
            BlockPos current = (BlockPos)frontier.remove(0);
            visited.add(current);
            for (Direction direction : Direction.values()) {
                BlockPos offset = current.func_177972_a(direction);
                if (visited.contains(offset) || !start.equals(world.func_180495_p(offset).func_177230_c())) continue;
                frontier.add(offset);
            }
            if (visited.size() < (Integer)Config.MAX_RADIANT_BLOCKS.get()) continue;
            return new BlockCollection(visited);
        }
        return new BlockCollection(visited);
    }

    @SubscribeEvent
    public void unearthWhenBlockBroken(BlockEvent.BreakEvent event) {
        if (!unearthing && this.hasEffect(event.getPlayer().func_184614_ca())) {
            UnearthingEffect.unearth(event.getWorld(), event.getPos(), event.getPlayer());
        }
    }

    @Override
    public ITooltipGetter getStatTooltipGetter(IStatGetter statGetter) {
        return (player, itemStack) -> I18n.func_135052_a((String)this.getTooltipPath(), (Object[])new Object[]{Config.MAX_RADIANT_BLOCKS.get()});
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("unearthing");
    }
}

