/*
 * Decompiled with CFR 0.152.
 */
package mod.noobulus.tetrapak.create;

import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import java.util.UUID;
import mod.noobulus.tetrapak.util.IEventBusListener;
import mod.noobulus.tetrapak.util.tetra_definitions.IPercentageHoloDescription;
import mod.noobulus.tetrapak.util.tetra_definitions.ITetraEffect;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.effect.ItemEffect;

public class NullifyingEffect
implements IPercentageHoloDescription,
IEventBusListener {
    public static final AttributeModifier beltGravityModifier = new AttributeModifier(UUID.fromString("678c7388-ba1d-45c8-9f51-d6e4f1c4e3ac"), "Gravity modifier", -0.75, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final AttributeModifier beltDoubleGravityModifier = new AttributeModifier(UUID.fromString("778c7388-ba1d-45c8-9f51-d6e4f1c4e3ac"), "Gravity modifier", -0.875, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final AttributeModifier beltGravityModifierSlowfall = new AttributeModifier(UUID.fromString("878c7388-ba1d-45c8-9f51-d6e4f1c4e3ac"), "Gravity modifier", -0.65, AttributeModifier.Operation.MULTIPLY_TOTAL);

    private static void updateEffect(boolean active, ModifiableAttributeInstance attributeInstance, AttributeModifier modifier) {
        if (active) {
            if (!attributeInstance.func_180374_a(modifier)) {
                attributeInstance.func_233767_b_(modifier);
            }
        } else if (attributeInstance.func_180374_a(modifier)) {
            attributeInstance.func_111124_b(modifier);
        }
    }

    @Override
    public void doBeltTick(PlayerEntity player, int nullifierLevel) {
        ModifiableAttributeInstance gravityAttribute = player.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        if (nullifierLevel < 0 || gravityAttribute == null) {
            return;
        }
        boolean slowfall = player.func_70644_a(Effects.field_204839_B);
        NullifyingEffect.updateEffect(nullifierLevel == 1 && !slowfall, gravityAttribute, beltGravityModifier);
        NullifyingEffect.updateEffect(nullifierLevel == 2 && !slowfall, gravityAttribute, beltDoubleGravityModifier);
        NullifyingEffect.updateEffect(nullifierLevel > 0 && slowfall, gravityAttribute, beltGravityModifierSlowfall);
        if (nullifierLevel > 0 && player.func_213322_ci().func_82617_b() < 0.0) {
            player.field_70143_R = 1.0f;
        }
        if (nullifierLevel > 0 && player.func_213322_ci().func_82617_b() >= 0.0) {
            player.field_70143_R = 0.0f;
        }
        if (player.field_70170_p.field_72995_K) {
            Vector3d pos = player.func_213303_ch();
            if (player.field_70170_p.field_73012_v.nextFloat() < (float)nullifierLevel / 2.0f) {
                Vector3d basemotion = VecHelper.offsetRandomly((Vector3d)pos, (Random)player.field_70170_p.field_73012_v, (float)0.5f);
                player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, basemotion.field_72450_a, pos.field_72448_b, basemotion.field_72449_c, 0.0, (double)-0.1f, 0.0);
            }
        }
    }

    @SubscribeEvent
    public void onFarmlandTrampled(BlockEvent.FarmlandTrampleEvent event) {
        if (this.hasBeltEffect(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @Override
    public double getStatMultiplier() {
        return 12.5;
    }

    @Override
    public double getStatBase() {
        return 62.5;
    }

    @Override
    public ItemEffect getEffect() {
        return ITetraEffect.get("nullifying");
    }
}

