/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityRoadrunner;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlyingAIFollowOwner;
import com.github.alexthe666.alexsmobs.message.MessageTarantulaHawkSting;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;

public class EntityTarantulaHawk
extends TameableEntity
implements IFollower {
    public static final int STING_DURATION = 2400;
    protected static final EntitySize FLIGHT_SIZE = EntitySize.func_220311_c((float)0.9f, (float)1.5f);
    private static final DataParameter<Float> FLY_ANGLE = EntityDataManager.func_187226_a(EntityTarantulaHawk.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> NETHER = EntityDataManager.func_187226_a(EntityTarantulaHawk.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityTarantulaHawk.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DRAGGING = EntityDataManager.func_187226_a(EntityTarantulaHawk.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityTarantulaHawk.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DIGGING = EntityDataManager.func_187226_a(EntityTarantulaHawk.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SCARED = EntityDataManager.func_187226_a(EntityTarantulaHawk.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ATTACK_TICK = EntityDataManager.func_187226_a(EntityTarantulaHawk.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityTarantulaHawk.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ANGRY = EntityDataManager.func_187226_a(EntityTarantulaHawk.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float prevFlyAngle;
    public float prevSitProgress;
    public float sitProgress;
    public float prevDragProgress;
    public float dragProgress;
    public float prevFlyProgress;
    public float flyProgress;
    public float prevAttackProgress;
    public float attackProgress;
    public float prevDigProgress;
    public float digProgress;
    private boolean isLandNavigator;
    private boolean flightSize = false;
    private int timeFlying = 0;
    private boolean bredBuryFlag = false;
    private int spiderFeedings = 0;
    private int dragTime = 0;

    protected EntityTarantulaHawk(EntityType type, World worldIn) {
        super(type, worldIn);
        this.switchNavigator(false);
    }

    public static boolean canTarantulaHawkSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        boolean spawnBlock = BlockTags.field_203436_u.func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        return spawnBlock && worldIn.func_226659_b_(pos, 0) > 8 || EntityTarantulaHawk.isBiomeNether(worldIn, pos) || AMConfig.fireproofTarantulaHawk;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 18.0).func_233815_a_(Attributes.field_233826_i_, 4.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.tarantulaHawkSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (EntityTarantulaHawk.isBiomeNether((IWorld)worldIn, this.func_233580_cy_())) {
            this.setNether(true);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private static boolean isBiomeNether(IWorld worldIn, BlockPos position) {
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)worldIn.func_226691_t_(position).getRegistryName());
        return BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FlyingAIFollowOwner(this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new AIFleeRoadrunners());
        this.field_70714_bg.func_75776_a(4, (Goal)new AIMelee());
        this.field_70714_bg.func_75776_a(5, (Goal)new AIBury());
        this.field_70714_bg.func_75776_a(6, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151070_bp, Items.field_151071_bq}), false));
        this.field_70714_bg.func_75776_a(8, (Goal)new AIWalkIdle());
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new AnimalAIHurtByTargetNotBaby((AnimalEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new EntityAINearestTarget3D((MobEntity)this, SpiderEntity.class, 15, true, true, null){

            public boolean func_75250_a() {
                return super.func_75250_a() && !EntityTarantulaHawk.this.func_70631_g_() && !EntityTarantulaHawk.this.isSitting();
            }
        });
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.TARANTULA_HAWK_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.TARANTULA_HAWK_HURT;
    }

    public boolean func_230279_az_() {
        return this.isNether() || AMConfig.fireproofTarantulaHawk;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new MoveController();
            this.field_70699_by = new DirectPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLY_ANGLE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(NETHER, (Object)false);
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(DRAGGING, (Object)false);
        this.field_70180_af.func_187214_a(DIGGING, (Object)false);
        this.field_70180_af.func_187214_a(SCARED, (Object)false);
        this.field_70180_af.func_187214_a(ANGRY, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_TICK, (Object)0);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof LivingEntity && ((LivingEntity)source.func_76346_g()).func_70668_bt() == CreatureAttribute.field_223224_c_ && ((LivingEntity)source.func_76346_g()).func_70644_a(AMEffectRegistry.DEBILITATING_STING)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HawkSitting", this.isSitting());
        compound.func_74757_a("Nether", this.isNether());
        compound.func_74757_a("Digging", this.isDigging());
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74768_a("Command", this.getCommand());
        compound.func_74768_a("SpiderFeedings", this.spiderFeedings);
        compound.func_74757_a("BreedFlag", this.bredBuryFlag);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_233687_w_(compound.func_74767_n("HawkSitting"));
        this.setNether(compound.func_74767_n("Nether"));
        this.setDigging(compound.func_74767_n("Digging"));
        this.setFlying(compound.func_74767_n("Flying"));
        this.setCommand(compound.func_74762_e("Command"));
        this.spiderFeedings = compound.func_74762_e("SpiderFeedings");
        this.bredBuryFlag = compound.func_74767_n("BreedFlag");
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public float getFlyAngle() {
        return ((Float)this.field_70180_af.func_187225_a(FLY_ANGLE)).floatValue();
    }

    public void setFlyAngle(float progress) {
        this.field_70180_af.func_187227_b(FLY_ANGLE, (Object)Float.valueOf(progress));
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        if (flying && this.func_70631_g_()) {
            return;
        }
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public boolean isNether() {
        return (Boolean)this.field_70180_af.func_187225_a(NETHER);
    }

    public void setNether(boolean sit) {
        this.field_70180_af.func_187227_b(NETHER, (Object)sit);
    }

    public boolean isScared() {
        return (Boolean)this.field_70180_af.func_187225_a(SCARED);
    }

    public void setScared(boolean sit) {
        this.field_70180_af.func_187227_b(SCARED, (Object)sit);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void func_233687_w_(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    public boolean isDragging() {
        return (Boolean)this.field_70180_af.func_187225_a(DRAGGING);
    }

    public void setDragging(boolean sit) {
        this.field_70180_af.func_187227_b(DRAGGING, (Object)sit);
    }

    public boolean isDigging() {
        return (Boolean)this.field_70180_af.func_187225_a(DIGGING);
    }

    public void setDigging(boolean sit) {
        this.field_70180_af.func_187227_b(DIGGING, (Object)sit);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isFlying() && !this.func_70631_g_() ? FLIGHT_SIZE : super.func_213305_a(poseIn);
    }

    public void func_70071_h_() {
        this.prevFlyAngle = this.getFlyAngle();
        super.func_70071_h_();
        this.prevAttackProgress = this.attackProgress;
        this.prevFlyProgress = this.flyProgress;
        this.prevSitProgress = this.sitProgress;
        this.prevDragProgress = this.dragProgress;
        this.prevDigProgress = this.digProgress;
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.isSitting() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isDragging() && this.dragProgress < 5.0f) {
            this.dragProgress += 1.0f;
        }
        if (!this.isDragging() && this.dragProgress > 0.0f) {
            this.dragProgress -= 1.0f;
        }
        if (this.isDigging() && this.digProgress < 5.0f) {
            this.digProgress += 1.0f;
        }
        if (!this.isDigging() && this.digProgress > 0.0f) {
            this.digProgress -= 1.0f;
        }
        if (this.flightSize && !this.isFlying()) {
            this.func_213323_x_();
            this.flightSize = false;
        }
        if (!this.flightSize && this.isFlying()) {
            this.func_213323_x_();
            this.flightSize = true;
        }
        float threshold = 0.015f;
        if (this.isFlying() && this.field_70126_B - this.field_70177_z > threshold) {
            this.setFlyAngle(this.getFlyAngle() + 5.0f);
        } else if (this.isFlying() && this.field_70126_B - this.field_70177_z < -threshold) {
            this.setFlyAngle(this.getFlyAngle() - 5.0f);
        } else if (this.getFlyAngle() > 0.0f) {
            this.setFlyAngle(Math.max(this.getFlyAngle() - 4.0f, 0.0f));
        } else if (this.getFlyAngle() < 0.0f) {
            this.setFlyAngle(Math.min(this.getFlyAngle() + 4.0f, 0.0f));
        }
        this.setFlyAngle(MathHelper.func_76131_a((float)this.getFlyAngle(), (float)-30.0f, (float)30.0f));
        if (!this.field_70170_p.field_72995_K) {
            if (this.isFlying() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isFlying() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (this.isFlying()) {
                if (this.timeFlying % 25 == 0) {
                    this.func_184185_a(AMSoundRegistry.TARANTULA_HAWK_WING, this.func_70599_aP(), this.func_70647_i());
                }
                ++this.timeFlying;
                this.func_189654_d(true);
                if (this.isSitting() || this.func_184218_aH() || this.func_70880_s()) {
                    this.setFlying(false);
                }
            } else {
                this.timeFlying = 0;
                this.func_189654_d(false);
            }
            if (this.func_70638_az() != null && this.func_70638_az() instanceof PlayerEntity && !this.func_70909_n()) {
                this.field_70180_af.func_187227_b(ANGRY, (Object)true);
            } else {
                this.field_70180_af.func_187227_b(ANGRY, (Object)false);
            }
        }
        if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) > 0) {
            this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) - 1));
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 1.0f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
        if (this.isDigging() && this.field_70170_p.func_180495_p(this.func_226270_aj_()).func_200132_m()) {
            BlockPos posit = this.func_226270_aj_();
            BlockState understate = this.field_70170_p.func_180495_p(posit);
            for (int i = 0; i < 4 + this.field_70146_Z.nextInt(2); ++i) {
                double particleX = (float)posit.func_177958_n() + this.field_70146_Z.nextFloat();
                double particleY = (float)posit.func_177956_o() + 1.0f;
                double particleZ = (float)posit.func_177952_p() + this.field_70146_Z.nextFloat();
                double motX = this.field_70146_Z.nextGaussian() * 0.02;
                double motY = 0.1f + this.field_70146_Z.nextFloat() * 0.2f;
                double motZ = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, understate), particleX, particleY, particleZ, motX, motY, motZ);
            }
        }
        if (this.field_70173_aa > 0 && this.field_70173_aa % 300 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(1.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.isDragging() && this.func_184188_bt().isEmpty() && !this.isDigging()) {
            ++this.dragTime;
            if (this.dragTime > 5000) {
                this.dragTime = 0;
                for (Entity e : this.func_184188_bt()) {
                    e.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 10.0f);
                }
                this.func_184226_ay();
                this.setDragging(false);
            }
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (!this.func_70909_n() && item == Items.field_151070_bp) {
            this.func_175505_a(player, itemstack);
            this.func_184185_a(SoundEvents.field_232840_oa_, this.func_70599_aP(), this.func_70647_i());
            ++this.spiderFeedings;
            if (this.spiderFeedings >= 15 && this.func_70681_au().nextInt(6) == 0 || this.spiderFeedings > 25) {
                this.func_193101_c(player);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_70909_n() && item.func_206844_a((ITag)ItemTags.field_226159_I_)) {
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_175505_a(player, itemstack);
                this.func_184185_a(SoundEvents.field_232840_oa_, this.func_70599_aP(), this.func_70647_i());
                this.func_70691_i(5.0f);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (type != ActionResultType.SUCCESS && this.func_70909_n() && this.func_152114_e((LivingEntity)player)) {
            if (player.func_225608_bj_()) {
                if (this.func_184614_ca().func_190926_b()) {
                    ItemStack cop = itemstack.func_77946_l();
                    cop.func_190920_e(1);
                    this.func_184611_a(Hand.MAIN_HAND, cop);
                    itemstack.func_190918_g(1);
                    return ActionResultType.SUCCESS;
                }
                this.func_199701_a_(this.func_184614_ca().func_77946_l());
                this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                return ActionResultType.SUCCESS;
            }
            if (!this.func_70877_b(itemstack)) {
                boolean sit;
                this.setCommand(this.getCommand() + 1);
                if (this.getCommand() == 3) {
                    this.setCommand(0);
                }
                player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.alexsmobs.all.command_" + this.getCommand(), new Object[]{this.func_200200_C_()}), true);
                boolean bl = sit = this.getCommand() == 2;
                if (sit) {
                    this.func_233687_w_(true);
                    return ActionResultType.SUCCESS;
                }
                this.func_233687_w_(false);
                return ActionResultType.SUCCESS;
            }
        }
        return type;
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return this.func_70909_n() && item == Items.field_151071_bq;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76367_g || super.func_180431_b(source);
    }

    public void func_234177_a_(ServerWorld world, AnimalEntity animalEntity) {
        this.bredBuryFlag = true;
        ServerPlayerEntity serverplayerentity = this.func_191993_do();
        if (serverplayerentity == null && animalEntity.func_191993_do() != null) {
            serverplayerentity = animalEntity.func_191993_do();
        }
        if (serverplayerentity != null) {
            serverplayerentity.func_195066_a(Stats.field_151186_x);
            CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, (AnimalEntity)this, animalEntity, (AgeableEntity)this);
        }
        this.func_70873_a(6000);
        animalEntity.func_70873_a(6000);
        this.func_70875_t();
        animalEntity.func_70875_t();
        world.func_72960_a((Entity)this, (byte)7);
        world.func_72960_a((Entity)this, (byte)18);
        if (world.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_70681_au().nextInt(7) + 1));
        }
    }

    @Override
    public void followEntity(TameableEntity tameable, LivingEntity owner, double followSpeed) {
        if (this.func_70032_d((Entity)owner) > 5.0f) {
            this.setFlying(true);
            this.func_70605_aq().func_75642_a(owner.func_226277_ct_(), owner.func_226278_cu_() + (double)owner.func_213302_cg(), owner.func_226281_cx_(), followSpeed);
        } else {
            if (this.field_70122_E) {
                this.setFlying(false);
            }
            if (this.isFlying() && !this.isOverWater()) {
                BlockPos vec = this.getCrowGround(this.func_233580_cy_());
                if (vec != null) {
                    this.func_70605_aq().func_75642_a((double)vec.func_177958_n(), (double)vec.func_177956_o(), (double)vec.func_177952_p(), followSpeed);
                }
            } else {
                this.func_70661_as().func_75497_a((Entity)owner, followSpeed);
            }
        }
    }

    public void func_184232_k(Entity passenger) {
        this.field_70125_A = 0.0f;
        float radius = 1.0f + passenger.func_213311_cf() * 0.5f;
        float angle = (float)Math.PI / 180 * (this.field_70761_aq - 180.0f);
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        double extraY = 0.0;
        passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY, this.func_226281_cx_() + extraZ);
    }

    private boolean isOverWater() {
        BlockPos position = this.func_233580_cy_();
        while (position.func_177956_o() > 0 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        return !this.field_70170_p.func_204610_c(position).func_206888_e() || position.func_177956_o() <= 0;
    }

    public Vector3d getBlockInViewAway(Vector3d fleePos, float radiusAdd) {
        float radius = -9.45f - (float)this.func_70681_au().nextInt(24) - radiusAdd;
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, 0.0, fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getCrowGround(radialPos);
        int distFromGround = (int)this.func_226278_cu_() - ground.func_177956_o();
        int flightHeight = 4 + this.func_70681_au().nextInt(10);
        BlockPos newPos = ground.func_177981_b(distFromGround > 8 ? flightHeight : this.func_70681_au().nextInt(6) + 1);
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && this.func_195048_a(Vector3d.func_237489_a_((Vector3i)newPos)) > 1.0) {
            return Vector3d.func_237489_a_((Vector3i)newPos);
        }
        return null;
    }

    private BlockPos getCrowGround(BlockPos in) {
        BlockPos position = new BlockPos((double)in.func_177958_n(), this.func_226278_cu_(), (double)in.func_177952_p());
        while (position.func_177956_o() > 2 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        return position;
    }

    public Vector3d getBlockGrounding(Vector3d fleePos) {
        float radius = -9.45f - (float)this.func_70681_au().nextInt(24);
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, this.func_226278_cu_(), fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getCrowGround(radialPos);
        if (ground.func_177956_o() == 0) {
            return this.func_213303_ch();
        }
        ground = this.func_233580_cy_();
        while (ground.func_177956_o() > 2 && this.field_70170_p.func_175623_d(ground)) {
            ground = ground.func_177977_b();
        }
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)ground.func_177984_a()))) {
            return Vector3d.func_237489_a_((Vector3i)ground);
        }
        return null;
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    private Vector3d getOrbitVec(Vector3d vector3d, float gatheringCircleDist, boolean orbitClockwise) {
        Vector3d pos;
        float angle = (float)Math.PI / 90 * (float)(orbitClockwise ? -this.field_70173_aa : this.field_70173_aa);
        double extraX = gatheringCircleDist * MathHelper.func_76126_a((float)angle);
        double extraZ = gatheringCircleDist * MathHelper.func_76134_b((float)angle);
        if (vector3d != null && this.field_70170_p.func_175623_d(new BlockPos(pos = new Vector3d(vector3d.func_82615_a() + extraX, vector3d.func_82617_b() + (double)this.field_70146_Z.nextInt(2) + 4.0, vector3d.func_82616_c() + extraZ)))) {
            return pos;
        }
        return null;
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
    }

    private BlockPos genSandPos(BlockPos parent) {
        World world = this.field_70170_p;
        Random random = new Random();
        int range = 24;
        for (int i = 0; i < 15; ++i) {
            BlockPos sandAir = parent.func_177982_a(random.nextInt(range) - range / 2, -5, random.nextInt(range) - range / 2);
            while (!world.func_175623_d(sandAir) && sandAir.func_177956_o() < 255) {
                sandAir = sandAir.func_177984_a();
            }
            BlockState state = world.func_180495_p(sandAir.func_177977_b());
            if (!BlockTags.field_203436_u.func_230235_a_((Object)state.func_177230_c())) continue;
            return sandAir.func_177977_b();
        }
        return null;
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1 && !this.isDragging() && !this.isDigging() && (this.func_70638_az() == null || !this.func_70638_az().func_70089_S());
    }

    public boolean isAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(ANGRY);
    }

    private class AIFleeRoadrunners
    extends Goal {
        private int searchCooldown = 0;
        private LivingEntity fear = null;
        private Vector3d fearVec = null;

        private AIFleeRoadrunners() {
        }

        public boolean func_75250_a() {
            if (this.searchCooldown <= 0) {
                this.searchCooldown = 100 + EntityTarantulaHawk.this.field_70146_Z.nextInt(100);
                List list = EntityTarantulaHawk.this.field_70170_p.func_217357_a(EntityRoadrunner.class, EntityTarantulaHawk.this.func_174813_aQ().func_72314_b(15.0, 32.0, 15.0));
                for (EntityRoadrunner roadrunner : list) {
                    if (this.fear != null && !(EntityTarantulaHawk.this.func_70032_d((Entity)this.fear) > EntityTarantulaHawk.this.func_70032_d((Entity)roadrunner))) continue;
                    this.fear = roadrunner;
                }
            } else {
                --this.searchCooldown;
            }
            return EntityTarantulaHawk.this.func_70089_S() && this.fear != null;
        }

        public boolean func_75253_b() {
            return this.fear != null && this.fear.func_70089_S() && EntityTarantulaHawk.this.func_70032_d((Entity)this.fear) < 32.0f;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityTarantulaHawk.this.setScared(true);
        }

        public void func_75246_d() {
            if (this.fear != null) {
                if (this.fearVec == null || EntityTarantulaHawk.this.func_195048_a(this.fearVec) < 4.0) {
                    this.fearVec = EntityTarantulaHawk.this.getBlockInViewAway(this.fearVec == null ? this.fear.func_213303_ch() : this.fearVec, 12.0f);
                }
                if (this.fearVec != null) {
                    EntityTarantulaHawk.this.setFlying(true);
                    EntityTarantulaHawk.this.func_70605_aq().func_75642_a(this.fearVec.field_72450_a, this.fearVec.field_72448_b, this.fearVec.field_72449_c, (double)1.1f);
                }
            }
        }

        public void func_75251_c() {
            EntityTarantulaHawk.this.setScared(false);
            this.fear = null;
            this.fearVec = null;
        }
    }

    private class AIBury
    extends Goal {
        private EntityTarantulaHawk hawk;
        private BlockPos buryPos = null;
        private int digTime = 0;
        private double stageX;
        private double stageY;
        private double stageZ;

        private AIBury() {
            this.hawk = EntityTarantulaHawk.this;
        }

        public boolean func_75250_a() {
            BlockPos pos;
            if (this.hawk.isDragging() && this.hawk.func_70638_az() != null && (pos = this.hawk.genSandPos(this.hawk.func_233580_cy_())) != null) {
                this.buryPos = pos;
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.hawk.isDragging() && this.digTime < 200 && this.hawk.func_70638_az() != null && this.buryPos != null && BlockTags.field_203436_u.func_230235_a_((Object)EntityTarantulaHawk.this.field_70170_p.func_180495_p(this.buryPos).func_177230_c());
        }

        public void func_75249_e() {
            this.digTime = 0;
            this.stageX = this.hawk.func_226277_ct_();
            this.stageY = this.hawk.func_226278_cu_();
            this.stageZ = this.hawk.func_226281_cx_();
        }

        public void func_75251_c() {
            this.digTime = 0;
            this.hawk.setDigging(false);
            this.hawk.setDragging(false);
            this.hawk.func_70624_b(null);
            this.hawk.func_70604_c(null);
        }

        public void func_75246_d() {
            this.hawk.setFlying(false);
            this.hawk.setDragging(true);
            LivingEntity target = this.hawk.func_70638_az();
            if (this.hawk.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.buryPos)) < 9.0 && !this.hawk.isDigging()) {
                this.hawk.setDigging(true);
                this.stageX = target.func_226277_ct_();
                this.stageY = target.func_226278_cu_();
                this.stageZ = target.func_226281_cx_();
            }
            if (this.hawk.isDigging()) {
                target.field_70145_X = true;
                ++this.digTime;
                this.hawk.func_184226_ay();
                target.func_70107_b(this.stageX, this.stageY - (double)Math.min(3.0f, (float)this.digTime * 0.05f), this.stageZ);
                this.hawk.func_70661_as().func_75492_a(this.stageX, this.stageY, this.stageZ, (double)0.85f);
            } else {
                this.hawk.func_70661_as().func_75492_a((double)this.buryPos.func_177958_n(), (double)this.buryPos.func_177956_o(), (double)this.buryPos.func_177952_p(), 0.5);
            }
        }
    }

    private class AIWalkIdle
    extends Goal {
        protected final EntityTarantulaHawk hawk;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public AIWalkIdle() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.hawk = EntityTarantulaHawk.this;
        }

        public boolean func_75250_a() {
            if (this.hawk.func_184207_aI() || this.hawk.isScared() || this.hawk.isDragging() || EntityTarantulaHawk.this.getCommand() == 1 || this.hawk.func_70638_az() != null && this.hawk.func_70638_az().func_70089_S() || this.hawk.func_184218_aH() || this.hawk.isSitting()) {
                return false;
            }
            if (this.hawk.func_70681_au().nextInt(30) != 0 && !this.hawk.isFlying()) {
                return false;
            }
            this.flightTarget = this.hawk.func_233570_aj_() ? EntityTarantulaHawk.this.field_70146_Z.nextBoolean() : EntityTarantulaHawk.this.field_70146_Z.nextInt(5) > 0 && this.hawk.timeFlying < 200;
            Vector3d lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.field_72450_a;
            this.y = lvt_1_1_.field_72448_b;
            this.z = lvt_1_1_.field_72449_c;
            return true;
        }

        public void func_75246_d() {
            if (this.flightTarget) {
                this.hawk.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
            } else {
                this.hawk.func_70661_as().func_75492_a(this.x, this.y, this.z, 1.0);
            }
            if (!this.flightTarget && EntityTarantulaHawk.this.isFlying() && this.hawk.field_70122_E) {
                this.hawk.setFlying(false);
            }
            if (EntityTarantulaHawk.this.isFlying() && this.hawk.field_70122_E && this.hawk.timeFlying > 10) {
                this.hawk.setFlying(false);
            }
        }

        @Nullable
        protected Vector3d getPosition() {
            Vector3d vector3d = this.hawk.func_213303_ch();
            if (this.hawk.isOverWater()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.hawk.timeFlying < 50 || this.hawk.isOverWater()) {
                    return this.hawk.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.hawk.getBlockGrounding(vector3d);
            }
            return RandomPositionGenerator.func_75463_a((CreatureEntity)this.hawk, (int)10, (int)7);
        }

        public boolean func_75253_b() {
            if (this.hawk.isSitting() || EntityTarantulaHawk.this.getCommand() == 1) {
                return false;
            }
            if (this.flightTarget) {
                return this.hawk.isFlying() && this.hawk.func_70092_e(this.x, this.y, this.z) > 2.0;
            }
            return !this.hawk.func_70661_as().func_75500_f() && !this.hawk.func_184207_aI();
        }

        public void func_75249_e() {
            if (this.flightTarget) {
                this.hawk.setFlying(true);
                this.hawk.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
            } else {
                this.hawk.func_70661_as().func_75492_a(this.x, this.y, this.z, 1.0);
            }
        }

        public void func_75251_c() {
            this.hawk.func_70661_as().func_75499_g();
            super.func_75251_c();
        }
    }

    private class AIMelee
    extends Goal {
        private EntityTarantulaHawk hawk;
        private int orbitCooldown = 0;
        private boolean clockwise = false;
        private Vector3d orbitVec = null;
        private BlockPos sandPos = null;

        public AIMelee() {
            this.hawk = EntityTarantulaHawk.this;
        }

        public boolean func_75250_a() {
            return this.hawk.func_70638_az() != null && !this.hawk.isSitting() && !this.hawk.isScared() && this.hawk.func_70638_az().func_70089_S() && !this.hawk.isDragging() && !this.hawk.isDigging() && !this.hawk.func_70638_az().field_70145_X && !this.hawk.func_70638_az().func_184218_aH();
        }

        public void func_75249_e() {
            this.hawk.setDragging(false);
            this.clockwise = EntityTarantulaHawk.this.field_70146_Z.nextBoolean();
        }

        public void func_75246_d() {
            boolean paralizedWithChild;
            LivingEntity target = this.hawk.func_70638_az();
            boolean paralized = target != null && target.func_70668_bt() == CreatureAttribute.field_223224_c_ && !target.field_70145_X && target.func_70644_a(AMEffectRegistry.DEBILITATING_STING);
            boolean bl = paralizedWithChild = paralized && target.func_70660_b(AMEffectRegistry.DEBILITATING_STING).func_76458_c() > 0;
            if (this.sandPos == null || !BlockTags.field_203436_u.func_230235_a_((Object)EntityTarantulaHawk.this.field_70170_p.func_180495_p(this.sandPos).func_177230_c())) {
                this.sandPos = this.hawk.genSandPos(target.func_233580_cy_());
            }
            if (this.orbitCooldown > 0) {
                --this.orbitCooldown;
                this.hawk.setFlying(true);
                if (target != null && (this.orbitVec == null || this.hawk.func_195048_a(this.orbitVec) < 4.0 || !this.hawk.func_70605_aq().func_75640_a())) {
                    this.orbitVec = this.hawk.getOrbitVec(target.func_213303_ch().func_72441_c(0.0, (double)target.func_213302_cg(), 0.0), 10 + EntityTarantulaHawk.this.field_70146_Z.nextInt(2), false);
                    if (this.orbitVec != null) {
                        this.hawk.func_70605_aq().func_75642_a(this.orbitVec.field_72450_a, this.orbitVec.field_72448_b, this.orbitVec.field_72449_c, 1.0);
                    }
                }
            } else if ((paralized && !this.hawk.func_70909_n() || paralizedWithChild && this.hawk.bredBuryFlag) && this.sandPos != null) {
                if (this.hawk.func_233570_aj_()) {
                    this.hawk.setFlying(false);
                    this.hawk.func_70661_as().func_75497_a((Entity)target, 1.0);
                } else {
                    Vector3d vector3d = this.hawk.getBlockGrounding(this.hawk.func_213303_ch());
                    if (vector3d != null && this.hawk.isFlying()) {
                        this.hawk.func_70605_aq().func_75642_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, 1.0);
                    }
                }
                if (this.hawk.func_70032_d((Entity)target) < target.func_213311_cf() + 1.5f && !target.func_184218_aH()) {
                    this.hawk.setDragging(true);
                    this.hawk.setFlying(false);
                    target.func_184205_a((Entity)this.hawk, true);
                }
            } else if (target != null && !paralizedWithChild) {
                double dist = this.hawk.func_70032_d((Entity)target);
                if (dist < 10.0 && !this.hawk.isFlying()) {
                    if (this.hawk.func_233570_aj_()) {
                        this.hawk.setFlying(false);
                    }
                    this.hawk.func_70661_as().func_75497_a((Entity)target, 1.0);
                } else {
                    this.hawk.setFlying(true);
                    this.hawk.func_70605_aq().func_75642_a(target.func_226277_ct_(), target.func_226280_cw_(), target.func_226281_cx_(), 1.0);
                }
                if (dist < (double)(target.func_213311_cf() + 2.5f)) {
                    if ((Integer)this.hawk.field_70180_af.func_187225_a(ATTACK_TICK) == 0 && this.hawk.attackProgress == 0.0f) {
                        this.hawk.field_70180_af.func_187227_b(ATTACK_TICK, (Object)7);
                    }
                    if (this.hawk.attackProgress == 5.0f) {
                        this.hawk.func_70652_k((Entity)target);
                        if (this.hawk.bredBuryFlag && target.func_110143_aJ() <= 1.0f) {
                            target.func_70691_i(5.0f);
                        }
                        target.func_195064_c(new EffectInstance(AMEffectRegistry.DEBILITATING_STING, target.func_70668_bt() == CreatureAttribute.field_223224_c_ ? 2400 : 600, this.hawk.bredBuryFlag ? 1 : 0));
                        if (!this.hawk.field_70170_p.field_72995_K && target.func_70668_bt() == CreatureAttribute.field_223224_c_) {
                            AlexsMobs.sendMSGToAll(new MessageTarantulaHawkSting(this.hawk.func_145782_y(), target.func_145782_y()));
                        }
                        this.orbitCooldown = target.func_70668_bt() == CreatureAttribute.field_223224_c_ ? 200 + EntityTarantulaHawk.this.field_70146_Z.nextInt(200) : 10 + EntityTarantulaHawk.this.field_70146_Z.nextInt(20);
                    }
                }
            }
        }

        public void func_75251_c() {
            this.orbitCooldown = 0;
            this.hawk.bredBuryFlag = false;
            this.clockwise = EntityTarantulaHawk.this.field_70146_Z.nextBoolean();
            this.orbitVec = null;
            if (this.hawk.func_184188_bt().isEmpty()) {
                this.hawk.func_70624_b(null);
            }
        }
    }

    class MoveController
    extends MovementController {
        private final MobEntity parentEntity;

        public MoveController() {
            super((MobEntity)EntityTarantulaHawk.this);
            this.parentEntity = EntityTarantulaHawk.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                double width;
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (d0 < (width = this.parentEntity.func_174813_aQ().func_72320_b())) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_186678_a(0.5));
                } else {
                    float angle = (float)Math.PI / 180 * (this.parentEntity.field_70761_aq + 90.0f);
                    float radius = (float)Math.sin((float)this.parentEntity.field_70173_aa * 0.2f) * 2.0f;
                    double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                    double extraZ = radius * MathHelper.func_76134_b((float)angle);
                    Vector3d vector3d1 = vector3d.func_186678_a(this.field_75645_e * 0.05 / d0);
                    Vector3d strafPlus = new Vector3d(extraX, 0.0, extraZ).func_186678_a(0.003 * Math.min(d0, 100.0));
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(strafPlus));
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d1));
                    this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                    if (!EntityTarantulaHawk.this.isDragging()) {
                        this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z;
                    }
                }
            }
        }
    }
}

