/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntitySandShot;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;

public class EntityGuster
extends MonsterEntity {
    private static final DataParameter<Integer> LIFT_ENTITY = EntityDataManager.func_187226_a(EntityGuster.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityGuster.class, (IDataSerializer)DataSerializers.field_187192_b);
    private LivingEntity liftedEntity;
    private int liftingTime = 0;
    private int maxLiftTime = 40;
    private int shootingTicks;
    public static final ResourceLocation RED_LOOT = new ResourceLocation("alexsmobs", "entities/guster_red");
    public static final ResourceLocation SOUL_LOOT = new ResourceLocation("alexsmobs", "entities/guster_soul");

    protected EntityGuster(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    public int func_70627_aG() {
        return 80;
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.GUSTER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.GUSTER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.GUSTER_HURT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.getVariant() == 2 ? SOUL_LOOT : (this.getVariant() == 1 ? RED_LOOT : super.func_184647_J());
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    public static boolean canGusterSpawn(EntityType animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        boolean spawnBlock = BlockTags.field_203436_u.func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c()) || BlockTags.field_232880_av_.func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        return spawnBlock && (!AMConfig.limitGusterSpawnsToWeather || worldIn.func_72912_H() != null && (worldIn.func_72912_H().func_76061_m() || worldIn.func_72912_H().func_76059_o()) || EntityGuster.isBiomeNether(worldIn, pos));
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.gusterSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 60, 1.0, 10, 7));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new GroundPathNavigatorWide((MobEntity)this, worldIn);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    public void func_82167_n(Entity entityIn) {
        if (this.getLiftedEntity() == null && this.liftingTime >= 0 && !(entityIn instanceof EntityGuster)) {
            this.setLiftedEntity(entityIn.func_145782_y());
            this.maxLiftTime = 30 + this.field_70146_Z.nextInt(30);
        }
    }

    public boolean hasLiftedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(LIFT_ENTITY) != 0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LIFT_ENTITY, (Object)0);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76352_a()) {
            amount = (amount + 1.0f) / 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    private void spit(LivingEntity target) {
        EntitySandShot sghot = new EntitySandShot(this.field_70170_p, this);
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_226283_e_(0.3333333333333333) - sghot.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.35f;
        sghot.shoot(d0, d1 + (double)f, d2, 1.0f, 10.0f);
        sghot.setVariant(this.getVariant());
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187747_eB, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
        this.field_70170_p.func_217376_c((Entity)sghot);
    }

    public double func_226280_cw_() {
        return this.func_226278_cu_() + 1.0;
    }

    @Nullable
    public Entity getLiftedEntity() {
        if (!this.hasLiftedEntity()) {
            return null;
        }
        return this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(LIFT_ENTITY)).intValue());
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (EntityGuster.isBiomeNether((IWorld)worldIn, this.func_233580_cy_())) {
            this.setVariant(2);
        } else if (EntityGuster.isBiomeRed((IWorld)worldIn, this.func_233580_cy_())) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        this.func_70050_g(this.func_205010_bg());
        this.field_70125_A = 0.0f;
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private void setLiftedEntity(int p_175463_1_) {
        this.field_70180_af.func_187227_b(LIFT_ENTITY, (Object)p_175463_1_);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public void func_70636_d() {
        super.func_70636_d();
        Entity lifted = this.getLiftedEntity();
        if (lifted == null && !this.field_70170_p.field_72995_K && this.field_70173_aa % 15 == 0) {
            List list = this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_186662_g((double)0.8f));
            ItemEntity closestItem = null;
            for (int i = 0; i < list.size(); ++i) {
                ItemEntity entity = (ItemEntity)list.get(i);
                if (!entity.func_233570_aj_() || closestItem != null && !(this.func_70032_d((Entity)closestItem) > this.func_70032_d((Entity)entity))) continue;
                closestItem = entity;
            }
            if (closestItem != null) {
                this.setLiftedEntity(closestItem.func_145782_y());
                this.maxLiftTime = 30 + this.field_70146_Z.nextInt(30);
            }
        }
        if (this.func_203005_aq()) {
            this.func_70097_a(DamageSource.field_76369_e, 0.5f);
        }
        float f = (float)this.func_226278_cu_();
        if (this.func_70089_S()) {
            BasicParticleType type = this.getVariant() == 2 ? AMParticleRegistry.GUSTER_SAND_SPIN_SOUL : (this.getVariant() == 1 ? AMParticleRegistry.GUSTER_SAND_SPIN_RED : AMParticleRegistry.GUSTER_SAND_SPIN);
            for (int j = 0; j < 4; ++j) {
                float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.95f;
                float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.95f;
                this.field_70170_p.func_195594_a((IParticleData)type, this.func_226277_ct_() + (double)f1, (double)f, this.func_226281_cx_() + (double)f2, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()) + (double)0.2f, this.func_226281_cx_());
            }
        }
        if (lifted != null && this.liftingTime >= 0) {
            ++this.liftingTime;
            float resist = 1.0f;
            if (lifted instanceof LivingEntity) {
                resist = (float)MathHelper.func_151237_a((double)(1.0 - ((LivingEntity)lifted).func_233637_b_(Attributes.field_233820_c_)), (double)0.0, (double)1.0);
            }
            float radius = 1.0f + (float)this.liftingTime * 0.05f;
            if (lifted instanceof ItemEntity) {
                radius = 0.2f + (float)this.liftingTime * 0.025f;
            }
            float angle = (float)this.liftingTime * -0.25f;
            double extraX = this.func_226277_ct_() + (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle))));
            double extraZ = this.func_226281_cx_() + (double)(radius * MathHelper.func_76134_b((float)angle));
            double d0 = (extraX - lifted.func_226277_ct_()) * (double)resist;
            double d1 = (extraZ - lifted.func_226281_cx_()) * (double)resist;
            lifted.func_213293_j(d0, 0.1 * (double)resist, d1);
            lifted.field_70160_al = true;
            if (this.liftingTime > this.maxLiftTime) {
                this.setLiftedEntity(0);
                this.liftingTime = -20;
                this.maxLiftTime = 30 + this.field_70146_Z.nextInt(30);
            }
        } else if (this.liftingTime < 0) {
            ++this.liftingTime;
        } else if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < this.func_213311_cf() + 1.0f && !(this.func_70638_az() instanceof EntityGuster)) {
            this.setLiftedEntity(this.func_70638_az().func_145782_y());
            this.maxLiftTime = 30 + this.field_70146_Z.nextInt(30);
        }
        if (!this.field_70170_p.field_72995_K && this.shootingTicks >= 0) {
            if (this.shootingTicks <= 0) {
                if (this.func_70638_az() != null && (lifted == null || lifted.func_145782_y() != this.func_70638_az().func_145782_y()) && this.func_70089_S()) {
                    this.spit(this.func_70638_az());
                }
                this.shootingTicks = 40 + this.field_70146_Z.nextInt(40);
            } else {
                --this.shootingTicks;
            }
        }
        Vector3d vector3d = this.func_213322_ci();
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.6, 1.0));
        }
    }

    public boolean isGooglyEyes() {
        String s = TextFormatting.func_110646_a((String)this.func_200200_C_().getString());
        return s != null && s.toLowerCase().contains("tweester");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    private static boolean isBiomeRed(IWorld worldIn, BlockPos position) {
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)worldIn.func_226691_t_(position).getRegistryName());
        return BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.MESA);
    }

    private static boolean isBiomeNether(IWorld worldIn, BlockPos position) {
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)worldIn.func_226691_t_(position).getRegistryName());
        return BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
    }

    public static int getColorForVariant(int variant) {
        if (variant == 2) {
            return 5127475;
        }
        if (variant == 1) {
            return 13000999;
        }
        return 15975305;
    }

    private class MeleeGoal
    extends Goal {
        public boolean func_75250_a() {
            return EntityGuster.this.func_70638_az() != null;
        }

        public void func_75246_d() {
            Entity thrownEntity = EntityGuster.this.getLiftedEntity();
            if (EntityGuster.this.func_70638_az() != null) {
                if (thrownEntity != null && thrownEntity.func_145782_y() == EntityGuster.this.func_70638_az().func_145782_y()) {
                    EntityGuster.this.func_70661_as().func_75499_g();
                } else {
                    EntityGuster.this.func_70661_as().func_75497_a((Entity)EntityGuster.this.func_70638_az(), 1.25);
                }
            }
        }
    }
}

