/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.vector.Vector2f;

public class TugRouteNode {
    private static final String NAME_TAG = "name";
    private static final String X_TAG = "x";
    private static final String Z_TAG = "z";
    private static final String COORDS_TAG = "coordinates";
    private String name;
    private final double x;
    private final double z;

    public TugRouteNode(String name, double x, double z) {
        this.name = name;
        this.x = x;
        this.z = z;
    }

    public TugRouteNode(double x, double y) {
        this(null, x, y);
    }

    public String getDisplayName(int index) {
        if (!this.hasCustomName()) {
            return I18n.func_135052_a((String)"item.littlelogistics.tug_route.node", (Object[])new Object[]{index});
        }
        return I18n.func_135052_a((String)"item.littlelogistics.tug_route.node_named", (Object[])new Object[]{index, this.getName()});
    }

    public String getDisplayCoords() {
        return this.x + ", " + this.z;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean hasCustomName() {
        return this.name != null;
    }

    public double getX() {
        return this.x;
    }

    public double getZ() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TugRouteNode that = (TugRouteNode)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.z, this.z) == 0 && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.x, this.z);
    }

    public CompoundNBT toNBT() {
        CompoundNBT tag = new CompoundNBT();
        if (this.hasCustomName()) {
            tag.func_74778_a(NAME_TAG, this.getName());
        }
        CompoundNBT coords = new CompoundNBT();
        coords.func_74780_a(X_TAG, this.x);
        coords.func_74780_a(Z_TAG, this.z);
        tag.func_218657_a(COORDS_TAG, (INBT)coords);
        return tag;
    }

    public static TugRouteNode fromNBT(CompoundNBT tag) {
        String name = null;
        if (tag.func_74764_b(NAME_TAG)) {
            name = tag.func_74779_i(NAME_TAG);
        }
        CompoundNBT coords = tag.func_74775_l(COORDS_TAG);
        double x = coords.func_74769_h(X_TAG);
        double z = coords.func_74769_h(Z_TAG);
        return new TugRouteNode(name, x, z);
    }

    public static TugRouteNode fromVector2f(Vector2f node) {
        double x = node.field_189982_i;
        double z = node.field_189983_j;
        return new TugRouteNode(null, x, z);
    }
}

