/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import dev.murad.shipping.util.TugRouteNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class TugRoute
extends ArrayList<TugRouteNode> {
    private static final String NAME_TAG = "name";
    private static final String NODES_TAG = "nodes";
    private static final String HASH_TAG = "hash";
    private String name;

    public TugRoute(String name, List<TugRouteNode> nodes) {
        super(nodes);
        this.name = name;
    }

    public TugRoute(List<TugRouteNode> nodes) {
        this(null, nodes);
    }

    public TugRoute() {
        this(null, new ArrayList<TugRouteNode>());
    }

    public boolean hasCustomName() {
        return this.name != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TugRoute that = (TugRoute)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }

    public CompoundNBT toNBT() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (TugRouteNode node : this) {
            list.add((Object)node.toNBT());
        }
        tag.func_218657_a(NODES_TAG, (INBT)list);
        if (this.hasCustomName()) {
            tag.func_74778_a(NAME_TAG, this.name);
        }
        return tag;
    }

    public static TugRoute fromNBT(CompoundNBT tag) {
        String name = null;
        if (tag.func_74764_b(NAME_TAG)) {
            name = tag.func_74779_i(NAME_TAG);
        }
        ListNBT nodesNBT = tag.func_150295_c(NODES_TAG, 10);
        ArrayList<TugRouteNode> nodes = new ArrayList<TugRouteNode>();
        for (int i = 0; i < nodesNBT.size(); ++i) {
            nodes.add(TugRouteNode.fromNBT(nodesNBT.func_150305_b(i)));
        }
        return new TugRoute(name, nodes);
    }
}

