/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class FluidRenderUtil {
    private static void addQuadVertex(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder renderBuffer, Vector3f pos, Vector2f texUV, Vector3f normalVector, int color, int lightmapValue) {
        float a = 1.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        renderBuffer.func_227888_a_(matrixPos, pos.func_195899_a(), pos.func_195900_b(), pos.func_195902_c()).func_227885_a_(r, g, b, a).func_225583_a_(texUV.field_189982_i, texUV.field_189983_j).func_227891_b_(OverlayTexture.field_229196_a_).func_225587_b_(0, 240).func_227887_a_(matrixNormal, normalVector.func_195899_a(), normalVector.func_195900_b(), normalVector.func_195902_c()).func_181675_d();
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder renderBuffer, Vector3f blpos, Vector3f brpos, Vector3f trpos, Vector3f tlpos, Vector2f blUVpos, Vector2f brUVpos, Vector2f trUVpos, Vector2f tlUVpos, Vector3f normalVector, int color, int lightmapValue) {
        FluidRenderUtil.addQuadVertex(matrixPos, matrixNormal, renderBuffer, blpos, blUVpos, normalVector, color, lightmapValue);
        FluidRenderUtil.addQuadVertex(matrixPos, matrixNormal, renderBuffer, brpos, brUVpos, normalVector, color, lightmapValue);
        FluidRenderUtil.addQuadVertex(matrixPos, matrixNormal, renderBuffer, trpos, trUVpos, normalVector, color, lightmapValue);
        FluidRenderUtil.addQuadVertex(matrixPos, matrixNormal, renderBuffer, tlpos, tlUVpos, normalVector, color, lightmapValue);
    }

    private static void addFace(Direction whichFace, Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder renderBuffer, int color, Vector3d centrePos, float width, float height, Vector2f bottomLeftUV, float texUwidth, float texVheight, int lightmapValue) {
        Vector3f bottomToTopDirection;
        Vector3f leftToRightDirection;
        switch (whichFace) {
            case NORTH: {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case SOUTH: {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case EAST: {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, -1.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case WEST: {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
                break;
            }
            case UP: {
                leftToRightDirection = new Vector3f(-1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                break;
            }
            case DOWN: {
                leftToRightDirection = new Vector3f(1.0f, 0.0f, 0.0f);
                bottomToTopDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                break;
            }
            default: {
                leftToRightDirection = new Vector3f(0.0f, 0.0f, 1.0f);
                bottomToTopDirection = new Vector3f(0.0f, 1.0f, 0.0f);
            }
        }
        leftToRightDirection.func_195898_a(0.5f * width);
        bottomToTopDirection.func_195898_a(0.5f * height);
        Vector3f bottomLeftPos = new Vector3f(centrePos);
        bottomLeftPos.func_195897_a(leftToRightDirection);
        bottomLeftPos.func_195897_a(bottomToTopDirection);
        Vector3f bottomRightPos = new Vector3f(centrePos);
        bottomRightPos.func_229189_a_(leftToRightDirection);
        bottomRightPos.func_195897_a(bottomToTopDirection);
        Vector3f topRightPos = new Vector3f(centrePos);
        topRightPos.func_229189_a_(leftToRightDirection);
        topRightPos.func_229189_a_(bottomToTopDirection);
        Vector3f topLeftPos = new Vector3f(centrePos);
        topLeftPos.func_195897_a(leftToRightDirection);
        topLeftPos.func_229189_a_(bottomToTopDirection);
        Vector2f bottomLeftUVpos = new Vector2f(bottomLeftUV.field_189982_i, bottomLeftUV.field_189983_j);
        Vector2f bottomRightUVpos = new Vector2f(bottomLeftUV.field_189982_i + texUwidth, bottomLeftUV.field_189983_j);
        Vector2f topLeftUVpos = new Vector2f(bottomLeftUV.field_189982_i + texUwidth, bottomLeftUV.field_189983_j + texVheight);
        Vector2f topRightUVpos = new Vector2f(bottomLeftUV.field_189982_i, bottomLeftUV.field_189983_j + texVheight);
        Vector3f normalVector = whichFace.func_229386_k_();
        FluidRenderUtil.addQuad(matrixPos, matrixNormal, renderBuffer, bottomLeftPos, bottomRightPos, topRightPos, topLeftPos, bottomLeftUVpos, bottomRightUVpos, topLeftUVpos, topRightUVpos, normalVector, color, lightmapValue);
    }

    public static void renderCubeUsingQuads(int capacity, FluidStack fluid, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderBuffers, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        FluidRenderUtil.drawCubeQuads(matrixStack, renderBuffers, combinedLight, fluid, capacity);
        matrixStack.func_227865_b_();
    }

    private static void drawCubeQuads(MatrixStack matrixStack, IRenderTypeBuffer renderBuffer, int combinedLight, FluidStack fluid, int capacity) {
        FluidAttributes attributes = fluid.getFluid().getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(fluid);
        if (fluidStill == null) {
            return;
        }
        IVertexBuilder vertexBuilderBlockQuads = renderBuffer.getBuffer(RenderType.func_228645_f_());
        int color = attributes.getColor();
        Matrix4f matrixPos = matrixStack.func_227866_c_().func_227870_a_();
        Matrix3f matrixNormal = matrixStack.func_227866_c_().func_227872_b_();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
        Vector2f bottomLeftUV = new Vector2f(sprite.func_94209_e(), sprite.func_94206_g());
        float UVwidth = sprite.func_94212_f() - sprite.func_94209_e();
        float UVheight = sprite.func_94210_h() - sprite.func_94206_g();
        float WIDTH = 1.0f;
        float HEIGHT = 1.0f;
        float scale = -0.5f * (float)fluid.getAmount() / (float)capacity;
        if (scale <= 0.0f) {
            matrixStack.func_227862_a_(0.5f, Math.abs(scale) + 0.21f, 0.5f);
        }
        Vector3d EAST_FACE_MIDPOINT = new Vector3d(1.0, 0.5, 0.5);
        Vector3d WEST_FACE_MIDPOINT = new Vector3d(0.0, 0.5, 0.5);
        Vector3d NORTH_FACE_MIDPOINT = new Vector3d(0.5, 0.5, 0.0);
        Vector3d SOUTH_FACE_MIDPOINT = new Vector3d(0.5, 0.5, 1.0);
        Vector3d UP_FACE_MIDPOINT = new Vector3d(0.5, 1.0, 0.5);
        Vector3d DOWN_FACE_MIDPOINT = new Vector3d(0.5, 0.0, 0.5);
        FluidRenderUtil.addFace(Direction.EAST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, EAST_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.WEST, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, WEST_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.NORTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, NORTH_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.SOUTH, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, SOUTH_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.UP, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, UP_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
        FluidRenderUtil.addFace(Direction.DOWN, matrixPos, matrixNormal, vertexBuilderBlockQuads, color, DOWN_FACE_MIDPOINT, 1.0f, 1.0f, bottomLeftUV, UVwidth, UVheight, combinedLight);
    }
}

