/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.recipe;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.setup.ModRecipeSerializers;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TugRouteRecipe
extends SpecialRecipe {
    private static final Logger LOGGER = LogManager.getLogger(TugRouteRecipe.class);

    public TugRouteRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    private boolean isTugRouteWithTag(ItemStack stack, boolean hasTag) {
        if (stack.func_77973_b() == ModItems.TUG_ROUTE.get()) {
            return stack.func_77978_p() == null ^ hasTag;
        }
        return false;
    }

    private Optional<Pair<ItemStack, Integer>> checkTugRoutes(CraftingInventory inventory) {
        int i = 0;
        ItemStack filledRoute = ItemStack.field_190927_a;
        for (int j = 0; j < inventory.func_70302_i_(); ++j) {
            ItemStack stack = inventory.func_70301_a(j);
            if (stack.func_190926_b()) continue;
            if (this.isTugRouteWithTag(stack, true)) {
                if (!filledRoute.func_190926_b()) {
                    return Optional.empty();
                }
                filledRoute = stack;
                continue;
            }
            if (!this.isTugRouteWithTag(stack, false)) {
                return Optional.empty();
            }
            ++i;
        }
        if (!filledRoute.func_190926_b() && i >= 1 && i <= filledRoute.func_77976_d() - 1) {
            return Optional.of(new Pair((Object)filledRoute, (Object)i));
        }
        return Optional.empty();
    }

    public boolean matches(@Nonnull CraftingInventory inventory, @Nonnull World level) {
        return this.checkTugRoutes(inventory).isPresent();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInventory inventory) {
        Optional<Pair<ItemStack, Integer>> matchOpt = this.checkTugRoutes(inventory);
        if (!matchOpt.isPresent()) {
            return ItemStack.field_190927_a;
        }
        Pair<ItemStack, Integer> match = matchOpt.get();
        ItemStack filled = (ItemStack)match.getFirst();
        int num = (Integer)match.getSecond();
        ItemStack output = filled.func_77946_l();
        output.func_190920_e(num + 1);
        return output;
    }

    public boolean func_194133_a(int x, int y) {
        return x * y >= 2;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.TUG_ROUTE_COPY.get();
    }
}

