/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.network;

import dev.murad.shipping.item.TugRouteItem;
import dev.murad.shipping.network.SetTag;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.TugRoute;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TugRoutePacketHandler {
    private static final Logger LOGGER = LogManager.getLogger(TugRoutePacketHandler.class);
    public static final ResourceLocation LOCATION = new ResourceLocation("littlelogistics", "tug_route_channel");
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)LOCATION, () -> "1", "1"::equals, "1"::equals);
    private static int id = 0;

    public static void register() {
        INSTANCE.registerMessage(id++, SetTag.class, SetTag::encode, SetTag::new, TugRoutePacketHandler::handleSetTag);
    }

    public static void handleSetTag(SetTag operation, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                LOGGER.error("Received packet not from player, dropping packet");
                return;
            }
            ItemStack heldStack = player.func_184586_b(operation.isOffhand ? Hand.OFF_HAND : Hand.MAIN_HAND);
            LOGGER.info("Item in hand is {}", (Object)heldStack);
            if (heldStack.func_77973_b() != ModItems.TUG_ROUTE.get()) {
                LOGGER.error("Item held in hand was not tug_route item, perhaps client has de-synced? Dropping packet");
                return;
            }
            CompoundNBT routeTag = operation.tag;
            LOGGER.info((Object)routeTag);
            TugRouteItem.saveRoute(TugRoute.fromNBT(routeTag), heldStack);
        });
        ctx.get().setPacketHandled(true);
    }
}

