/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.item;

import dev.murad.shipping.entity.accessor.TugRouteScreenDataAccessor;
import dev.murad.shipping.item.container.TugRouteContainer;
import dev.murad.shipping.util.LegacyTugRouteUtil;
import dev.murad.shipping.util.TugRoute;
import dev.murad.shipping.util.TugRouteNode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TugRouteItem
extends Item {
    private static final Logger LOGGER = LogManager.getLogger(TugRouteItem.class);
    private static final String ROUTE_NBT = "route";

    public TugRouteItem(Item.Properties properties) {
        super(properties);
    }

    protected INamedContainerProvider createContainerProvider(final Hand hand) {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("screen.littlelogistics.tug_route");
            }

            @Nullable
            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new TugRouteContainer(i, playerEntity.field_70170_p, TugRouteItem.this.getDataAccessor(playerEntity, hand), playerInventory, playerEntity);
            }
        };
    }

    public TugRouteScreenDataAccessor getDataAccessor(PlayerEntity entity, Hand hand) {
        return new TugRouteScreenDataAccessor.Builder(entity.func_145782_y()).withOffHand(hand == Hand.OFF_HAND).build();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K) {
            if (player.func_225608_bj_()) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.createContainerProvider(hand), this.getDataAccessor(player, hand)::write);
            } else {
                int z;
                int x = (int)Math.floor(player.func_226277_ct_());
                if (!TugRouteItem.tryRemoveSpecific(itemstack, x, z = (int)Math.floor(player.func_226281_cx_()))) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("item.littlelogistics.tug_route.added", new Object[]{x, z}), false);
                    TugRouteItem.pushRoute(itemstack, x, z);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("item.littlelogistics.tug_route.removed", new Object[]{x, z}), false);
                }
            }
        }
        return ActionResult.func_226250_c_((Object)itemstack);
    }

    public boolean func_179215_a(@Nonnull CompoundNBT nbt) {
        super.func_179215_a(nbt);
        CompoundNBT tag = nbt.func_74775_l("tag");
        if (tag.func_150297_b(ROUTE_NBT, 8)) {
            LOGGER.info("Found legacy tug route tag, replacing now");
            String routeString = tag.func_74779_i(ROUTE_NBT);
            List<Vector2f> legacyRoute = LegacyTugRouteUtil.parseLegacyRouteString(routeString);
            TugRoute route = LegacyTugRouteUtil.convertLegacyRoute(legacyRoute);
            tag.func_218657_a(ROUTE_NBT, (INBT)route.toNBT());
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.littlelogistics.tug_route.description"));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.littlelogistics.tug_route.num_nodes", new Object[]{TugRouteItem.getRoute(stack).size()}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)));
    }

    public static TugRoute getRoute(ItemStack itemStack) {
        CompoundNBT nbt = TugRouteItem.getTag(itemStack);
        if (nbt == null || !nbt.func_150297_b(ROUTE_NBT, 10)) {
            return new TugRoute();
        }
        return TugRoute.fromNBT(nbt.func_74775_l(ROUTE_NBT));
    }

    public static boolean popRoute(ItemStack itemStack) {
        TugRoute route = TugRouteItem.getRoute(itemStack);
        if (route.size() == 0) {
            return false;
        }
        route.remove(route.size() - 1);
        TugRouteItem.saveRoute(route, itemStack);
        return true;
    }

    public static boolean tryRemoveSpecific(ItemStack itemStack, int x, int z) {
        TugRoute route = TugRouteItem.getRoute(itemStack);
        if (route.size() == 0) {
            return false;
        }
        boolean removed = route.removeIf(v -> v.getX() == (double)x && v.getZ() == (double)z);
        TugRouteItem.saveRoute(route, itemStack);
        return removed;
    }

    public static void pushRoute(ItemStack itemStack, int x, int y) {
        TugRoute route = TugRouteItem.getRoute(itemStack);
        route.add(new TugRouteNode(x, y));
        TugRouteItem.saveRoute(route, itemStack);
    }

    public static void saveRoute(TugRoute route, ItemStack itemStack) {
        CompoundNBT nbt = TugRouteItem.getTag(itemStack);
        if (nbt == null) {
            nbt = new CompoundNBT();
            itemStack.func_77982_d(nbt);
        }
        nbt.func_218657_a(ROUTE_NBT, (INBT)route.toNBT());
    }

    @Nullable
    private static CompoundNBT getTag(ItemStack stack) {
        return stack.func_77978_p();
    }
}

