/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.navigation;

import dev.murad.shipping.block.guide_rail.TugGuideRailBlock;
import dev.murad.shipping.setup.ModBlocks;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.pathfinding.FlaggedPathPoint;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.SwimNodeProcessor;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;

public class TugNodeProcessor
extends SwimNodeProcessor {
    public TugNodeProcessor() {
        super(false);
    }

    private boolean isOppositeGuideRail(PathPoint pathPoint, Direction direction) {
        BlockState state = this.field_176169_a.func_180495_p(pathPoint.func_224759_a().func_177977_b());
        if (state.func_203425_a((Block)ModBlocks.GUIDE_RAIL_TUG.get())) {
            return TugGuideRailBlock.getArrowsDirection(state).func_176734_d().equals((Object)direction);
        }
        return false;
    }

    public int func_222859_a(PathPoint[] p_222859_1_, PathPoint p_222859_2_) {
        int i = 0;
        for (Direction direction : Arrays.asList(Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.NORTH)) {
            PathPoint pathpoint = this.getWaterNode(p_222859_2_.field_75839_a + direction.func_82601_c(), p_222859_2_.field_75837_b + direction.func_96559_d(), p_222859_2_.field_75838_c + direction.func_82599_e());
            if (pathpoint == null || pathpoint.field_75842_i || this.isOppositeGuideRail(pathpoint, direction)) continue;
            p_222859_1_[i++] = pathpoint;
        }
        return i;
    }

    private PathPoint getNodeSimple(int p_176159_1_, int p_176159_2_, int p_176159_3_) {
        return (PathPoint)this.field_176167_b.computeIfAbsent(PathPoint.func_75830_a((int)p_176159_1_, (int)p_176159_2_, (int)p_176159_3_), p_215743_3_ -> new PathPoint(p_176159_1_, p_176159_2_, p_176159_3_));
    }

    public FlaggedPathPoint func_224768_a(double p_224768_1_, double p_224768_3_, double p_224768_5_) {
        return new FlaggedPathPoint(this.getNodeSimple(MathHelper.func_76128_c((double)p_224768_1_), MathHelper.func_76128_c((double)p_224768_3_), MathHelper.func_76128_c((double)p_224768_5_)));
    }

    protected PathPoint func_176159_a(int p_176159_1_, int p_176159_2_, int p_176159_3_) {
        PathPoint pathpoint = super.func_176159_a(p_176159_1_, p_176159_2_, p_176159_3_);
        if (pathpoint != null) {
            BlockPos pos = pathpoint.func_224759_a();
            float penalty = 0.0f;
            for (BlockPos surr : Arrays.asList(pos.func_177974_f(), pos.func_177976_e(), pos.func_177968_d(), pos.func_177978_c(), pos.func_177978_c().func_177976_e(), pos.func_177978_c().func_177974_f(), pos.func_177968_d().func_177974_f(), pos.func_177968_d().func_177976_e(), pos.func_177978_c().func_177976_e().func_177978_c().func_177976_e(), pos.func_177978_c().func_177974_f().func_177978_c().func_177974_f(), pos.func_177968_d().func_177976_e().func_177968_d().func_177976_e(), pos.func_177968_d().func_177974_f().func_177968_d().func_177974_f())) {
                if (!this.field_176169_a.func_180495_p(surr).func_203425_a(Blocks.field_150355_j)) {
                    penalty = 5.0f;
                }
                if (!this.field_176169_a.func_180495_p(surr).func_203425_a((Block)ModBlocks.GUIDE_RAIL_CORNER.get()) && !this.field_176169_a.func_180495_p(surr).func_203425_a((Block)ModBlocks.BARGE_DOCK.get()) && !this.field_176169_a.func_180495_p(surr).func_203425_a((Block)ModBlocks.TUG_DOCK.get())) continue;
                penalty = 0.0f;
                break;
            }
            pathpoint.field_186286_l += penalty;
        }
        return pathpoint;
    }

    private PathPoint getWaterNode(int p_186328_1_, int p_186328_2_, int p_186328_3_) {
        PathNodeType pathnodetype = this.isFree(p_186328_1_, p_186328_2_, p_186328_3_);
        return pathnodetype != PathNodeType.WATER ? null : this.func_176159_a(p_186328_1_, p_186328_2_, p_186328_3_);
    }

    private PathNodeType isFree(int p_186327_1_, int p_186327_2_, int p_186327_3_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = p_186327_1_; i < p_186327_1_ + this.field_176168_c; ++i) {
            for (int j = p_186327_2_; j < p_186327_2_ + this.field_176165_d; ++j) {
                for (int k = p_186327_3_; k < p_186327_3_ + this.field_176166_e; ++k) {
                    FluidState fluidstate = this.field_176169_a.func_204610_c((BlockPos)blockpos$mutable.func_181079_c(i, j, k));
                    BlockState blockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(i, j, k));
                    if (fluidstate.func_206888_e() && blockstate.func_196957_g((IBlockReader)this.field_176169_a, blockpos$mutable.func_177977_b(), PathType.WATER) && blockstate.func_196958_f()) {
                        return PathNodeType.BREACH;
                    }
                    if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    return PathNodeType.BLOCKED;
                }
            }
        }
        BlockState blockstate1 = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutable);
        return blockstate1.func_196957_g((IBlockReader)this.field_176169_a, (BlockPos)blockpos$mutable, PathType.WATER) ? PathNodeType.WATER : PathNodeType.BLOCKED;
    }
}

