/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.barge;

import dev.murad.shipping.entity.custom.barge.AbstractBargeEntity;
import dev.murad.shipping.entity.custom.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidTankBargeEntity
extends AbstractBargeEntity {
    public static int CAPACITY = 10000;
    protected FluidTank tank = new FluidTank(CAPACITY){

        protected void onContentsChanged() {
            FluidTankBargeEntity.this.sendInfoToClient();
        }
    };
    private static final DataParameter<Integer> VOLUME = EntityDataManager.func_187226_a(AbstractTugEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> FLUID_TYPE = EntityDataManager.func_187226_a(AbstractTugEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private Fluid clientCurrFluid = Fluids.field_204541_a;
    private int clientCurrAmount = 0;
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public FluidTankBargeEntity(EntityType<? extends AbstractBargeEntity> type, World world) {
        super(type, world);
    }

    public FluidTankBargeEntity(World worldIn, double x, double y, double z) {
        super((EntityType<? extends AbstractBargeEntity>)((EntityType)ModEntityTypes.FLUID_TANK_BARGE.get()), worldIn, x, y, z);
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.FLUID_BARGE.get();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLUID_TYPE, (Object)"minecraft:empty");
        this.field_70180_af.func_187214_a(VOLUME, (Object)0);
    }

    private TranslationTextComponent getFluidDisplay() {
        Fluid fluid = this.tank.getFluid().getFluid();
        return fluid.equals(Fluids.field_204541_a) ? new TranslationTextComponent("entity.littlelogistics.fluid_barge.capacity_empty", new Object[]{this.tank.getCapacity()}) : new TranslationTextComponent("entity.littlelogistics.fluid_barge.capacity", new Object[]{this.tank.getFluid().getDisplayName().getString(), this.tank.getFluidAmount(), this.tank.getCapacity()});
    }

    @Override
    protected void doInteract(PlayerEntity player) {
        FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)Hand.MAIN_HAND, (IFluidHandler)this.tank);
        player.func_146105_b((ITextComponent)this.getFluidDisplay(), false);
    }

    public FluidStack getFluidStack() {
        return this.tank.getFluid();
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.tank.readFromNBT(tag);
        this.sendInfoToClient();
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        this.tank.writeToNBT(tag);
    }

    private void sendInfoToClient() {
        this.field_70180_af.func_187227_b(VOLUME, (Object)this.tank.getFluidAmount());
        this.field_70180_af.func_187227_b(FLUID_TYPE, (Object)this.tank.getFluid().getFluid().getRegistryName().toString());
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.field_70170_p.field_72995_K) {
            if (VOLUME.equals(key)) {
                this.clientCurrAmount = (Integer)this.field_70180_af.func_187225_a(VOLUME);
                this.tank.setFluid(new FluidStack(this.clientCurrFluid, this.clientCurrAmount));
            } else if (FLUID_TYPE.equals(key)) {
                ResourceLocation fluidName = new ResourceLocation((String)this.field_70180_af.func_187225_a(FLUID_TYPE));
                this.clientCurrFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
                this.tank.setFluid(new FluidStack(this.clientCurrFluid, this.clientCurrAmount));
            }
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }
}

