/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.barge;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.container.FishingBargeContainer;
import dev.murad.shipping.entity.custom.ISpringableEntity;
import dev.murad.shipping.entity.custom.barge.AbstractBargeEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.InventoryUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class FishingBargeEntity
extends AbstractBargeEntity
implements IInventory,
ISidedInventory {
    protected final ItemStackHandler itemHandler = this.createHandler();
    protected final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    protected boolean contentsChanged = false;
    private int ticksDeployable = 0;
    private int fishCooldown = 0;
    private final Set<Pair<Integer, Integer>> overFishedCoords = new HashSet<Pair<Integer, Integer>>();
    private final Queue<Pair<Integer, Integer>> overFishedQueue = new LinkedList<Pair<Integer, Integer>>();
    private static final ResourceLocation fishingLootTable = new ResourceLocation((String)ShippingConfig.Server.FISHING_LOOT_TABLE.get());

    public FishingBargeEntity(EntityType<? extends FishingBargeEntity> type, World world) {
        super((EntityType<? extends AbstractBargeEntity>)type, world);
    }

    public FishingBargeEntity(World worldIn, double x, double y, double z) {
        super((EntityType<? extends AbstractBargeEntity>)((EntityType)ModEntityTypes.FISHING_BARGE.get()), worldIn, x, y, z);
    }

    @Override
    protected void doInteract(PlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.createContainerProvider(), buffer -> buffer.writeInt(this.func_145782_y()));
    }

    protected INamedContainerProvider createContainerProvider() {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("screen.littlelogistics.fishing_barge");
            }

            @Nullable
            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new FishingBargeContainer(i, FishingBargeEntity.this.field_70170_p, FishingBargeEntity.this.func_145782_y(), playerInventory, playerEntity);
            }
        };
    }

    @Override
    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this);
        }
        super.func_70106_y();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(27);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.tickWaterOnSidesCheck();
        if (!this.field_70170_p.field_72995_K && this.getStatus() == Status.DEPLOYED) {
            if (this.fishCooldown < 0) {
                this.tickFish();
                this.fishCooldown = 20;
            } else {
                --this.fishCooldown;
            }
        }
    }

    private void tickWaterOnSidesCheck() {
        this.ticksDeployable = this.hasWaterOnSides() ? ++this.ticksDeployable : 0;
    }

    private double computeDepthPenalty() {
        int count = 0;
        BlockPos pos = this.func_226268_ag_();
        while (this.field_70170_p.func_180495_p(pos).func_177230_c().equals(Blocks.field_150355_j)) {
            ++count;
            pos = pos.func_177977_b();
        }
        count = Math.min(count, 20);
        return (double)count / 20.0;
    }

    private void tickFish() {
        double overFishPenalty = this.isOverFished() ? 0.05 : 1.0;
        double shallowPenalty = this.computeDepthPenalty();
        double chance = 0.25 * overFishPenalty * shallowPenalty;
        double treasure_chance = shallowPenalty > 0.4 ? chance * (shallowPenalty / 2.0) * (Double)ShippingConfig.Server.FISHING_TREASURE_CHANCE_MODIFIER.get() : 0.0;
        double r = Math.random();
        if (r < chance) {
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.func_213303_ch()).func_216015_a(LootParameters.field_216281_a, (Object)this).func_216015_a(LootParameters.field_216289_i, (Object)new ItemStack((IItemProvider)Items.field_151112_aM)).func_216023_a(this.field_70146_Z);
            lootcontext$builder.func_216015_a(LootParameters.field_216284_d, (Object)this).func_216015_a(LootParameters.field_216281_a, (Object)this);
            LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(r < treasure_chance ? LootTables.field_186389_an : fishingLootTable);
            List list = loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216262_c));
            for (ItemStack stack : list) {
                int slot = InventoryUtils.findSlotFotItem(this, stack);
                if (slot != -1) {
                    this.itemHandler.insertItem(slot, stack, false);
                }
                if (this.isOverFished()) continue;
                this.addOverFish();
            }
        }
    }

    private String overFishedString() {
        return this.overFishedQueue.stream().map(t -> t.getFirst() + ":" + t.getSecond()).reduce("", (acc, curr) -> String.join((CharSequence)",", acc, curr));
    }

    private void populateOverfish(String string) {
        Arrays.stream(string.split(",")).filter(s -> !s.isEmpty()).map(s -> s.split(":")).map(arr -> new Pair((Object)Integer.parseInt(arr[0]), (Object)Integer.parseInt(arr[1]))).forEach(this.overFishedQueue::add);
        this.overFishedCoords.addAll(this.overFishedQueue);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        CompoundNBT inv = compound.func_74775_l("inv");
        inv.func_82580_o("Size");
        this.itemHandler.deserializeNBT(inv);
        this.populateOverfish(compound.func_74779_i("overfish"));
        super.func_70037_a(compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("inv", (INBT)this.itemHandler.serializeNBT());
        compound.func_74778_a("overfish", this.overFishedString());
        super.func_213281_b(compound);
    }

    private void addOverFish() {
        int x = (int)Math.floor(this.func_226277_ct_());
        int z = (int)Math.floor(this.func_226281_cx_());
        this.overFishedCoords.add((Pair<Integer, Integer>)new Pair((Object)x, (Object)z));
        this.overFishedQueue.add((Pair<Integer, Integer>)new Pair((Object)x, (Object)z));
        if (this.overFishedQueue.size() > 30) {
            this.overFishedCoords.remove(this.overFishedQueue.poll());
        }
    }

    private boolean isOverFished() {
        int x = (int)Math.floor(this.func_226277_ct_());
        int z = (int)Math.floor(this.func_226281_cx_());
        return this.overFishedCoords.contains(new Pair((Object)x, (Object)z));
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.FISHING_BARGE.get();
    }

    public int[] func_180463_a(Direction p_180463_1_) {
        return IntStream.range(0, this.func_70302_i_()).toArray();
    }

    public boolean func_180462_a(int p_180462_1_, ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return false;
    }

    public boolean func_180461_b(int p_180461_1_, ItemStack p_180461_2_, Direction p_180461_3_) {
        return this.isDockable();
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    public int func_70302_i_() {
        return 27;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).func_190926_b() || this.itemHandler.getStackInSlot(i).func_77973_b().equals(Items.field_190931_a)) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return this.itemHandler.getStackInSlot(p_70301_1_);
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return this.itemHandler.extractItem(p_70298_1_, p_70298_2_, false);
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        ItemStack itemstack = this.itemHandler.getStackInSlot(p_70304_1_);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.itemHandler.setStackInSlot(p_70304_1_, ItemStack.field_190927_a);
        return itemstack;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.itemHandler.setStackInSlot(p_70299_1_, p_70299_2_);
    }

    public void func_70296_d() {
        this.contentsChanged = true;
    }

    public boolean func_70300_a(PlayerEntity p_70300_1_) {
        if (this.field_70128_L) {
            return false;
        }
        return !(p_70300_1_.func_70068_e((Entity)this) > 64.0);
    }

    public Status getStatus() {
        return this.hasWaterOnSides() ? this.getNonStashedStatus() : Status.STASHED;
    }

    private Status getNonStashedStatus() {
        if (this.ticksDeployable < 40) {
            return Status.TRANSITION;
        }
        return this.applyWithDominant(ISpringableEntity::hasWaterOnSides).reduce(true, Boolean::logicalAnd) != false ? Status.DEPLOYED : Status.TRANSITION;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_174888_l() {
    }

    public static enum Status {
        STASHED,
        DEPLOYED,
        TRANSITION;

    }
}

