/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.barge;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.entity.custom.ISpringableEntity;
import dev.murad.shipping.entity.custom.SpringEntity;
import dev.murad.shipping.entity.custom.VesselEntity;
import dev.murad.shipping.util.Train;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.IPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractBargeEntity
extends VesselEntity
implements ISpringableEntity {
    public AbstractBargeEntity(EntityType<? extends AbstractBargeEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
        this.train = new Train(this);
    }

    public AbstractBargeEntity(EntityType<? extends AbstractBargeEntity> type, World worldIn, double x, double y, double z) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected boolean func_184219_q(Entity passenger) {
        return false;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public abstract Item getDropItem();

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K) {
            this.doInteract(player);
        }
        return ActionResultType.CONSUME;
    }

    protected abstract void doInteract(PlayerEntity var1);

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.func_199703_a((IItemProvider)this.getDropItem());
            this.func_70106_y();
            return true;
        }
        return true;
    }

    @Override
    public boolean hasWaterOnSides() {
        return this.field_70170_p.func_180495_p(this.func_226268_ag_().func_177972_a(this.func_174811_aO().func_176746_e())).func_177230_c().equals(Blocks.field_150355_j) && this.field_70170_p.func_180495_p(this.func_226268_ag_().func_177972_a(this.func_174811_aO().func_176746_e())).func_177230_c().equals(Blocks.field_150355_j) && this.field_70170_p.func_180495_p(this.func_226268_ag_().func_177984_a().func_177972_a(this.func_174811_aO().func_176746_e())).func_177230_c().equals(Blocks.field_150350_a) && this.field_70170_p.func_180495_p(this.func_226268_ag_().func_177984_a().func_177972_a(this.func_174811_aO().func_176746_e())).func_177230_c().equals(Blocks.field_150350_a);
    }

    @Override
    public void setDominated(ISpringableEntity entity, SpringEntity spring) {
        this.dominated = Optional.of(new Pair((Object)entity, (Object)spring));
    }

    @Override
    public void setDominant(ISpringableEntity entity, SpringEntity spring) {
        this.setTrain(entity.getTrain());
        this.dominant = Optional.of(new Pair((Object)entity, (Object)spring));
    }

    @Override
    public void removeDominated() {
        if (!this.func_70089_S()) {
            return;
        }
        this.dominated = Optional.empty();
        this.train.setTail(this);
    }

    @Override
    public void removeDominant() {
        if (!this.func_70089_S()) {
            return;
        }
        this.dominant = Optional.empty();
        this.setTrain(new Train(this));
    }

    @Override
    public void setTrain(Train train) {
        this.train = train;
        train.setTail(this);
        this.dominated.ifPresent(dominated -> {
            if (!((ISpringableEntity)dominated.getFirst()).getTrain().equals(train)) {
                ((ISpringableEntity)dominated.getFirst()).setTrain(train);
            }
        });
    }

    public void func_70106_y() {
        this.handleSpringableKill();
        super.func_70106_y();
    }

    public boolean isDockable() {
        return this.dominant.map(dom -> this.func_70068_e((Entity)dom.getFirst()) < 1.1).orElse(true);
    }

    @Override
    public boolean allowDockInterface() {
        return this.isDockable();
    }
}

