/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.capability;

import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class ReadWriteEnergyStorage
implements IEnergyStorage {
    public static final String ENERGY_TAG = "energy";
    private final int maxCapacity;
    private final int maxReceive;
    private final int maxExtract;
    private EnergyStorage proxyStorage;

    public ReadWriteEnergyStorage(int maxCapacity, int maxReceive, int maxExtract) {
        this.maxCapacity = maxCapacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.proxyStorage = null;
    }

    private int clampInclusive(int n, int lo, int hi) {
        return Math.max(lo, Math.min(n, hi));
    }

    public void setEnergy(int energy) {
        this.proxyStorage = new EnergyStorage(this.maxCapacity, this.maxReceive, this.maxExtract, this.clampInclusive(energy, 0, this.maxCapacity));
    }

    public void readAdditionalSaveData(CompoundNBT compound) {
        int energy = compound.func_74764_b(ENERGY_TAG) ? compound.func_74762_e(ENERGY_TAG) : 0;
        this.proxyStorage = new EnergyStorage(this.maxCapacity, this.maxReceive, this.maxExtract, this.clampInclusive(energy, 0, this.maxCapacity));
    }

    public void addAdditionalSaveData(CompoundNBT compound) {
        compound.func_74768_a(ENERGY_TAG, this.proxyStorage.getEnergyStored());
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.proxyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.proxyStorage.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.proxyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.proxyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.proxyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.proxyStorage.canReceive();
    }
}

