/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.vessel_detector;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.block.vessel_detector.VesselDetectorTileEntity;
import dev.murad.shipping.setup.ModTileEntitiesTypes;
import dev.murad.shipping.util.MathUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class VesselDetectorBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final RedstoneParticleData PARTICLE = new RedstoneParticleData(0.9f, 0.65f, 0.2f, 1.0f);

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntitiesTypes.VESSEL_DETECTOR.get()).func_200968_a();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return state.func_177229_b((Property)FACING) == side;
    }

    public int func_180656_a(BlockState state, IBlockReader reader, BlockPos blockPos, Direction direction) {
        return (Boolean)state.func_177229_b((Property)POWERED) != false && direction == state.func_177229_b((Property)FACING) ? 15 : 0;
    }

    public int func_176211_b(BlockState state, IBlockReader reader, BlockPos blockPos, Direction direction) {
        return (Boolean)state.func_177229_b((Property)POWERED) != false && direction == state.func_177229_b((Property)FACING) ? 15 : 0;
    }

    public VesselDetectorBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
        builder.func_206894_a(new Property[]{POWERED});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d())).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    private void showParticles(BlockPos pos, BlockState state, World level) {
        AxisAlignedBB bb = VesselDetectorTileEntity.getSearchBox(pos, (Direction)state.func_177229_b((Property)FACING), level);
        List<Pair<Vector3d, Vector3d>> edges = MathUtil.getEdges(bb);
        for (Pair<Vector3d, Vector3d> edge : edges) {
            Vector3d from = (Vector3d)edge.getFirst();
            Vector3d to = (Vector3d)edge.getSecond();
            for (int i = 0; i < 10; ++i) {
                Vector3d pPos = MathUtil.lerp(from, to, (float)i / 10.0f);
                level.func_195594_a((IParticleData)PARTICLE, pPos.field_72450_a, pPos.field_72448_b, pPos.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity entity, Hand hand, BlockRayTraceResult hit) {
        if (level.func_201670_d()) {
            this.showParticles(pos, state, entity.field_70170_p);
        }
        return ActionResultType.SUCCESS;
    }
}

