/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.block.fluid.render.FluidHopperTileEntityRenderer;
import dev.murad.shipping.entity.container.EnergyTugScreen;
import dev.murad.shipping.entity.container.FishingBargeScreen;
import dev.murad.shipping.entity.container.SteamTugScreen;
import dev.murad.shipping.entity.render.ChestBargeRenderer;
import dev.murad.shipping.entity.render.ChunkLoaderBargeRenderer;
import dev.murad.shipping.entity.render.DummyEntityRenderer;
import dev.murad.shipping.entity.render.EnergyTugRenderer;
import dev.murad.shipping.entity.render.FishingBargeRenderer;
import dev.murad.shipping.entity.render.FluidTankBargeRenderer;
import dev.murad.shipping.entity.render.SeaterBargeRenderer;
import dev.murad.shipping.entity.render.SteamTugRenderer;
import dev.murad.shipping.item.container.TugRouteScreen;
import dev.murad.shipping.setup.ModContainerTypes;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItemModelProperties;
import dev.murad.shipping.setup.ModTileEntitiesTypes;
import dev.murad.shipping.setup.Registration;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="littlelogistics")
public class ShippingMod {
    public static final String MOD_ID = "littlelogistics";
    private static final Logger LOGGER = LogManager.getLogger();

    public ShippingMod() {
        Registration.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ShippingConfig.Client.SPEC, "littlelogistics-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ShippingConfig.Server.SPEC, "littlelogistics-server.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
        LOGGER.info("DIRT BLOCK >> {}", (Object)Blocks.field_150346_d.getRegistryName());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LOGGER.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.CHEST_BARGE.get()), ChestBargeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.CHUNK_LOADER_BARGE.get()), ChunkLoaderBargeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.FISHING_BARGE.get()), FishingBargeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.FLUID_TANK_BARGE.get()), FluidTankBargeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.SEATER_BARGE.get()), SeaterBargeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.SPRING.get()), DummyEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.TUG_DUMMY_HITBOX.get()), DummyEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.STEAM_TUG.get()), SteamTugRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.ENERGY_TUG.get()), EnergyTugRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntitiesTypes.FLUID_HOPPER.get()), FluidHopperTileEntityRenderer::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.TUG_CONTAINER.get()), SteamTugScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.ENERGY_TUG_CONTAINER.get()), EnergyTugScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.FISHING_BARGE_CONTAINER.get()), FishingBargeScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.TUG_ROUTE_CONTAINER.get()), TugRouteScreen::new);
        event.enqueueWork(ModItemModelProperties::register);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Register Block");
        }
    }
}

