/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PortalInfo;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.util.ITeleporter;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.block.TFPortalBlock;
import twilightforest.world.ChunkGeneratorTwilightBase;
import twilightforest.world.TFGenerationSettings;

public class TFTeleporter
implements ITeleporter {
    private static final Map<ResourceLocation, Map<ColumnPos, PortalPosition>> destinationCoordinateCache = new HashMap<ResourceLocation, Map<ColumnPos, PortalPosition>>();
    private static final Object2LongMap<ColumnPos> columnMap = new Object2LongOpenHashMap();
    private static boolean locked;

    public TFTeleporter(boolean locked) {
        TFTeleporter.locked = locked;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerWorld dest, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
        PortalInfo pos = TFTeleporter.placeInExistingPortal(dest, entity, entity.func_233580_cy_(), entity instanceof PlayerEntity);
        if (pos == null) {
            pos = TFTeleporter.moveToSafeCoords(dest, entity);
            TFTeleporter.makePortal(entity, dest, pos.field_222505_a);
            pos = TFTeleporter.placeInExistingPortal(dest, entity, new BlockPos(pos.field_222505_a), entity instanceof PlayerEntity);
        }
        return pos;
    }

    @Nullable
    private static PortalInfo placeInExistingPortal(ServerWorld world, Entity entity, BlockPos pos, boolean isPlayer) {
        PortalPosition portalPosition;
        int i = 200;
        boolean flag = true;
        BlockPos blockpos = BlockPos.field_177992_a;
        ColumnPos columnPos = new ColumnPos(pos);
        if (!isPlayer && columnMap.containsKey((Object)columnPos)) {
            return null;
        }
        PortalPosition portalPosition2 = portalPosition = destinationCoordinateCache.containsKey(world.func_234923_W_().func_240901_a_()) ? destinationCoordinateCache.get(world.func_234923_W_().func_240901_a_()).get(columnPos) : null;
        if (portalPosition != null) {
            blockpos = portalPosition.pos;
            portalPosition.lastUpdateTime = world.func_82737_E();
            flag = false;
        } else {
            double d0 = Double.MAX_VALUE;
            for (int i1 = -i; i1 <= i; ++i1) {
                for (int j1 = -i; j1 <= i; ++j1) {
                    ChunkPos chunkPos;
                    if (!world.func_175723_af().func_177746_a(pos.func_177982_a(i1, 0, j1)) || !world.func_72863_F().field_217237_a.func_241090_h_(chunkPos = new ChunkPos(pos.func_177982_a(i1, 0, j1)))) continue;
                    Chunk chunk = world.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
                    BlockPos blockpos1 = pos.func_177982_a(i1, TFTeleporter.getScanHeight(world, pos) - pos.func_177956_o(), j1);
                    while (blockpos1.func_177956_o() >= 0) {
                        BlockPos blockpos2 = blockpos1.func_177977_b();
                        if (!(d0 >= 0.0 && blockpos1.func_177951_i((Vector3i)pos) >= d0 || !TFTeleporter.isPortal(chunk.func_180495_p(blockpos1)))) {
                            blockpos2 = blockpos1.func_177977_b();
                            while (TFTeleporter.isPortal(chunk.func_180495_p(blockpos2))) {
                                blockpos1 = blockpos2;
                                blockpos2 = blockpos2.func_177977_b();
                            }
                            double d1 = blockpos1.func_177951_i((Vector3i)pos);
                            if (d0 < 0.0 || d1 < d0) {
                                d0 = d1;
                                blockpos = blockpos1;
                                i = MathHelper.func_76123_f((float)MathHelper.func_76133_a((double)d1));
                            }
                        }
                        blockpos1 = blockpos2;
                    }
                }
            }
        }
        if (blockpos.equals((Object)BlockPos.field_177992_a)) {
            long factor = world.func_82737_E() + 300L;
            columnMap.put((Object)columnPos, factor);
            return null;
        }
        if (flag) {
            destinationCoordinateCache.putIfAbsent(world.func_234923_W_().func_240901_a_(), Maps.newHashMapWithExpectedSize((int)4096));
            destinationCoordinateCache.get(world.func_234923_W_().func_240901_a_()).put(columnPos, new PortalPosition(blockpos, world.func_82737_E()));
            world.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(blockpos), 3, (Object)new BlockPos(columnPos.field_219439_a, blockpos.func_177956_o(), columnPos.field_219440_b));
        }
        BlockPos[] portalBorder = TFTeleporter.getBoundaryPositions(world, blockpos).toArray(new BlockPos[0]);
        BlockPos borderPos = portalBorder[0];
        double portalX = (double)borderPos.func_177958_n() + 0.5;
        double portalY = (double)borderPos.func_177956_o() + 1.0;
        double portalZ = (double)borderPos.func_177952_p() + 0.5;
        return TFTeleporter.makePortalInfo(entity, portalX, portalY, portalZ);
    }

    private static int getScanHeight(ServerWorld world, BlockPos pos) {
        return TFTeleporter.getScanHeight(world, pos.func_177958_n(), pos.func_177952_p());
    }

    private static int getScanHeight(ServerWorld world, int x, int z) {
        int worldHeight = world.func_217301_I() - 1;
        int chunkHeight = world.func_212866_a_(x >> 4, z >> 4).func_76625_h() + 15;
        return Math.min(worldHeight, chunkHeight);
    }

    private static boolean isPortal(BlockState state) {
        return state.func_177230_c() == TFBlocks.twilight_portal.get();
    }

    private static Set<BlockPos> getBoundaryPositions(ServerWorld world, BlockPos start) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        checked.add(start);
        TFTeleporter.checkAdjacent(world, start, checked, result);
        return result;
    }

    private static void checkAdjacent(ServerWorld world, BlockPos pos, Set<BlockPos> checked, Set<BlockPos> result) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.func_177972_a(facing);
            if (!checked.add(offset)) continue;
            if (TFTeleporter.isPortalAt(world, offset)) {
                TFTeleporter.checkAdjacent(world, offset, checked, result);
                continue;
            }
            result.add(offset);
        }
    }

    private static boolean isPortalAt(ServerWorld world, BlockPos pos) {
        return TFTeleporter.isPortal(world.func_180495_p(pos));
    }

    private static PortalInfo moveToSafeCoords(ServerWorld world, Entity entity) {
        boolean checkProgression = TFGenerationSettings.isProgressionEnforced((World)world);
        BlockPos pos = entity.func_233580_cy_();
        if (TFTeleporter.isSafeAround((World)world, pos, entity, checkProgression)) {
            TwilightForestMod.LOGGER.debug("Portal destination looks safe!");
            return TFTeleporter.makePortalInfo(entity, entity.func_213303_ch());
        }
        TwilightForestMod.LOGGER.debug("Portal destination looks unsafe, rerouting!");
        BlockPos safeCoords = TFTeleporter.findSafeCoords(world, 200, pos, entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.debug("Safely rerouted!");
            return TFTeleporter.makePortalInfo(entity, safeCoords.func_177958_n(), entity.func_226278_cu_(), safeCoords.func_177952_p());
        }
        TwilightForestMod.LOGGER.info("Did not find a safe portal spot at first try, trying again with longer range.");
        safeCoords = TFTeleporter.findSafeCoords(world, 400, pos, entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.info("Safely rerouted to long range portal.  Return trip not guaranteed.");
            return TFTeleporter.makePortalInfo(entity, safeCoords.func_177958_n(), entity.func_226278_cu_(), safeCoords.func_177952_p());
        }
        TwilightForestMod.LOGGER.warn("Still did not find a safe portal spot.");
        return TFTeleporter.makePortalInfo(entity, entity.func_213303_ch());
    }

    public static boolean isSafeAround(World world, BlockPos pos, Entity entity, boolean checkProgression) {
        if (!TFTeleporter.isSafe(world, pos, entity, checkProgression)) {
            return false;
        }
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (TFTeleporter.isSafe(world, pos.func_177967_a(facing, 16), entity, checkProgression)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSafe(World world, BlockPos pos, Entity entity, boolean checkProgression) {
        return TFTeleporter.checkPos(world, pos) && (!checkProgression || TFTeleporter.checkBiome(world, pos, entity)) && TFTeleporter.checkStructure(world, pos);
    }

    private static boolean checkPos(World world, BlockPos pos) {
        return world.func_175723_af().func_177746_a(pos);
    }

    private static boolean checkStructure(World world, BlockPos pos) {
        ChunkGeneratorTwilightBase generator = TFGenerationSettings.getChunkGenerator(world);
        if (generator != null) {
            return !TFGenerationSettings.locateTFStructureInRange((ISeedReader)((ServerWorld)world), pos, 0).isPresent();
        }
        return true;
    }

    private static boolean checkBiome(World world, BlockPos pos, Entity entity) {
        return TFGenerationSettings.isBiomeSafeFor(world.func_226691_t_(pos), entity);
    }

    @Nullable
    private static BlockPos findSafeCoords(ServerWorld world, int range, BlockPos pos, Entity entity, boolean checkProgression) {
        int attempts = range / 8;
        for (int x = 0; x < attempts; ++x) {
            for (int z = 0; z < attempts; ++z) {
                BlockPos dPos = new BlockPos(pos.func_177958_n() + x * attempts - range / 2, 100, pos.func_177952_p() + z * attempts - range / 2);
                if (!TFTeleporter.isSafeAround((World)world, dPos, entity, checkProgression)) continue;
                return dPos;
            }
        }
        return null;
    }

    private static void makePortal(Entity entity, ServerWorld world, Vector3d pos) {
        TFTeleporter.loadSurroundingArea(world, pos);
        BlockPos spot = TFTeleporter.findPortalCoords(world, pos, blockPos -> TFTeleporter.isPortalAt(world, blockPos));
        String name = entity.func_200200_C_().getString();
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found existing portal for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cachePortalCoords(world, pos, spot);
            return;
        }
        spot = TFTeleporter.findPortalCoords(world, pos, blockpos -> TFTeleporter.isIdealForPortal(world, blockpos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found ideal portal spot for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cachePortalCoords(world, pos, TFTeleporter.makePortalAt((World)world, spot));
            return;
        }
        TwilightForestMod.LOGGER.debug("Did not find ideal portal spot, shooting for okay one for {}", (Object)name);
        spot = TFTeleporter.findPortalCoords(world, pos, blockPos -> TFTeleporter.isOkayForPortal(world, blockPos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found okay portal spot for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cachePortalCoords(world, pos, TFTeleporter.makePortalAt((World)world, spot));
            return;
        }
        TwilightForestMod.LOGGER.debug("Did not even find an okay portal spot, just making a random one for {}", (Object)name);
        double yFactor = TFTeleporter.getYFactor(world);
        TFTeleporter.cachePortalCoords(world, pos, TFTeleporter.makePortalAt((World)world, new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_() * yFactor - 1.0, entity.func_226281_cx_())));
    }

    private static void loadSurroundingArea(ServerWorld world, Vector3d pos) {
        int x = MathHelper.func_76128_c((double)pos.field_72450_a) >> 4;
        int z = MathHelper.func_76128_c((double)pos.field_72448_b) >> 4;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                world.func_212866_a_(x + dx, z + dz);
            }
        }
    }

    @Nullable
    private static BlockPos findPortalCoords(ServerWorld world, Vector3d loc, Predicate<BlockPos> predicate) {
        double yFactor = TFTeleporter.getYFactor(world);
        int entityX = MathHelper.func_76128_c((double)loc.field_72450_a);
        int entityZ = MathHelper.func_76128_c((double)loc.field_72449_c);
        BlockPos.Mutable pos = new BlockPos.Mutable();
        double spotWeight = -1.0;
        BlockPos spot = null;
        int range = 16;
        for (int rx = entityX - range; rx <= entityX + range; ++rx) {
            double xWeight = (double)rx + 0.5 - loc.field_72450_a;
            for (int rz = entityZ - range; rz <= entityZ + range; ++rz) {
                double zWeight = (double)rz + 0.5 - loc.field_72449_c;
                for (int ry = TFTeleporter.getScanHeight(world, rx, rz); ry >= 0; --ry) {
                    if (!world.func_175623_d((BlockPos)pos.func_181079_c(rx, ry, rz))) continue;
                    while (ry > 0 && world.func_175623_d((BlockPos)pos.func_181079_c(rx, ry - 1, rz))) {
                        --ry;
                    }
                    double yWeight = (double)ry + 0.5 - loc.field_72448_b * yFactor;
                    double rPosWeight = xWeight * xWeight + yWeight * yWeight + zWeight * zWeight;
                    if (!(spotWeight < 0.0) && !(rPosWeight < spotWeight) || !predicate.test((BlockPos)pos)) continue;
                    spotWeight = rPosWeight;
                    spot = pos.func_185334_h();
                }
            }
        }
        return spot;
    }

    private static double getYFactor(ServerWorld world) {
        return world.func_234923_W_().func_240901_a_().equals((Object)World.field_234918_g_.func_240901_a_()) ? 2.0 : 0.5;
    }

    private static void cachePortalCoords(ServerWorld world, Vector3d loc, BlockPos pos) {
        int x = MathHelper.func_76128_c((double)loc.field_72450_a);
        int z = MathHelper.func_76128_c((double)loc.field_72449_c);
        destinationCoordinateCache.putIfAbsent(world.func_234923_W_().func_240901_a_(), Maps.newHashMapWithExpectedSize((int)4096));
        destinationCoordinateCache.get(world.func_234923_W_().func_240901_a_()).put(new ColumnPos(x, z), new PortalPosition(pos, world.func_82737_E()));
    }

    private static boolean isIdealForPortal(ServerWorld world, BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    BlockPos tPos = pos.func_177982_a(potentialX - 1, potentialY, potentialZ - 1);
                    Material material = world.func_180495_p(tPos).func_185904_a();
                    if ((potentialY != 0 || material == Material.field_151577_b) && (potentialY < 1 || material.func_76222_j())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static BlockPos makePortalAt(World world, BlockPos pos) {
        if (pos.func_177956_o() < 30) {
            pos = new BlockPos(pos.func_177958_n(), 30, pos.func_177952_p());
        } else if (pos.func_177956_o() > 118) {
            pos = new BlockPos(pos.func_177958_n(), 118, pos.func_177952_p());
        }
        BlockState grass = Blocks.field_196658_i.func_176223_P();
        world.func_175656_a(pos.func_177976_e().func_177978_c(), grass);
        world.func_175656_a(pos.func_177978_c(), grass);
        world.func_175656_a(pos.func_177974_f().func_177978_c(), grass);
        world.func_175656_a(pos.func_177965_g(2).func_177978_c(), grass);
        world.func_175656_a(pos.func_177976_e(), grass);
        world.func_175656_a(pos.func_177965_g(2), grass);
        world.func_175656_a(pos.func_177976_e().func_177968_d(), grass);
        world.func_175656_a(pos.func_177965_g(2).func_177968_d(), grass);
        world.func_175656_a(pos.func_177976_e().func_177970_e(2), grass);
        world.func_175656_a(pos.func_177970_e(2), grass);
        world.func_175656_a(pos.func_177974_f().func_177970_e(2), grass);
        world.func_175656_a(pos.func_177965_g(2).func_177970_e(2), grass);
        BlockState dirt = Blocks.field_150346_d.func_176223_P();
        world.func_175656_a(pos.func_177977_b(), dirt);
        world.func_175656_a(pos.func_177974_f().func_177977_b(), dirt);
        world.func_175656_a(pos.func_177968_d().func_177977_b(), dirt);
        world.func_175656_a(pos.func_177974_f().func_177968_d().func_177977_b(), dirt);
        BlockState portal = (BlockState)((TFPortalBlock)TFBlocks.twilight_portal.get()).func_176223_P().func_206870_a((Property)TFPortalBlock.DISALLOW_RETURN, (Comparable)Boolean.valueOf(locked || (Boolean)TFConfig.COMMON_CONFIG.shouldReturnPortalBeUsable.get() == false));
        world.func_180501_a(pos, portal, 2);
        world.func_180501_a(pos.func_177974_f(), portal, 2);
        world.func_180501_a(pos.func_177968_d(), portal, 2);
        world.func_180501_a(pos.func_177974_f().func_177968_d(), portal, 2);
        for (int dx = -1; dx <= 2; ++dx) {
            for (int dz = -1; dz <= 2; ++dz) {
                for (int dy = 1; dy <= 5; ++dy) {
                    world.func_217377_a(pos.func_177982_a(dx, dy, dz), false);
                }
            }
        }
        world.func_180501_a(pos.func_177976_e().func_177978_c().func_177984_a(), TFTeleporter.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177978_c().func_177984_a(), TFTeleporter.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177974_f().func_177978_c().func_177984_a(), TFTeleporter.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177965_g(2).func_177978_c().func_177984_a(), TFTeleporter.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177976_e().func_177984_a(), TFTeleporter.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177965_g(2).func_177984_a(), TFTeleporter.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177976_e().func_177968_d().func_177984_a(), TFTeleporter.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177965_g(2).func_177968_d().func_177984_a(), TFTeleporter.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177976_e().func_177970_e(2).func_177984_a(), TFTeleporter.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177970_e(2).func_177984_a(), TFTeleporter.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177974_f().func_177970_e(2).func_177984_a(), TFTeleporter.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177965_g(2).func_177970_e(2).func_177984_a(), TFTeleporter.randNatureBlock(world.field_73012_v), 2);
        return pos;
    }

    private static BlockState randNatureBlock(Random random) {
        Block[] blocks = new Block[]{Blocks.field_150338_P, Blocks.field_150337_Q, Blocks.field_150349_c, Blocks.field_196606_bd, Blocks.field_196605_bc};
        return blocks[random.nextInt(blocks.length)].func_176223_P();
    }

    private static boolean isOkayForPortal(ServerWorld world, BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    BlockPos tPos = pos.func_177982_a(potentialX - 1, potentialY, potentialZ - 1);
                    Material material = world.func_180495_p(tPos).func_185904_a();
                    if ((potentialY != 0 || material.func_76220_a() || material.func_76224_d()) && (potentialY < 1 || material.func_76222_j())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static PortalInfo makePortalInfo(Entity entity, double x, double y, double z) {
        return TFTeleporter.makePortalInfo(entity, new Vector3d(x, y, z));
    }

    private static PortalInfo makePortalInfo(Entity entity, Vector3d pos) {
        return new PortalInfo(pos, Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
    }

    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        entity.field_70143_R = 0.0f;
        return repositionEntity.apply(false);
    }

    static class PortalPosition {
        public final BlockPos pos;
        long lastUpdateTime;

        PortalPosition(BlockPos pos, long time) {
            this.pos = pos;
            this.lastUpdateTime = time;
        }
    }
}

